package com.tydic.dyc.oc.model.aforder.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.*;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.UocAfOrderDo;
import com.tydic.dyc.oc.model.aforder.qrybo.*;
import com.tydic.dyc.oc.model.aforder.sub.*;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.repository.*;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderFinishConfirmReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderFinishConfirmRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderSupplierConfirmReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderSupplierConfirmRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspItemBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 标题:UocAfOrderModelImpl
 * 说明:售后单
 * 时间:2022/3/8 18:10
 * 作者:罗有
 */

@Service
@Slf4j
public class UocAfOrderModelImpl implements IUocAfOrderModel {
    @Autowired
    private UocAfOrderRepository uocAfOrderRepository;
    @Autowired
    private UocCommonRepository uocCommonRepository;
    @Autowired
    private UocSaleOrderRepository saleOrderRepository;
    @Autowired
    private UocShipOrderRepository shipOrderRepository;

    @Autowired
    private UocInspOrderRepository inspOrderRepository;

    @Autowired
    private UocOrderRepository orderRepository;
    @Autowired
    private UocSaleOrderRepository uocSaleOrderRepository;

    @Override
    public List<UocAfOrderItem> getAfOrderItemList(UocAfOrderItemQryBo uocAfOrderItemQryBo) {
        if (ObjectUtil.isNull(uocAfOrderItemQryBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocAfOrderRepository.getAfOrderItemList(uocAfOrderItemQryBo);
    }

    @Override
    public UocAfOrder getAfOrderById(UocAfOrderQryBo uocAfOrderQryBo) {
        if (ObjectUtil.isNull(uocAfOrderQryBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocAfOrderRepository.getAfOrderById(uocAfOrderQryBo);
    }

    @Override
    public List<UocAfOrder> getAfOrderList(UocAfOrderQryBo uocAfOrderQryBo) {
        if (ObjectUtil.isNull(uocAfOrderQryBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocAfOrderRepository.getAfOrderList(uocAfOrderQryBo);
    }

    @Override
    public List<UocAfOrderObj> getAfOrderObjList(UocAfOrderObjQryBo uocAfOrderObjQryBo) {
        if (ObjectUtil.isNull(uocAfOrderObjQryBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocAfOrderRepository.getAfOrderObjList(uocAfOrderObjQryBo);
    }

    @Override
    public List<UocAfOrderMap> getAfOrderMapList(UocAfOrderMapQryBo uocAfOrderMapQryBo) {
        if (ObjectUtil.isNull(uocAfOrderMapQryBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocAfOrderRepository.getAfOrderMapList(uocAfOrderMapQryBo);
    }

    @Override
    public List<UocAfOrderWaybill> getAfOrderWayBillList(UocAfOrderWaybillQryBo uocAfOrderWaybillQryBo) {
        if (ObjectUtil.isNull(uocAfOrderWaybillQryBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocAfOrderRepository.getAfOrderWayBillList(uocAfOrderWaybillQryBo);
    }

    @Override
    public UocAfOrderDo dealPebTheZoneAfterApplication(UocAfOrderDo afOrderDo, Integer orderSource) {
        if (ObjectUtil.isNull(afOrderDo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        afOrderDo.setAfOrderId(IdUtil.nextId());
        afOrderDo.setServState(UocDicConstant.SERVICE_STATE.SUMIT_APPLICATION);
        afOrderDo.setWaybillFlag(0);
        UocAfOrderDo afterOrderNo = getAfterOrderNo(new UocAfOrderDo(), orderSource);
        afOrderDo.setAfServCode(afterOrderNo.getAfServCode());
        List<UocAfOrderMap> extParallelBoList = afOrderDo.getExtParallelBoList();
        if (ObjectUtil.isNotEmpty(extParallelBoList)) {
            for (UocAfOrderMap uocAfOrderMap : extParallelBoList) {
                uocAfOrderMap.setAfOrderId(afOrderDo.getAfOrderId());
                uocAfOrderMap.setId(IdUtil.nextId());
                uocAfOrderMap.setOrderId(afOrderDo.getOrderId());
                uocAfOrderMap.setSaleOrderId(afOrderDo.getSaleOrderId());
//                uocAfOrderMap.setShipOrderId();
            }
        }
        UocOrdLogisticsRela takeAddress = afOrderDo.getTakeAddress();
        if (ObjectUtil.isNotEmpty(takeAddress)) {
            takeAddress.setContactId(IdUtil.nextId());
            takeAddress.setOrderId(afOrderDo.getOrderId());
            takeAddress.setCreateTime(new Date());
            afOrderDo.setTpContactId(takeAddress.getContactId());
        }
        UocOrdLogisticsRela returnAddress = afOrderDo.getReturnAddress();
        if (ObjectUtil.isNotEmpty(returnAddress)) {
            returnAddress.setContactId(IdUtil.nextId());
            returnAddress.setOrderId(afOrderDo.getOrderId());
            returnAddress.setCreateTime(new Date());
            afOrderDo.setContactId(returnAddress.getContactId());
        }
        List<UocAfOrderObj> afOrderObjList = afOrderDo.getAfOrderObjList();
        if (ObjectUtil.isNotEmpty(afOrderObjList)) {
            for (UocAfOrderObj uocAfOrderObj : afOrderObjList) {
                uocAfOrderObj.setAfOrderId(afOrderDo.getAfOrderId());
                uocAfOrderObj.setId(IdUtil.nextId());
                uocAfOrderObj.setCreateTime(new Date());
                uocAfOrderObj.setOrderId(afOrderDo.getOrderId());
                uocAfOrderObj.setCreateOperId(afOrderDo.getCreateOperId());
            }
        }
        List<UocAfOrderItem> afOrderItemBoList = afOrderDo.getAfOrderItemBoList();
        if (ObjectUtil.isNotEmpty(afOrderItemBoList)) {
            for (UocAfOrderItem uocAfOrderItem : afOrderItemBoList) {
                uocAfOrderItem.setAfOrderId(afOrderDo.getAfOrderId());
                uocAfOrderItem.setAfOrderItemId(IdUtil.nextId());
            }
        }
        List<UocOrderAccessory> orderAccessoryBoList = afOrderDo.getOrderAccessoryBoList();
        if (ObjectUtil.isNotEmpty(orderAccessoryBoList)) {
            for (UocOrderAccessory uocOrderAccessory : orderAccessoryBoList) {
                uocOrderAccessory.setOrderId(afOrderDo.getOrderId());
                uocOrderAccessory.setObjId(afOrderDo.getAfOrderId());
                uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.AFTER);
                uocOrderAccessory.setCreateTime(new Date());
                uocOrderAccessory.setCreateOperId(afOrderDo.getCreateOperId());
                uocOrderAccessory.setId(IdUtil.nextId());
            }
        }
        return uocAfOrderRepository.saveAfterOder(afOrderDo);
    }

    @Override
    public UocAfOrderDo getAfterOrderNo(UocAfOrderDo afOrderDo, Integer orderSource) {
        if (null == afOrderDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        String orderNo = uocCommonRepository.getOrderNoSingle(UocObjNoConstants.ORDER_AS_NO + "_" + orderSource);
        afOrderDo.setAfServCode(orderNo);
        return afOrderDo;
    }

    @Override
    public List<UocAfItemMap> getAfOrderItemMapList(UocAfItemMapQryBo uocAfItemMapQryBo) {
        if (ObjectUtil.isNull(uocAfItemMapQryBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocAfOrderRepository.getAfOrderItemMapList(uocAfItemMapQryBo);
    }

    @Override
    public void updateAfOrderMain(UocAfOrderDo uocAfOrderDo) {
        if (ObjectUtil.isNull(uocAfOrderDo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        uocAfOrderRepository.modifyAfOrder(uocAfOrderDo);
    }

    @Override
    public void updateBatchAfOrderMain(List<UocAfOrderDo> afOrderDos) {
        if (ObjectUtil.isNotEmpty(afOrderDos)) {
            uocAfOrderRepository.modifyBatchAfOrderRemark(afOrderDos);
        }
    }

    @Override
    public void modifyAfOrderExtOrderId(UocAfOrderDo afOrderDo) {
        if (ObjectUtil.isNotEmpty(afOrderDo)) {
            uocAfOrderRepository.modifyAfOrderExtOrderId(afOrderDo);
        }
    }

    @Override
    public void addWayBill(UocAfOrderWaybill uocAfOrderWaybill) {
        if (ObjectUtil.isNotEmpty(uocAfOrderWaybill)) {
            uocAfOrderWaybill.setId(IdUtil.nextId());
            uocAfOrderRepository.saveAfOrderWayBill(uocAfOrderWaybill);
        }
    }

    @Override
    public void modifyAfOrderState(UocAfOrderDo afOrderDo) {
        if (ObjectUtil.isNotEmpty(afOrderDo)) {
            uocAfOrderRepository.modifyAfOrderState(afOrderDo);
        }
    }

    @Override
    public boolean confirmAfOrderState(UocAfterOrderSupplierConfirmReqBo reqBo, Integer flag, UocAfterOrderSupplierConfirmRspBo rspBo) {

        List<Long> inspOrderIdList = new ArrayList<>();

        if (ObjectUtil.isNotEmpty(reqBo)) {
            UocAfOrderDo afOrderDo = new UocAfOrderDo();
            afOrderDo.setOrderId(reqBo.getOrderId());
            afOrderDo.setAfOrderId(reqBo.getAfOrderId());
            UocAfOrderQryBo uocAfOrderQryBo = UocRu.js(afOrderDo, UocAfOrderQryBo.class);
            UocAfOrder afOrder = uocAfOrderRepository.getAfOrderById(uocAfOrderQryBo);
            UocAfOrderItemQryBo uocAfOrderItemQryBo = UocRu.js(afOrderDo, UocAfOrderItemQryBo.class);
            List<UocAfOrderItem> afOrderItemList = uocAfOrderRepository.getAfOrderItemList(uocAfOrderItemQryBo);
            if (flag == 0) {
                //防止定时任务先消费state 1 再消费state 0
                if (UocDicConstant.SERVICE_STATE.REMARK_COMPLATE.equals(afOrder.getServState())||
                        UocDicConstant.SERVICE_STATE.COMPLATE.equals(afOrder.getServState())) {
                    log.info("售后单："+reqBo.getAfOrderId()+"已经已经消费了state1");
                    rspBo.setSaleOrderId(afOrder.getSaleOrderId());
                    return false;
                }
                //防止重复执行
                if (UocDicConstant.SERVICE_STATE.APPROVAL_PASS.equals(afOrder.getServState())) {
                    rspBo.setSaleOrderId(afOrder.getSaleOrderId());
                    return false;
                }
                afOrderDo.setServState(UocDicConstant.SERVICE_STATE.APPROVAL_PASS);
                afOrderDo.setConfirmTime(reqBo.getDateTime());
                // 如果是客户发货，通过之后可以维护发运信息
                if (UocConstant.PICKWARETYPE.CUSTOMSHIP.equals(afOrder.getPickwareType())) {
                    afOrderDo.setWaybillFlag(1);
                }
                rspBo.setSaleOrderId(afOrder.getSaleOrderId());
            } else if (flag == 1) {
                //防止重复执行
                if (UocDicConstant.SERVICE_STATE.REMARK_COMPLATE.equals(afOrder.getServState())) {
                    rspBo.setSaleOrderId(afOrder.getSaleOrderId());
                    return false;
                }
                updateAfteringCount(reqBo, afOrderItemList, afOrder, flag);
                afOrderDo.setServState(UocDicConstant.SERVICE_STATE.REMARK_COMPLATE);
                afOrderDo.setWaybillFlag(0);
                //电商跳过同意售后标记售后完成，确认时间取完成时间
                if(null == afOrder.getConfirmTime()){
                    afOrderDo.setConfirmTime(reqBo.getDateTime());
                }
                /*String payType = afOrder.getPayType();
                //查询销售单状态
                UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
                uocSaleOrderDo.setOrderId(afOrder.getOrderId());
                uocSaleOrderDo.setSaleOrderId(afOrder.getSaleOrderId());
                UocSaleOrderDo saleOrderMain = saleOrderRepository.getSaleOrderMain(uocSaleOrderDo);
                Integer modelSettle = saleOrderMain.getModelSettle();*/

                /*if (UocDicConstant.SERVICE_TYPE.RETURN_GOODS.equals(afOrder.getServType())) {
                    if (UocDicConstant.PAY_TYPE.PAY_BY_PERIOD.toString().equals(payType)) {
                        afOrderDo.setPayState(UocDicConstant.PAY_AFTER_STATE.AMOUNT__DUE_UPDATED);
                        //封装出参-> 需调用扣减授信
                    *//*if (UocDicConstant.SERVICE_TYPE.RETURN_GOODS.equals(afOrder.getServType())) {
                        UocOrderStakeholderQryBo uocOrderStakeholderQryBo = new UocOrderStakeholderQryBo();
                        uocOrderStakeholderQryBo.setStakeholderId(saleOrderMain.getStakeholderId());
                        List<UocOrderStakeholderQryBo> uocOrderStakeholderQryBos = orderRepository.qryStakeholderList(uocOrderStakeholderQryBo);
                        UocOrderStakeholderQryBo uocOrderStakeholderQryBo1 = uocOrderStakeholderQryBos.get(0);
                        String purOrgId = uocOrderStakeholderQryBo1.getPurOrgId();
                        rspBo.setPurOrgId(purOrgId);
                        if (UocDicConstant.MODEL_SETTLE.TRADE.equals(modelSettle)) {
                            rspBo.setSupId(uocOrderStakeholderQryBo1.getProId());
                        } else if (UocDicConstant.MODEL_SETTLE.MATCH.equals(modelSettle)) {
                            rspBo.setSupId(uocOrderStakeholderQryBo1.getSupId());
                        }
                        rspBo.setAmount(afOrder.getRealReturnFee().negate());
                    }*//*
                    } else if (UocDicConstant.PAY_TYPE.ADVANCE_PAYMENT_PRORATED.toString().equals(payType)) {
                        afOrderDo.setPayState(UocDicConstant.PAY_AFTER_STATE.ALL_REFUNDED);
                    }
                }*/
                buildRspBo(rspBo, afOrder, afOrderItemList, flag);
            } else if (flag == 2) {
                updateAfteringCount(reqBo, afOrderItemList, afOrder, flag);
                afOrderDo.setServState(UocDicConstant.SERVICE_STATE.APPROVAL_NOT_PASS);
                //如果是退货，更新付款状态为已取消
                if (UocConstant.AFTERORDER_SERVTYPE.RETURN.equals(afOrder.getServType())) {
                    afOrderDo.setPayState(UocDicConstant.PAY_AFTER_STATE.CANCELED);
                }
                afOrderDo.setCancelTime(reqBo.getDateTime());
                afOrderDo.setWaybillFlag(0);
                buildRspBo(rspBo, afOrder, afOrderItemList, flag);
            }
            afOrderDo.setUpdateTime(new Date());
            uocAfOrderRepository.modifyAfOrderState(afOrderDo);


            // 邮储改造
            UocAfOrderDo qryAfOrderDo = new UocAfOrderDo();
            qryAfOrderDo.setOrderId(reqBo.getOrderId());
            qryAfOrderDo.setAfOrderId(reqBo.getAfOrderId());
            UocAfOrderQryBo uocAfOrderQryBo2 = UocRu.js(qryAfOrderDo, UocAfOrderQryBo.class);
            UocAfOrder afOrder2 = uocAfOrderRepository.getAfOrderById(uocAfOrderQryBo2);

            UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
            uocSaleOrderQryBo.setOrderId(afOrder2.getOrderId());
            uocSaleOrderQryBo.setSaleOrderId(afOrder2.getSaleOrderId());
            UocSaleOrderDo saleOrderMainInfo = this.uocSaleOrderRepository.qrySaleOrder(uocSaleOrderQryBo);

            // 如果销售单为已验收，要扣减验收单验收数量
            if (UocStateConstants.SaleOrder.XS_YS_YS.equals(saleOrderMainInfo.getSaleOrderState())) {
                UocAfOrderItemQryBo uocAfOrderItemQryBo2 = UocRu.js(qryAfOrderDo, UocAfOrderItemQryBo.class);
                List<UocAfOrderItem> afOrderItemList2 = uocAfOrderRepository.getAfOrderItemList(uocAfOrderItemQryBo2);
                for (UocAfOrderItem uocAfOrderItem : afOrderItemList2) {

                    BigDecimal returnCount = uocAfOrderItem.getReturnCount();

                    if (uocAfOrderItem.getShipItemId() == null) {
                        throw new BaseBusinessException(UocRspConstants.RSP_CODE_FAIL, "售后单明细的发货单明细id为空");
                    }
                    UocInspOrderItemQryBo qryBO = new UocInspOrderItemQryBo();
                    qryBO.setShipOrderItemId(uocAfOrderItem.getShipItemId());
                    UocInspOrderDo inspOrderItemList = inspOrderRepository.getInspOrderItemList(qryBO);
                    if (CollectionUtils.isEmpty(inspOrderItemList.getUocInspOrderItemList())) {
                        throw new BaseBusinessException(UocRspConstants.RSP_CODE_FAIL, "未查询到验收单明细");
                    }
                    UocInspOrderDo convertInspOrderDo = new UocInspOrderDo();
                    convertInspOrderDo.setInspOrderId(inspOrderItemList.getUocInspOrderItemList().get(0).getInspOrderId());
                    convertInspOrderDo.setShipOrderItemId(uocAfOrderItem.getShipItemId());
                    convertInspOrderDo.setInspCount(returnCount.multiply(new BigDecimal(-1)));

                    UocSaleOrderItemQryBo saleOrderItemQryBo = new UocSaleOrderItemQryBo();
                    saleOrderItemQryBo.setSaleOrderItemId(uocAfOrderItem.getSaleItemId());
                    UocSaleOrderDo listSaleOrderItem = saleOrderRepository.getListSaleOrderItem(saleOrderItemQryBo);
                    UocSaleOrderItem saleOrderItem = listSaleOrderItem.getSaleOrderItems().get(0);

                    //变更销售价
                    convertInspOrderDo.setTotalSaleFee(saleOrderItem.getSalePrice().multiply(returnCount));
                    //变更采购价
                    convertInspOrderDo.setTotalPurchaseFee(saleOrderItem.getPurchasePrice().multiply(returnCount));
                    inspOrderRepository.modifyBatchItemInspConfirm(convertInspOrderDo);

                    inspOrderIdList.add(convertInspOrderDo.getInspOrderId());
                    rspBo.setInspOrderIdList(inspOrderIdList);
                }
            }




        }
        return true;
    }

    private void buildRspBo(UocAfterOrderSupplierConfirmRspBo rspBo, UocAfOrder afOrder, List<UocAfOrderItem> afOrderItemList, Integer flag) {
        UocAfOrderItem uocAfOrderItem = afOrderItemList.get(0);
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setOrderId(uocAfOrderItem.getOrderId());
        uocShipOrderItemQryBo.setShipOrderItemId(uocAfOrderItem.getShipItemId());
        List<UocShipOrderItem> shipOrderItem = shipOrderRepository.getShipOrderItem(uocShipOrderItemQryBo);
        rspBo.setSaleOrderId(afOrder.getSaleOrderId());
        rspBo.setShipOrderId(shipOrderItem.get(0).getShipOrderId());
    }

    private void updateAfteringCount(UocAfterOrderSupplierConfirmReqBo reqBo, List<UocAfOrderItem> afOrderItemList, UocAfOrder afOrder, Integer flag) {
        for (UocAfOrderItem uocAfOrderItem : afOrderItemList) {
            Long orderItemId = uocAfOrderItem.getSaleItemId();
            Long shipItemId = uocAfOrderItem.getShipItemId();
            Long orderId = uocAfOrderItem.getOrderId();
            BigDecimal returnCount = uocAfOrderItem.getReturnCount();
            //修改发货单在途数量
            UocShipOrderItem uocShipOrderItem = new UocShipOrderItem();
            uocShipOrderItem.setOrderId(orderId);
            uocShipOrderItem.setShipOrderItemId(shipItemId);
            uocShipOrderItem.setAfterServingCount(returnCount.negate());
            Integer servType = afOrder.getServType();
            if (UocDicConstant.SERVICE_TYPE.RETURN_GOODS.equals(servType) && flag == 1) {
                uocShipOrderItem.setReturnCount(returnCount);
                uocShipOrderItem.setArriveCount(returnCount.negate());
            }
            uocShipOrderItem.setUpdateTime(new Date());
            uocShipOrderItem.setUpdateOperId(Optional.ofNullable(reqBo.getUserId()).toString());
            shipOrderRepository.modifyShipOrderItemAfterServingCount(uocShipOrderItem);
            //修改销售单在途数量
            UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
            uocSaleOrderItem.setOrderId(orderId);
            uocSaleOrderItem.setSaleOrderItemId(orderItemId);
            uocSaleOrderItem.setAfterServingCount(returnCount.negate());
            if (UocDicConstant.SERVICE_TYPE.RETURN_GOODS.equals(servType) && flag == 1) {
                uocSaleOrderItem.setReturnCount(returnCount);
                uocSaleOrderItem.setArriveCount(returnCount.negate());
            }
            uocSaleOrderItem.setUpdateTime(new Date());
            uocSaleOrderItem.setUpdateOperId(Optional.ofNullable(reqBo.getUserId()).toString());
            saleOrderRepository.modifySaleOrderItemAfterServingCount(uocSaleOrderItem);
        }
    }

    @Override
    public void modifyAfterOrderCount(UocAfterOrderFinishConfirmReqBo reqBo, UocAfterOrderFinishConfirmRspBo rspBo) {
        UocAfOrderDo afOrderDo = new UocAfOrderDo();
        afOrderDo.setOrderId(reqBo.getOrderId());
        afOrderDo.setAfOrderId(reqBo.getAfOrderId());
        UocAfOrderQryBo uocAfOrderQryBo = UocRu.js(afOrderDo, UocAfOrderQryBo.class);
        UocAfOrder afOrder = uocAfOrderRepository.getAfOrderById(uocAfOrderQryBo);
        UocAfOrderItemQryBo uocAfOrderItemQryBo = UocRu.js(afOrderDo, UocAfOrderItemQryBo.class);
        List<UocAfOrderItem> afOrderItemList = uocAfOrderRepository.getAfOrderItemList(uocAfOrderItemQryBo);

        //查询销售单，用于回退预算
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setOrderId(afOrder.getOrderId());
        uocSaleOrderQryBo.setSaleOrderId(afOrder.getSaleOrderId());
        UocSaleOrderDo saleOrderMainInfo = this.uocSaleOrderRepository.qrySaleOrder(uocSaleOrderQryBo);
        rspBo.setSaleOrderId(saleOrderMainInfo.getSaleOrderId());
        rspBo.setSaleOrderNo(saleOrderMainInfo.getSaleOrderNo());
        rspBo.setBudgetId(saleOrderMainInfo.getBudgetId());
        rspBo.setPurCompanyId(saleOrderMainInfo.getStakeholder().getPurCompanyId());
        rspBo.setSupplierId(saleOrderMainInfo.getStakeholder().getSupId());
        List<UocGetSaleOrderDetailServiceRspItemBo> uocGetSaleOrderDetailServiceRspItemBos = new ArrayList<>();

        //查询发货单明细对应的销售单明细
        List<UocSaleOrderItem> saleOrderItemInfos = this.getSaleOrderItemInfos(afOrder, afOrderItemList.stream().map(UocAfOrderItem::getSaleItemId).distinct().collect(Collectors.toList()));
        Map<Long, UocSaleOrderItem> saleOrderItemMap = saleOrderItemInfos.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, u -> u));
        for (UocAfOrderItem uocAfOrderItem : afOrderItemList) {
            Long orderItemId = uocAfOrderItem.getSaleItemId();
            Long shipItemId = uocAfOrderItem.getShipItemId();
            Long orderId = uocAfOrderItem.getOrderId();
            BigDecimal returnCount = uocAfOrderItem.getReturnCount();
            //修改发货单在途数量
            UocShipOrderItem uocShipOrderItem = new UocShipOrderItem();
            uocShipOrderItem.setOrderId(orderId);
            uocShipOrderItem.setShipOrderItemId(shipItemId);
            //取相反数
            uocShipOrderItem.setAfterServingCount(returnCount.negate());
            Integer servType = afOrder.getServType();
            //如果是退货服务 那么设置数量 这里就是供应商确认完成
            if (UocDicConstant.SERVICE_TYPE.RETURN_GOODS.equals(servType)) {
                uocShipOrderItem.setReturnCount(returnCount);
                uocShipOrderItem.setArriveCount(returnCount.negate());
            }
            uocShipOrderItem.setUpdateTime(new Date());
            uocShipOrderItem.setUpdateOperId(Optional.ofNullable(reqBo.getUserId()).toString());
            shipOrderRepository.modifyShipOrderItemAfterServingCount(uocShipOrderItem);
            //修改销售单在途数量
            UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
            uocSaleOrderItem.setOrderId(orderId);
            uocSaleOrderItem.setSaleOrderItemId(orderItemId);
            uocSaleOrderItem.setAfterServingCount(returnCount.negate());
            if (UocDicConstant.SERVICE_TYPE.RETURN_GOODS.equals(servType)) {
                uocSaleOrderItem.setReturnCount(returnCount);
                uocSaleOrderItem.setArriveCount(returnCount.negate());
            }
            uocSaleOrderItem.setUpdateTime(new Date());
            uocSaleOrderItem.setUpdateOperId(Optional.ofNullable(reqBo.getUserId()).toString());
            saleOrderRepository.modifySaleOrderItemAfterServingCount(uocSaleOrderItem);
            UocSaleOrderItem saleOrderItem = saleOrderItemMap.get(orderItemId);
            //如果是组合商品，还要修改子商品的在途数量,退货数量
            if (UocConstant.ItemType.COMB.equals(saleOrderItem.getItemType())) {
                for (UocSaleOrderItem subCommodityBo : saleOrderItem.getSubCommodityBos()) {
                    UocSaleOrderItem subUocSaleOrderItem = new UocSaleOrderItem();
                    subUocSaleOrderItem.setOrderId(orderId);
                    subUocSaleOrderItem.setSaleOrderItemId(subCommodityBo.getSaleOrderItemId());
                    subUocSaleOrderItem.setAfterServingCount((returnCount.multiply(subCommodityBo.getCombSubRelCount())).negate());
                    if (UocDicConstant.SERVICE_TYPE.RETURN_GOODS.equals(servType)) {
                        subUocSaleOrderItem.setReturnCount(returnCount.multiply(subCommodityBo.getCombSubRelCount()));
                        subUocSaleOrderItem.setArriveCount((returnCount.multiply(subCommodityBo.getCombSubRelCount())).negate());
                    }
                    subUocSaleOrderItem.setUpdateTime(new Date());
                    subUocSaleOrderItem.setUpdateOperId(Optional.ofNullable(reqBo.getUserId()).toString());
                    saleOrderRepository.modifySaleOrderItemAfterServingCount(subUocSaleOrderItem);

                    //销售单明细,用于回退预算和库存
                    UocGetSaleOrderDetailServiceRspItemBo subUocGetSaleOrderDetailServiceRspItemBo = UocRu.js(subCommodityBo, UocGetSaleOrderDetailServiceRspItemBo.class);
                    subUocGetSaleOrderDetailServiceRspItemBo.setPurchaseCount(subUocSaleOrderItem.getReturnCount());
                    uocGetSaleOrderDetailServiceRspItemBos.add(subUocGetSaleOrderDetailServiceRspItemBo);
                }
            }else {
                //销售单明细,用于回退预算和库存
                UocGetSaleOrderDetailServiceRspItemBo uocGetSaleOrderDetailServiceRspItemBo = UocRu.js(saleOrderItem, UocGetSaleOrderDetailServiceRspItemBo.class);
                uocGetSaleOrderDetailServiceRspItemBo.setPurchaseCount(uocSaleOrderItem.getReturnCount());
                uocGetSaleOrderDetailServiceRspItemBos.add(uocGetSaleOrderDetailServiceRspItemBo);
            }
        }
        rspBo.setAgreementId(saleOrderItemInfos.get(0).getAgreementId());
        rspBo.setUocGetSaleOrderDetailServiceRspItemBos(uocGetSaleOrderDetailServiceRspItemBos);

    }

    /**
     * 查询销售单明细
     * @param afOrder
     * @param saleOrderItemIdList
     * @return
     */
    private List<UocSaleOrderItem> getSaleOrderItemInfos(UocAfOrder afOrder, List<Long> saleOrderItemIdList) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        //设置销售单明细id集合
        uocSaleOrderItemQryBo.setSaleOrderItemIdList(saleOrderItemIdList);
        //设置销售单id
        uocSaleOrderItemQryBo.setSaleOrderId(afOrder.getSaleOrderId());
        //设置订单id
        uocSaleOrderItemQryBo.setOrderId(afOrder.getOrderId());
        UocSaleOrderDo uocSaleOrderDo = this.uocSaleOrderRepository.qryListSaleOrderItem(uocSaleOrderItemQryBo);
        if (null != uocSaleOrderDo && !CollectionUtils.isEmpty(uocSaleOrderDo.getSaleOrderItems())) {
            //如果是组合商品，还需要吧子商品查出来
            if (uocSaleOrderDo.getSaleOrderItems().stream().anyMatch(bo -> UocConstant.ItemType.COMB.equals(bo.getItemType()))) {
                uocSaleOrderItemQryBo.setSaleOrderItemIdList(null);
                uocSaleOrderItemQryBo.setCombSaleOrderItemIdList(uocSaleOrderDo.getSaleOrderItems().stream().filter(bo->UocConstant.ItemType.COMB.equals(bo.getItemType())).map(UocSaleOrderItem::getSaleOrderItemId).collect(Collectors.toList()));
                List<UocSaleOrderItem> subSaleItemList = uocSaleOrderRepository.getSaleOrderItemList(uocSaleOrderItemQryBo);
                Map<Long, List<UocSaleOrderItem>> subSaleItemMap = subSaleItemList.stream().collect(Collectors.groupingBy(UocSaleOrderItem::getCombSaleItemId));
                uocSaleOrderDo.getSaleOrderItems().forEach(bo -> {
                    if (UocConstant.ItemType.COMB.equals(bo.getItemType())) {
                        bo.setSubCommodityBos(subSaleItemMap.get(bo.getSaleOrderItemId()));
                    }
                });
            }
            return uocSaleOrderDo.getSaleOrderItems();
        }else{
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARRIVA_ACCEPTANCE_ERROR, "获取销售明细为空");
        }
    }

    @Override
    public List<UocAfOrderObj> getAfOrderObjList(UocAfterOrderFinishConfirmReqBo reqBo) {
        return uocAfOrderRepository.getAfOrderObjList(UocRu.js(reqBo,UocAfOrderObjQryBo.class));
    }
    
    @Override
    public List<UocAfOrderDo> getCheckAfOrders(UocAfOrderDo record) {
        return uocAfOrderRepository.getCheckAfOrders(UocRu.js(record,UocAfOrderDo.class));
    }
}
