package com.tydic.dyc.oc.model.chngorder;

import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemMap;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderMap;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocChngOrderDo
 * 说明:变更单
 * 时间:2022-03-08 17:49
 * 作者:罗有
 **/
@Data
@EqualsAndHashCode(callSuper=false)
public class UocChngOrderDo implements Serializable {
    private static final long serialVersionUID = 5980326960021296095L;

    //变更单id")
    private Long chngOrderId;

    //订单id")
    private Long orderId;

    //业务类型 1:异常变更 2订单调价3订单取消")
    private Integer busiType;

    //变更单编号")
    private String chngOrderNo;

    //变更单状态")
    private String chngOrderState;

    //变更单类型")
    private Integer chngType;

    //变更单类型翻译")
    private String chngTypeStr;

    //变更单状态 翻译")
    private String chngOrderStateStr;

    //租户ID")
    private String tenantId;

    //创建时间")
    private Date createTime;

    //创建工号")
    private String createOperId;

    //创建人名称")
    private String createOperName;

    //创建手机号")
    private String createOperMobile;

    //更新时间")
    private Date updateTime;

    //更新工号")
    private String updateOperId;

    //更新人名称")
    private String updateOperName;

    //备注")
    private String remark;

    //删除标志1已删除")
    private Integer delTag;

    //撤单时间")
    private Date cancelTime;

    //撤单工号")
    private String cancelOperId;

    //撤单人名称")
    private String cancelOperName;

    //撤单原因")
    private String cancelReason;

    //竣工时间")
    private Date finishTime;

    //逾期时间")
    private Date expTime;

    //拒绝原因")
    private String rejectReason;

    //拒绝时间")
    private Date rejectTime;

    //发货单编号")
    private String shipOrderNo;

    //发货单状态")
    private String shipOrderState;

    //发货单状态翻译")
    private String shipOrderStateStr;

    //验收时间")
    private Date inspTime;

    //验收人名称")
    private String inspOperName;

    //验收金额")
    private BigDecimal inspSaleFee;
    //验收单状态")
    private String inspOrderState;

    //验收单状态翻译")
    private String inspOrderStateStr;
    //单据状态") 发货单或验收单
    private String objOrderState;

    //单据状态翻译") 发货单或验收单
    private String objOrderStateStr;

    //扩展字段1")
    private String extField1;

    //扩展字段2")
    private String extField2;

    //扩展字段3")
    private String extField3;

    //扩展字段4")
    private String extField4;

    //扩展字段5")
    private String extField5;

    //变更对象")
    private List<UocChngOrderObj> uocChngOrderObjList;

    //变更扩展")
    private List<UocChngOrderMap> uocChngOrderMapList;

    //附件")
    private List<UocOrderAccessory> orderAccessoryBoList;

    //变更明细扩展")
    private List<UocChngOrderItemMap> uocChngOrderItemMapList;


    /**
     * 里面的销售单明细
     */
    private List<Long> saleOrderItemIds;
}
