package com.tydic.dyc.oc.model.cmporder.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.cmporder.IUocCmpOrderModel;
import com.tydic.dyc.oc.model.cmporder.UocCmpOrderDo;
import com.tydic.dyc.oc.model.cmporder.qrybo.UocCmpOrderQryBo;
import com.tydic.dyc.oc.model.cmporder.qrybo.UocDelCmpOrderBo;
import com.tydic.dyc.oc.model.cmporder.qrybo.UocQryCmpOrderNoBo;
import com.tydic.dyc.oc.model.cmporder.qrybo.UocUpdateCmpOrderBo;
import com.tydic.dyc.oc.model.cmporder.sub.UocCmpItemMap;
import com.tydic.dyc.oc.model.cmporder.sub.UocCmpOrderItem;
import com.tydic.dyc.oc.model.cmporder.sub.UocCmpOrderMap;
import com.tydic.dyc.oc.repository.UocCmpOrderRepository;
import com.tydic.dyc.oc.utils.IdUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.List;

/**
 * 标题：类名称:UocCmpOrderModelImpl
 * 说明：描述一下类的作用TODO
 * 时间：2022/3/29 13:53
 * 作者 @author 尹栋梁
 */
@Service
public class UocCmpOrderModelImpl implements IUocCmpOrderModel {

    @Autowired
    private UocCmpOrderRepository uocCmpOrderRepository;
    @Override
    public UocCmpOrderDo createCmpOrder(UocCmpOrderDo uocCmpOrderDo) {
        valCreateCmpOrderDo(uocCmpOrderDo);
        long cmpId = IdUtil.nextId();
        String no = biuldNo("", "BJ-");
        uocCmpOrderDo.setCmpOrderId(cmpId);
        uocCmpOrderDo.setCmpOrderNo(no);
        List<UocCmpOrderItem> uocCmpOrderItemList = uocCmpOrderDo.getUocCmpOrderItemList();
        if (CollectionUtil.isNotEmpty(uocCmpOrderItemList)) {
            for (int i = 0; i < uocCmpOrderItemList.size(); i++) {
                UocCmpOrderItem uocCmpOrderItem = uocCmpOrderItemList.get(i);
                uocCmpOrderItem.setCmpOrderId(cmpId);
                uocCmpOrderItem.setCmpOrderItemId(IdUtil.nextId());
                if(!CollectionUtils.isEmpty(uocCmpOrderItem.getUocCmpItemMapList())){
                    for (UocCmpItemMap uocCmpItemMap : uocCmpOrderItem.getUocCmpItemMapList()) {
                        uocCmpItemMap.setOrderId(uocCmpOrderDo.getOrderId());
                        uocCmpItemMap.setId(IdUtil.nextId());
                        uocCmpItemMap.setCmpOrderItemId(uocCmpOrderItem.getCmpOrderItemId());
                        uocCmpItemMap.setCreateOperId(uocCmpOrderDo.getCreateOperId());
                        uocCmpItemMap.setCreateTime(uocCmpOrderDo.getCreateTime());
                    }
                }
            }
        }
        if(!CollectionUtils.isEmpty(uocCmpOrderDo.getUocCmpOrderMapList())){
            for (UocCmpOrderMap uocCmpOrderMap : uocCmpOrderDo.getUocCmpOrderMapList()) {
                uocCmpOrderMap.setId(IdUtil.nextId());
                uocCmpOrderMap.setCmpOrderId(cmpId);
                uocCmpOrderMap.setOrderId(uocCmpOrderDo.getOrderId());
                uocCmpOrderMap.setCreateOperId(uocCmpOrderDo.getCreateOperId());
                uocCmpOrderMap.setCreateTime(uocCmpOrderDo.getCreateTime());
            }
        }
        uocCmpOrderRepository.createCmpOrder(uocCmpOrderDo);
        return uocCmpOrderDo;
    }

    @Override
    public UocCmpOrderQryBo qryCmpOrder(UocCmpOrderQryBo uocCmpOrderDo) {
        valQryCmpOrderDetail(uocCmpOrderDo);
        return uocCmpOrderRepository.qryCmpOrder(uocCmpOrderDo);
    }

    @Override
    public UocQryCmpOrderNoBo qryCmpOrderNoBySkuIdAndUserId(UocQryCmpOrderNoBo qryBo) {
        return uocCmpOrderRepository.qryCmpOrderNoBySkuIdAndUserId(qryBo);
    }

    @Override
    public int dealCmpOrder(UocDelCmpOrderBo uocDelCmpOrderBo) {
       return uocCmpOrderRepository.dealCmpOrder(uocDelCmpOrderBo);
    }

    @Override
    public int updateCmpOrder(UocUpdateCmpOrderBo uocUpdateCmpOrderBo) {
        return uocCmpOrderRepository.updateCmpOrder(uocUpdateCmpOrderBo);
    }

    @Override
    public UocQryCmpOrderNoBo qryAlreadyHaveCmpOrderNo(UocQryCmpOrderNoBo qryBo) {
        return uocCmpOrderRepository.qryAlreadyHaveCmpOrderNo(qryBo);
    }

    private void valQryCmpOrderDetail(UocCmpOrderQryBo uocCmpOrderDo) {
        if (null == uocCmpOrderDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (StringUtils.isBlank(uocCmpOrderDo.getCmpOrderNo()) && null == uocCmpOrderDo.getCmpOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参比价单编号或ID不能同时为空");
        }
    }

    private void valCreateCmpOrderDo(UocCmpOrderDo uocCmpOrderDo) {
        if (null == uocCmpOrderDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (CollectionUtil.isEmpty(uocCmpOrderDo.getUocCmpOrderItemList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参比价单明细列表不能为空");
        }
    }
    private String biuldNo(String planNo, String pro) {
        String date = DateUtils.dateToStr(new Date()).replaceAll("-", "");
        String time = String.valueOf(System.currentTimeMillis());
        String no = "";
        if (StringUtils.isNotBlank(pro)) {
            no = no + pro;
        }
        no = no + date + time.substring(time.length() - 6);
        if (no.equals(planNo)) {
            no =  biuldNo(no, pro);
        }
        UocCmpOrderDo uocCmpOrderDo = new UocCmpOrderDo();
        uocCmpOrderDo.setCmpOrderNo(no);
        int count = uocCmpOrderRepository.getCheckBy(uocCmpOrderDo);
        if (count > 0) {
            no = biuldNo(no, pro);
        }
        return no;
    }
}
