package com.tydic.dyc.oc.model.common;

import com.tydic.dyc.oc.model.common.sub.UocFile;
import com.tydic.dyc.oc.service.domainservice.bo.UocEsSyncBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocTaskBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocFinishTaskInfoBo;

import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspItemBo;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * 标题:UocCommonDo
 * 说明:公共do
 * 时间:2022/4/1 10:22
 * 作者:罗有
 */

@Data
@EqualsAndHashCode(callSuper=false)
public class UocCommonDo implements Serializable {
	private static final long serialVersionUID = -8484142274189423430L;

	private UocFile uocFile;

	//订单id", required = true)
	private Long orderId;

	//已完成任务信息")
	private List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> completeTaskInfos;

	//下一步任务信息")
	private List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> nextTaskInfos;
	
	//操作类型")
	private String opFlag;

	private Long userId;

	private String username;
	/**
	 * 执行了前加签的任务ID
	 */
	private String preTaskId;
	/**
	 * 执行了回退的任务ID
	 */
	private String returnTaskId;
	/**
	 *  修改任务处理人
	 */
	private UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo updateTaskCandidate;
	/**
	 * 已办任务信息
	 */
	private List<UocFinishTaskInfoBo> finishTaskInfoBos;

	/**
	 * 撤回任务信息
	 */
	private List<UocTaskBO> recallTaskInfos;
	/**
	 * 同步销售单集合
	 */
	private List<UocEsSyncBO> syncSaleOrderList;
	/**
	 * 同步变更单集合
	 */
	private List<UocEsSyncBO> syncChngOrderList;
	/**
	 * 同步发货单集合
	 */
	private List<UocEsSyncBO> syncShipOrderList;
	/**
	 * 同步验收单集合
	 */
	private List<UocEsSyncBO> syncInspOrderList;
	/**
	 * 同步售后单集合
	 */
	private List<UocEsSyncBO> syncAfterOrderList;
	/**
	 * 预算id
	 */
	private Long budgetId;
	/**
	 * 协议id(用于翻译)
	 **/
	private String agreementId;
	/**
	 * 采购方公司id
	 */
	private String purCompanyId;
	/**
	 * 供应商id
	 */
	private String supplierId;
	/**
	 * 销售单id
	 */
	private Long saleOrderId;
	/**
	 * 销售单编码
	 */
	private String saleOrderNo;
	/**
	 * 销售单明细
	 */
	List<UocGetSaleOrderDetailServiceRspItemBo> uocGetSaleOrderDetailServiceRspItemBos;

}
