package com.tydic.dyc.oc.model.payorder.sub;


import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 标题:UocPayOrder
 * 说明:支付单
 * 时间:2022-02-21 19:11
 * 作者:罗有
 **/
@Data
@EqualsAndHashCode(callSuper=false)
public class UocPayOrder implements Serializable {
	private static final long serialVersionUID =  8208620837787203712L;

	//支付单id")
	private Long payOrderId;

	//订单id")
	private Long orderId;

	//支付名称")
	private String payName;

	//支付类型            1 线上支付    2 线下支付")
	private Integer payMod;

	//支付方式             1 微信             2 支付宝             3 企业支付")
	private Integer payType;

	//支付优先级")
	private String payLevel;

	//外部支付流水")
	private String outPayOrderNo;

	//退款/扣款标志             0 扣款             1 退款")
	private Integer interType;

	//应付金额")
	private BigDecimal totalFee;

	//应付金额占比")
	private BigDecimal totalFeeSup;

	//减免金额")
	private BigDecimal reduceFee;

	//红包金额")
	private BigDecimal redEnvelopeFee;

	//活动金额")
	private BigDecimal actFee;

	//实付金额")
	private BigDecimal payFee;

	//违约金比例")
	private BigDecimal penaltyRatio;

	//已付金额")
	private BigDecimal paidFee;

	//支付金额类型")
	private Integer payFeeType;

	//支付状态")
	private String payState;

	//备注")
	private String remark;

	//付款方ID")
	private String payerId;

	//付款方名称")
	private String payerName;

	//收款方ID")
	private String payeeId;

	//收款方名称")
	private String payeeName;

	//合同编号")
	private String contractNo;

	//合同ID")
	private String contractId;

	//租户ID")
	private String tenantId;

	//支付工号")
	private String payOperId;

	//支付时间")
	private Date payTime;

	//竣工标志             1 竣工             0 在途")
	private Integer finishFlag;

	//创建时间")
	private Date createTime;

	//创建工号")
	private String createOperId;

	//更新时间")
	private Date updateTime;

	//更新工号")
	private String updateOperId;

	//撤单时间")
	private Date cancelTime;

	//撤单工号")
	private String cancelOperId;

	//撤单原因")
	private String cancelReason;

	//撤单标志:1 已撤单             0 未撤单")
	private Integer cancelFlag;

	//竣工时间")
	private Date finishTime;

	//逾期时间")
	private Date expTime;



}
