/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.service.saleorder.UocDealFailedOrderService;
import com.tydic.dyc.oc.service.saleorder.bo.UocDealFieldOrderReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocDealFieldOrderRspBo;
import com.tydic.dyc.oc.transactionservice.UocDealFailedOrderTransaction;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.saleorder.UocDealFailedOrderService"})
public class UocDealFailedOrderServiceImpl
implements UocDealFailedOrderService {
    private static final Logger log = LoggerFactory.getLogger(UocDealFailedOrderServiceImpl.class);
    @Autowired
    private UocDealFailedOrderTransaction uocDealFailedOrderTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @PostMapping(value={"dealFailedOrder"})
    public UocDealFieldOrderRspBo dealFailedOrder(@RequestBody UocDealFieldOrderReqBo reqBo) {
        UocDealFieldOrderRspBo rspBo = this.uocDealFailedOrderTransaction.dealFailedOrder(reqBo);
        if ("0000".equals(rspBo.getRespCode())) {
            this.syncEs(reqBo);
        }
        return rspBo;
    }

    private void syncEs(UocDealFieldOrderReqBo reqBo) {
        ArrayList<SyncEsRunnableBo> list = new ArrayList<SyncEsRunnableBo>();
        SyncEsRunnableBo saleBo = new SyncEsRunnableBo();
        saleBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
        saleBo.setOrderId(reqBo.getOrderId());
        saleBo.setObjId(reqBo.getSaleOrderId());
        saleBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(saleBo);
        this.uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }
}

