package com.tydic.dyc.oc.service.cmporder;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.cmporder.IUocCmpOrderModel;
import com.tydic.dyc.oc.model.cmporder.UocCmpOrderDo;
import com.tydic.dyc.oc.model.cmporder.qrybo.UocCmpOrderQryBo;
import com.tydic.dyc.oc.model.cmporder.sub.UocCmpItemMap;
import com.tydic.dyc.oc.model.cmporder.sub.UocCmpOrderItem;
import com.tydic.dyc.oc.service.cmporder.bo.UocCartBo;
import com.tydic.dyc.oc.service.cmporder.bo.UocCreateCmpOrderImageDataBo;
import com.tydic.dyc.oc.service.cmporder.bo.UocCreateCmpOrderImageDataReqBo;
import com.tydic.dyc.oc.service.cmporder.bo.UocCreateCmpOrderImageDataRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

/**
 * 标题:UocCreateCmpOrderImageDataServiceImpl
 * 说明:生成比选镜像数据
 * 时间:2024/4/26 15:33
 * 作者:罗有
 */

@HTServiceImpl
public class UocCreateCmpOrderImageDataServiceImpl implements UocCreateCmpOrderImageDataService {

	@Autowired
	private IUocCmpOrderModel uocCmpOrderModel;

	@Override
	public UocCreateCmpOrderImageDataRspBo createCmpOrderImageData(UocCreateCmpOrderImageDataReqBo reqBo) {
		val(reqBo);

		Map<Long, UocCartBo> cartMap;
		if(!CollectionUtils.isEmpty(reqBo.getCartBoList())){
			cartMap = reqBo.getCartBoList().stream().collect(Collectors.toConcurrentMap(UocCartBo::getSkuId, o -> o, (o1, o2) -> o1));
		} else {
			cartMap = new HashMap<>();
		}
		List<Long> cmpOrderIds = reqBo.getCmpOrderList().stream().map(UocCreateCmpOrderImageDataBo::getCmpOrderId).distinct().collect(Collectors.toList());

		Map<Long, UocCreateCmpOrderImageDataBo> map = new HashMap<>();
		cmpOrderIds.forEach(cmpOrderId -> {
			//查询必选单详情
			UocCmpOrderQryBo uocCmpOrderQryBo = new UocCmpOrderQryBo();
			uocCmpOrderQryBo.setCmpOrderId(cmpOrderId);
			UocCmpOrderQryBo qryCmpResult = this.uocCmpOrderModel.qryCmpOrder(uocCmpOrderQryBo);
			if (null == qryCmpResult) {
				throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "必选单详情查询为空！");
			}
			//新增必选单
			UocCmpOrderDo uocCmpOrderDo = JSON.parseObject(JSON.toJSONString(qryCmpResult), UocCmpOrderDo.class);
			uocCmpOrderDo.setCreateTime(new Date());
			uocCmpOrderDo.setCreateOperName(reqBo.getName());
			uocCmpOrderDo.setCreateOperId(reqBo.getUserId().toString());
			uocCmpOrderDo.setCreateOrgId(String.valueOf(reqBo.getOrgId()));
			uocCmpOrderDo.setCreateOrgName(reqBo.getOrgName());
			uocCmpOrderDo.setUpdateTime(null);
			uocCmpOrderDo.setUpdateOperId(null);
			List<UocCmpOrderItem> uocCmpOrderItemList = uocCmpOrderDo.getUocCmpOrderItemList();
			for (UocCmpOrderItem uocCmpOrderItem : uocCmpOrderItemList) {
				calItemMap(cartMap, cmpOrderId, uocCmpOrderItem);
			}
			uocCmpOrderModel.createCmpOrder(uocCmpOrderDo);
			UocCreateCmpOrderImageDataBo uocCreateCmpOrderImageDataBo = new UocCreateCmpOrderImageDataBo();
			uocCreateCmpOrderImageDataBo.setCmpOrderNo(uocCmpOrderDo.getCmpOrderNo());
			uocCreateCmpOrderImageDataBo.setNewCmpOrderId(uocCmpOrderDo.getCmpOrderId());
			map.put(cmpOrderId, uocCreateCmpOrderImageDataBo);
		});

		for (UocCreateCmpOrderImageDataBo uocCreateCmpOrderImageDataBo : reqBo.getCmpOrderList()) {
			UocCreateCmpOrderImageDataBo createCmpOrderImageDataBo = map.get(uocCreateCmpOrderImageDataBo.getCmpOrderId());
			uocCreateCmpOrderImageDataBo.setNewCmpOrderId(createCmpOrderImageDataBo.getNewCmpOrderId());
			uocCreateCmpOrderImageDataBo.setCmpOrderNo(createCmpOrderImageDataBo.getCmpOrderNo());
		}

		UocCreateCmpOrderImageDataRspBo rspBo = new UocCreateCmpOrderImageDataRspBo();
		rspBo.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
		rspBo.setCmpOrderList(reqBo.getCmpOrderList());
		return rspBo;
	}

	private static void calItemMap(Map<Long, UocCartBo> cartMap, Long cmpOrderId, UocCmpOrderItem uocCmpOrderItem) {
		List<UocCmpItemMap> uocCmpItemMaps = new ArrayList<>();
		UocCartBo uocCartBo = cartMap.get(Convert.toLong(uocCmpOrderItem.getSkuId()));
		if(null != uocCartBo) {
			UocCmpItemMap uocCmpItemMap1 = new UocCmpItemMap();
			uocCmpItemMap1.setFieldCode("relCmpOrdFlag");
			uocCmpItemMap1.setFieldName("是否关联比选");
			if(cmpOrderId.equals(uocCartBo.getCmpOrderId())) {
				uocCmpItemMap1.setFieldValue("1");
			} else {
				uocCmpItemMap1.setFieldValue("0");
			}
			uocCmpItemMaps.add(uocCmpItemMap1);
			UocCmpItemMap uocCmpItemMap11 = new UocCmpItemMap();
			uocCmpItemMap11.setFieldCode("relCmpOrdFlagStr");
			uocCmpItemMap11.setFieldName("是否关联比选");
			if(cmpOrderId.equals(uocCartBo.getCmpOrderId())) {
				uocCmpItemMap11.setFieldValue("已关联比选单");
			} else {
				uocCmpItemMap11.setFieldValue("未关联比选单");
			}
			uocCmpItemMaps.add(uocCmpItemMap11);

			UocCmpItemMap uocCmpItemMap2 = new UocCmpItemMap();
			uocCmpItemMap2.setFieldCode("addShoppingCartFlag");
			uocCmpItemMap2.setFieldName("是否已加购");
			uocCmpItemMap2.setFieldValue("1");
			uocCmpItemMaps.add(uocCmpItemMap2);

			UocCmpItemMap uocCmpItemMap22 = new UocCmpItemMap();
			uocCmpItemMap22.setFieldCode("addShoppingCartFlagStr");
			uocCmpItemMap22.setFieldName("是否已加购");
			uocCmpItemMap22.setFieldValue("已加入购物车");
			uocCmpItemMaps.add(uocCmpItemMap22);

		} else {

			UocCmpItemMap uocCmpItemMap1 = new UocCmpItemMap();
			uocCmpItemMap1.setFieldCode("relCmpOrdFlag");
			uocCmpItemMap1.setFieldName("是否关联比选");
			uocCmpItemMap1.setFieldValue("0");
			uocCmpItemMaps.add(uocCmpItemMap1);

			UocCmpItemMap uocCmpItemMap11 = new UocCmpItemMap();
			uocCmpItemMap11.setFieldCode("relCmpOrdFlagStr");
			uocCmpItemMap11.setFieldName("是否关联比选");
			uocCmpItemMap11.setFieldValue("未关联比选单");
			uocCmpItemMaps.add(uocCmpItemMap11);

			UocCmpItemMap uocCmpItemMap2 = new UocCmpItemMap();
			uocCmpItemMap2.setFieldCode("addShoppingCartFlag");
			uocCmpItemMap2.setFieldName("是否已加购");
			uocCmpItemMap2.setFieldValue("0");
			uocCmpItemMaps.add(uocCmpItemMap2);

			UocCmpItemMap uocCmpItemMap22 = new UocCmpItemMap();
			uocCmpItemMap22.setFieldCode("addShoppingCartFlagStr");
			uocCmpItemMap22.setFieldName("是否已加购");
			uocCmpItemMap22.setFieldValue("未加入购物车");
			uocCmpItemMaps.add(uocCmpItemMap22);
		}
		uocCmpOrderItem.setUocCmpItemMapList(uocCmpItemMaps);
	}

	private void val(UocCreateCmpOrderImageDataReqBo reqBo) {
		if(CollectionUtils.isEmpty(reqBo.getCmpOrderList())){
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参比选单为空");
		}
		for (UocCreateCmpOrderImageDataBo uocCreateCmpOrderImageDataBo : reqBo.getCmpOrderList()) {

			if(null == uocCreateCmpOrderImageDataBo.getCmpOrderId()){
				throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参比选单ID为空");
			}
			if(null == uocCreateCmpOrderImageDataBo.getSkuId()){
				throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参单品ID为空");
			}
		}
	}
}
