package com.tydic.dyc.oc.service.domainservice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.transactionservice.UocCreateOrderServiceTransaction;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceRspSaleOrderBo;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 描述 订单中心下单服务
 * @author tgy
 * @date 2023/8/28 15:28
 * @Copyright 2023 www.tydic.com Inc. All rights reserved.
 * 注意 本内容仅限于北京天源迪科信息技术有限公司内部传阅，禁止外泄以及用于其他商业目的;
 */
@HTServiceImpl
@Slf4j
public class UocCreateOrderServiceImpl implements UocCreateOrderService {

    @Autowired
    private UocCreateOrderServiceTransaction uocCreateOrderServiceTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public UocCreateOrderServiceRspBo createOrder(UocCreateOrderServiceReqBo reqBo) {
        UocCreateOrderServiceRspBo rspBo = uocCreateOrderServiceTransaction.createOrder(reqBo);
        if (UocRspConstants.RSP_CODE_SUCCESS.equals(rspBo.getRespCode())) {
            //本地线程同步es
            syncEs(reqBo, rspBo);
        }
        return rspBo;
    }

    private void syncEs(UocCreateOrderServiceReqBo reqBo, UocCreateOrderServiceRspBo rspBo) {
        List<SyncEsRunnableBo> list = new ArrayList<>();
        SyncEsRunnableBo orderBo = new SyncEsRunnableBo();
        orderBo.setIndexName(uocIndexConfig.getOrderIndex());
        orderBo.setOrderId(rspBo.getOrderId());
        orderBo.setObjId(rspBo.getOrderId());
        orderBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(orderBo);

        for (UocCreateOrderServiceRspSaleOrderBo uocCreateOrderServiceRspSaleOrderBo : rspBo.getSaleOrderList()) {
            SyncEsRunnableBo saleBo = new SyncEsRunnableBo();
            saleBo.setIndexName(uocIndexConfig.getSaleOrderIndex());
            saleBo.setOrderId(rspBo.getOrderId());
            saleBo.setObjId(uocCreateOrderServiceRspSaleOrderBo.getSaleOrderId());
            saleBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
            list.add(saleBo);

            if (!CollectionUtils.isEmpty(uocCreateOrderServiceRspSaleOrderBo.getShipOrderIds())) {
                uocCreateOrderServiceRspSaleOrderBo.getShipOrderIds().forEach(item -> {
                    SyncEsRunnableBo shipBo = new SyncEsRunnableBo();
                    shipBo.setIndexName(uocIndexConfig.getShipOrderIndex());
                    shipBo.setOrderId(rspBo.getOrderId());
                    shipBo.setObjId(item);
                    shipBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
                    list.add(shipBo);
                });
            }
            if (null != uocCreateOrderServiceRspSaleOrderBo.getInspOrderId()) {
                SyncEsRunnableBo inspBo = new SyncEsRunnableBo();
                inspBo.setIndexName(uocIndexConfig.getInspOrderIndex());
                inspBo.setOrderId(rspBo.getOrderId());
                inspBo.setObjId(uocCreateOrderServiceRspSaleOrderBo.getInspOrderId());
                inspBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
                list.add(inspBo);
            }

            /*JSONArray supSignInfos = JSON.parseArray(JSON.toJSONString(reqBo.getSupplierBos()));
            Map<String, JSONObject> jsonObjectMap = supSignInfos.stream().collect(Collectors.toMap(item -> ((JSONObject) item).getString("supplierId"), item -> ((JSONObject) item)));
            //同步成交服务费
            SyncEsRunnableBo transactionBo = new SyncEsRunnableBo();
            transactionBo.setIndexName(uocIndexConfig.getTransactionIndex());
            transactionBo.setOrderId(reqBo.getOrderId());
            transactionBo.setObjId(uocCreateOrderServiceRspSaleOrderBo.getSaleOrderId());
            transactionBo.setJsonObj(jsonObjectMap.get(uocCreateOrderServiceRspSaleOrderBo.getSupId()));
            transactionBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
            transactionBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
            list.add(transactionBo);*/
        }

        uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }
}