package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.oc.constants.UocAttachementTypeConstants;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryAddBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocUploadOfficalReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocUploadOfficalRspBO;
import com.tydic.dyc.oc.utils.IdUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 描述: 用印申请上传
 *
 * @author : yuhao
 * @date : 2022/7/27 15:47
 */
@HTServiceImpl
@Slf4j
public class UocUploadOfficalServiceImpl implements UocUploadOfficalService{

    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;

    @Override
    public UocUploadOfficalRspBO dealUploadOffical(UocUploadOfficalReqBO reqBO) {
        UocUploadOfficalRspBO rspBO = new UocUploadOfficalRspBO();

        this.saveAccessoryInfo(reqBO);
        //提交任务
        this.commitTask(reqBO);


        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);

        return rspBO;
    }

    /**
     * 提交任务
     * @param reqBO
     */
    private void commitTask(UocUploadOfficalReqBO reqBO) {
        UocCommonDo uocCommonDo = new UocCommonDo();
        List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskInfos = new ArrayList<>();
        UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo task = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
        task.setTaskId(reqBO.getTaskId());
        taskInfos.add(task);
        uocCommonDo.setCompleteTaskInfos(taskInfos);
        uocCommonDo.setUserId(reqBO.getUserId());
        uocCommonDo.setOrderId(reqBO.getOrderId());
        this.iUocCommonModel.dealTask(uocCommonDo);
    }

    private void saveAccessoryInfo(UocUploadOfficalReqBO reqBO) {
        List<UocOrderAccessory> uocOrderAccessoryList = new ArrayList<>();
        for (UocBaseOrderAccessoryAddBo uocBaseOrderAccessoryAddBo : reqBO.getOrderAccessoryBoList()) {
            UocOrderAccessory uocOrderAccessory = new UocOrderAccessory();
            BeanUtils.copyProperties(uocBaseOrderAccessoryAddBo, uocOrderAccessory);
            uocOrderAccessory.setId(IdUtil.nextId());
            uocOrderAccessory.setObjId(reqBO.getSaleOrderId());
            uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.SALE);
            uocOrderAccessory.setOrderId(reqBO.getOrderId());
            uocOrderAccessory.setCreateTime(new Date());
            uocOrderAccessory.setCreateOperId(String.valueOf(reqBO.getUserId()));
            uocOrderAccessory.setAttachmentType(UocAttachementTypeConstants.SALE_ORDER_OFFICAL);
            uocOrderAccessoryList.add(uocOrderAccessory);
        }
        this.iUocOrderModel.createOrderAccessory(uocOrderAccessoryList);
    }
}
