package com.tydic.dyc.oc.transactionservice;

import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.saleorder.bo.UocDealFieldOrderReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocDealFieldOrderRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/**
 * 标题:UocDealFailedOrderTransaction
 * 说明:
 * 时间:2023/8/28 15:25
 * 作者:田桂银
 */
@Component
@Slf4j
public class UocDealFailedOrderTransaction {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public UocDealFieldOrderRspBo dealFailedOrder(UocDealFieldOrderReqBo reqBo) {
        UocDealFieldOrderRspBo rspBo = UocRu.success(UocDealFieldOrderRspBo.class);
        UocSaleOrderDo updateExtOrderIdDo = new UocSaleOrderDo();
        updateExtOrderIdDo.setOrderId(reqBo.getOrderId());
        updateExtOrderIdDo.setSaleOrderId(reqBo.getSaleOrderId());
        updateExtOrderIdDo.setSaleOrderState(UocStateConstants.SaleOrder.XS_XD_SB);
        updateExtOrderIdDo.setCancelReason(reqBo.getCancelReason());
        iUocSaleOrderModel.modifySaleOrderMain(updateExtOrderIdDo);
        return rspBo;
    }
}
