/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.service.domainservice.UocCreateOrderService;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceRspSaleOrderBo;
import com.tydic.dyc.oc.transactionservice.UocCreateOrderServiceTransaction;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocCreateOrderService"})
public class UocCreateOrderServiceImpl
implements UocCreateOrderService {
    private static final Logger log = LoggerFactory.getLogger(UocCreateOrderServiceImpl.class);
    @Autowired
    private UocCreateOrderServiceTransaction uocCreateOrderServiceTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @PostMapping(value={"createOrder"})
    public UocCreateOrderServiceRspBo createOrder(@RequestBody UocCreateOrderServiceReqBo reqBo) {
        UocCreateOrderServiceRspBo rspBo = this.uocCreateOrderServiceTransaction.createOrder(reqBo);
        if ("0000".equals(rspBo.getRespCode())) {
            this.syncEs(reqBo, rspBo);
        }
        return rspBo;
    }

    private void syncEs(UocCreateOrderServiceReqBo reqBo, UocCreateOrderServiceRspBo rspBo) {
        ArrayList<SyncEsRunnableBo> list = new ArrayList<SyncEsRunnableBo>();
        SyncEsRunnableBo orderBo = new SyncEsRunnableBo();
        orderBo.setIndexName(this.uocIndexConfig.getOrderIndex());
        orderBo.setOrderId(rspBo.getOrderId());
        orderBo.setObjId(rspBo.getOrderId());
        orderBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(orderBo);
        for (UocCreateOrderServiceRspSaleOrderBo uocCreateOrderServiceRspSaleOrderBo : rspBo.getSaleOrderList()) {
            SyncEsRunnableBo saleBo = new SyncEsRunnableBo();
            saleBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
            saleBo.setOrderId(rspBo.getOrderId());
            saleBo.setObjId(uocCreateOrderServiceRspSaleOrderBo.getSaleOrderId());
            saleBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
            list.add(saleBo);
            if (!CollectionUtils.isEmpty((Collection)uocCreateOrderServiceRspSaleOrderBo.getShipOrderIds())) {
                uocCreateOrderServiceRspSaleOrderBo.getShipOrderIds().forEach(item -> {
                    SyncEsRunnableBo shipBo = new SyncEsRunnableBo();
                    shipBo.setIndexName(this.uocIndexConfig.getShipOrderIndex());
                    shipBo.setOrderId(rspBo.getOrderId());
                    shipBo.setObjId((Long)item);
                    shipBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
                    list.add(shipBo);
                });
            }
            if (null == uocCreateOrderServiceRspSaleOrderBo.getInspOrderId()) continue;
            SyncEsRunnableBo inspBo = new SyncEsRunnableBo();
            inspBo.setIndexName(this.uocIndexConfig.getInspOrderIndex());
            inspBo.setOrderId(rspBo.getOrderId());
            inspBo.setObjId(uocCreateOrderServiceRspSaleOrderBo.getInspOrderId());
            inspBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
            list.add(inspBo);
        }
        this.uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }
}

