/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.utils;

import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import org.xhtmlrenderer.pdf.ITextRenderer;

public class PDFTemplateUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteArrayOutputStream createPDF(Map<String, Object> data, String templateFileName) throws Exception {
        Configuration cfg = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
        cfg.setClassForTemplateLoading(PDFTemplateUtil.class, "/templates");
        ITextRenderer renderer = new ITextRenderer();
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            renderer.getFontResolver().addFont("/templates/font/simsun.ttc", "Identity-H", false);
            cfg.setEncoding(Locale.CHINA, "UTF-8");
            Template template = cfg.getTemplate(templateFileName, "UTF-8");
            StringWriter writer = new StringWriter();
            template.process(data, (Writer)writer);
            writer.flush();
            String html = writer.toString();
            renderer.setDocumentFromString(html);
            renderer.layout();
            renderer.createPDF((OutputStream)out, false);
            renderer.finishPDF();
            out.flush();
            ByteArrayOutputStream byteArrayOutputStream = out;
            return byteArrayOutputStream;
        }
    }
}

