/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.saleorder;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.common.sub.UocFile;
import com.tydic.dyc.oc.service.saleorder.UocGetSaleOrderDetailService;
import com.tydic.dyc.oc.service.saleorder.UocSaleOrderPdfExportService;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspItemBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderPdfExportReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderPdfExportRspBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocShipItemReceiverAddressBo;
import com.tydic.dyc.oc.utils.AmountTransformUtils;
import com.tydic.dyc.oc.utils.PDFTemplateUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.saleorder.UocSaleOrderPdfExportService"})
public class UocSaleOrderPdfExportServiceImpl
implements UocSaleOrderPdfExportService {
    @Value(value="${dyc.file.inst.data.path:dyc/file/instData}")
    private String instDataPath;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Autowired
    private IUocCommonModel iUocCommonModel;
    @Autowired
    private UocGetSaleOrderDetailService uocGetSaleOrderDetailService;

    @PostMapping(value={"dealSaleOrderPdfExport"})
    public UocSaleOrderPdfExportRspBO dealSaleOrderPdfExport(@RequestBody UocSaleOrderPdfExportReqBO reqBo) {
        UocSaleOrderPdfExportRspBO rspBO = new UocSaleOrderPdfExportRspBO();
        UocGetSaleOrderDetailServiceReqBo uocGetSaleOrderDetailServiceReqBo = new UocGetSaleOrderDetailServiceReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)uocGetSaleOrderDetailServiceReqBo);
        UocGetSaleOrderDetailServiceRspBo saleOrderInfo = this.uocGetSaleOrderDetailService.getSaleOrderDetail(uocGetSaleOrderDetailServiceReqBo);
        saleOrderInfo.setTotalSaleFeeStr(AmountTransformUtils.toChinese(saleOrderInfo.getTotalSaleFee().setScale(2).toString(), false));
        BigDecimal totalPurchaseCount = BigDecimal.ZERO;
        if (UocConstant.ItemType.COMB.equals(((UocGetSaleOrderDetailServiceRspItemBo)((UocShipItemReceiverAddressBo)saleOrderInfo.getShipItemReceiverAddressBoList().get(0)).getSaleOrderDetailServiceRspItemBoList().get(0)).getItemType())) {
            for (UocShipItemReceiverAddressBo bo : saleOrderInfo.getShipItemReceiverAddressBoList()) {
                List subSaleOrderDetailServiceRspItemBoList = bo.getSaleOrderDetailServiceRspItemBoList().stream().flatMap(subItem -> subItem.getSubCommodityBos().stream()).collect(Collectors.toList());
                bo.setSaleOrderDetailServiceRspItemBoList(subSaleOrderDetailServiceRspItemBoList);
                totalPurchaseCount = totalPurchaseCount.add(subSaleOrderDetailServiceRspItemBoList.stream().map(UocGetSaleOrderDetailServiceRspItemBo::getPurchaseCount).reduce(BigDecimal.ZERO, BigDecimal::add));
            }
        }
        saleOrderInfo.setTotalPurchaseCount(totalPurchaseCount);
        String filePath = this.doTest(saleOrderInfo);
        rspBO.setFilePath(filePath);
        return rspBO;
    }

    private String doTest(UocGetSaleOrderDetailServiceRspBo saleOrderInfo) {
        ByteArrayOutputStream baos = null;
        OutputStream out = null;
        try {
            String path;
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("saleOrderInfo", saleOrderInfo);
            String fileName = URLEncoder.encode("\u9500\u552e\u5355\u8be6\u60c5.pdf", "UTF-8");
            String filetemplateName = "goodspdftemplate.ftl";
            if (UocConstant.AgreementVariety.SERV.equals(saleOrderInfo.getAgreementVariety())) {
                filetemplateName = "servpdftemplate.ftl";
            }
            baos = PDFTemplateUtil.createPDF(data, filetemplateName);
            byte[] pdfBytes = baos.toByteArray();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(pdfBytes);
            UocCommonDo uocCommonDo = new UocCommonDo();
            UocFile uocFile = new UocFile();
            uocFile.setPath(this.instDataPath);
            uocFile.setInputStream(inputStream);
            uocFile.setFilename(fileName);
            uocFile.setFileType(this.fileType);
            uocCommonDo.setUocFile(uocFile);
            String fileUrl = path = this.iUocCommonModel.uploadFile(uocCommonDo).getUocFile().getUrl();
            System.out.println("fileUrl:" + fileUrl);
            baos.close();
            String string = fileUrl;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseBusinessException("8888", "\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private void doServExport(UocGetSaleOrderDetailServiceRspBo saleOrderInfo) {
        String path;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Document document = new Document(PageSize.A4.rotate(), -75.0f, -75.0f, 15.0f, 40.0f);
        PdfWriter pdfWriter = null;
        try {
            pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        BaseFont baseFont = null;
        try {
            baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Font titleFont = new Font(baseFont, 14.0f, 1);
        Font contentBoldFont = new Font(baseFont, 8.0f, 1);
        Font contentFont = new Font(baseFont, 8.0f, 0);
        Font footerFont = new Font(baseFont, 10.0f, 1);
        int COLUMNS = 10;
        document.open();
        PdfPTable titleTable = new PdfPTable(1);
        PdfPCell titleCell = new PdfPCell(new Phrase("\u91c7\u8d2d\u8ba2\u5355", titleFont));
        titleCell.setColspan(1);
        titleCell.setBorder(0);
        titleCell.setFixedHeight(30.0f);
        titleCell.setHorizontalAlignment(1);
        titleCell.setVerticalAlignment(5);
        titleTable.addCell(titleCell);
        try {
            document.add((Element)titleTable);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        PdfPTable saleNoTable = new PdfPTable(1);
        PdfPCell saleNoCell = new PdfPCell(new Phrase("\u8ba2\u5355\u7f16\u53f7\uff1a(" + saleOrderInfo.getSaleOrderNo() + ")", contentFont));
        saleNoCell.setColspan(1);
        saleNoCell.setBorder(0);
        saleNoCell.setFixedHeight(30.0f);
        saleNoCell.setHorizontalAlignment(2);
        saleNoCell.setVerticalAlignment(5);
        saleNoTable.addCell(saleNoCell);
        try {
            document.add((Element)saleNoTable);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        PdfPTable pdfPTable1 = new PdfPTable(10);
        Paragraph paragraph = new Paragraph();
        Phrase phrase = new Phrase("\u6846\u67b6\u534f\u8bae", contentFont);
        Phrase phrase2 = new Phrase("\u540d\u79f0/\u7f16\u53f7", contentFont);
        paragraph.add((Element)phrase);
        paragraph.add((Element)phrase2);
        PdfPCell pdfPCell1 = new PdfPCell((Phrase)paragraph);
        pdfPCell1.setHorizontalAlignment(2);
        pdfPCell1.setVerticalAlignment(5);
        pdfPCell1.setColspan(1);
        pdfPTable1.addCell(pdfPCell1);
        pdfPCell1.setPhrase(new Phrase(saleOrderInfo.getAgreementInfo().getAgreementName() + "(" + saleOrderInfo.getAgreementInfo().getEntAgreementCode() + ")", contentFont));
        pdfPCell1.setHorizontalAlignment(1);
        pdfPCell1.setColspan(2);
        pdfPTable1.addCell(pdfPCell1);
        try {
            document.add((Element)pdfPTable1);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        document.close();
        byte[] pdfBytes = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(pdfBytes);
        String fileName = "\u91c7\u8d2d\u8ba2\u5355" + System.currentTimeMillis() + ".pdf";
        UocCommonDo uocCommonDo = new UocCommonDo();
        UocFile uocFile = new UocFile();
        uocFile.setPath(this.instDataPath);
        uocFile.setInputStream(inputStream);
        uocFile.setFilename(fileName);
        uocFile.setFileType(this.fileType);
        uocCommonDo.setUocFile(uocFile);
        String fileUrl = path = this.iUocCommonModel.uploadFile(uocCommonDo).getUocFile().getUrl();
        System.out.println("fileUrl:" + fileUrl);
    }
}

