/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.transactionservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocAttachementTypeConstants;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.UocAuditOrderDo;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryAddBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelSaleOrderAndStopProcessServiceReqBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelSaleOrderAndStopProcessServiceRspBO;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class UocCancelSaleOrderAndStopProcessTransaction {
    private static final Logger log = LoggerFactory.getLogger(UocCancelSaleOrderAndStopProcessTransaction.class);
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;
    @Value(value="${delApprovalObjFlag:false}")
    private boolean delApprovalObjFlag;

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public UocCancelSaleOrderAndStopProcessServiceRspBO cancelSaleOrderAndStopProcess(UocCancelSaleOrderAndStopProcessServiceReqBO reqBO) {
        UocCancelSaleOrderAndStopProcessServiceRspBO rspBO = UocRu.success(UocCancelSaleOrderAndStopProcessServiceRspBO.class);
        rspBO.setSaleOrderState("");
        this.verifyParam(reqBO);
        this.updateSaleOrderStatus(reqBO, rspBO);
        if (!CollectionUtils.isEmpty((Collection)reqBO.getOrderAccessoryBoList())) {
            this.saveCancelAccessoryInfo(reqBO);
        }
        this.updateSaleOrderProcessInfo(reqBO);
        List<Long> auditOrderIdList = this.delApprovalObj(reqBO);
        rspBO.setAuditOrderIdList(auditOrderIdList);
        return rspBO;
    }

    private List<Long> delApprovalObj(UocCancelSaleOrderAndStopProcessServiceReqBO reqBO) {
        ArrayList<Long> auditOrderIdList = new ArrayList<Long>();
        if (this.delApprovalObjFlag) {
            UocApprovalObjQryBo qryBo = new UocApprovalObjQryBo();
            qryBo.setOrderId(reqBO.getOrderId());
            qryBo.setObjId(String.valueOf(reqBO.getSaleOrderId()));
            List<UocApprovalObj> uocApprovalObjList = this.iUocAuditOrderModel.qryApprovealObj(qryBo);
            if (ObjectUtil.isNotEmpty(uocApprovalObjList)) {
                uocApprovalObjList.forEach(uocApprovalObj -> {
                    uocApprovalObj.setDelTag(UocDicConstant.DELETE_TAG.DELETED);
                    UocApprovalObjQryBo uocApprovalObjQryBo = UocRu.js(uocApprovalObj, UocApprovalObjQryBo.class);
                    this.iUocAuditOrderModel.delApprovealObj(uocApprovalObjQryBo);
                    auditOrderIdList.add(uocApprovalObj.getAuditOrderId());
                });
                for (Long auditOrderId : auditOrderIdList) {
                    UocApprovalObjQryBo uocApprovalObjQryBo = new UocApprovalObjQryBo();
                    uocApprovalObjQryBo.setAuditOrderId(auditOrderId);
                    uocApprovalObjQryBo.setOrderId(reqBO.getOrderId());
                    uocApprovalObjQryBo.setDelTag(UocDicConstant.DELETE_TAG.NO_DEL);
                    List<UocApprovalObj> uocApprovalObjList1 = this.iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo);
                    if (!ObjectUtil.isEmpty(uocApprovalObjList1)) continue;
                    UocAuditOrderDo uocAuditOrderDo = new UocAuditOrderDo();
                    uocAuditOrderDo.setAuditOrderId(auditOrderId);
                    uocAuditOrderDo.setAuditOrderStatus("3");
                    this.iUocAuditOrderModel.updateApprove(uocAuditOrderDo);
                }
            }
        }
        return auditOrderIdList;
    }

    private void verifyParam(UocCancelSaleOrderAndStopProcessServiceReqBO reqBO) {
        if (null == reqBO) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getUserId()) {
            throw new BaseBusinessException("102001", "\u5f53\u524d\u64cd\u4f5c\u4ebaid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getName())) {
            throw new BaseBusinessException("102001", "\u5f53\u524d\u64cd\u4f5c\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new BaseBusinessException("102001", "\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSaleOrderId()) {
            throw new BaseBusinessException("102001", "\u9500\u552e\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void updateSaleOrderStatus(UocCancelSaleOrderAndStopProcessServiceReqBO reqBO, UocCancelSaleOrderAndStopProcessServiceRspBO rspBO) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setUpdateTime(new Date());
        uocSaleOrderDo.setUpdateOperId(String.valueOf(reqBO.getUserId()));
        uocSaleOrderDo.setUpdateOperName(reqBO.getName());
        uocSaleOrderDo.setCancelTime(new Date());
        uocSaleOrderDo.setCancelReason(reqBO.getCancelReason());
        uocSaleOrderDo.setCancelReasonFlag(reqBO.getCancelReasonFlag());
        if (reqBO.getCancelReasonFlag() != null && reqBO.getCancelReasonFlag().equals(UocConstant.CancelReasonFlag.USER_CANCEL)) {
            UocSaleOrderDo qryDO = new UocSaleOrderDo();
            qryDO.setOrderId(reqBO.getOrderId());
            qryDO.setSaleOrderId(reqBO.getSaleOrderId());
            UocSaleOrderDo saleOrderMain = this.iUocSaleOrderModel.getSaleOrderMain(qryDO);
            if ("XS_QR_JDDCL".equals(saleOrderMain.getSaleOrderState())) {
                uocSaleOrderDo.setCancelReasonFlag(UocConstant.CancelReasonFlag.VENDOR_CANCEL);
                rspBO.setSaleOrderState("XS_QR_JDDCL");
            }
        }
        uocSaleOrderDo.setCancelOperName(reqBO.getName());
        uocSaleOrderDo.setCancelOperId(String.valueOf(reqBO.getUserId()));
        uocSaleOrderDo.setSaleOrderState("XS_QX_QX");
        uocSaleOrderDo.setOrderId(reqBO.getOrderId());
        uocSaleOrderDo.setSaleOrderId(reqBO.getSaleOrderId());
        this.iUocSaleOrderModel.modifySaleOrderMain(uocSaleOrderDo);
    }

    private void saveCancelAccessoryInfo(UocCancelSaleOrderAndStopProcessServiceReqBO reqBO) {
        ArrayList<UocOrderAccessory> uocOrderAccessoryList = new ArrayList<UocOrderAccessory>();
        for (UocBaseOrderAccessoryAddBo uocBaseOrderAccessoryAddBo : reqBO.getOrderAccessoryBoList()) {
            UocOrderAccessory uocOrderAccessory = new UocOrderAccessory();
            uocOrderAccessory.setId(IdUtil.nextId());
            uocOrderAccessory.setAccessoryId(uocBaseOrderAccessoryAddBo.getAccessoryId());
            uocOrderAccessory.setAccessoryName(uocBaseOrderAccessoryAddBo.getAccessoryName());
            uocOrderAccessory.setAccessoryUrl(uocBaseOrderAccessoryAddBo.getAccessoryUrl());
            uocOrderAccessory.setAttachmentType(uocBaseOrderAccessoryAddBo.getAttachmentType());
            uocOrderAccessory.setObjId(reqBO.getSaleOrderId());
            uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.SALE);
            uocOrderAccessory.setAttachmentType(UocAttachementTypeConstants.CANCEL_SALE_ORDER);
            uocOrderAccessory.setOrderId(reqBO.getOrderId());
            uocOrderAccessory.setCreateTime(new Date());
            uocOrderAccessory.setCreateOperId(String.valueOf(reqBO.getUserId()));
            uocOrderAccessoryList.add(uocOrderAccessory);
        }
        this.iUocOrderModel.createOrderAccessory(uocOrderAccessoryList);
    }

    private void updateSaleOrderProcessInfo(UocCancelSaleOrderAndStopProcessServiceReqBO reqBO) {
        UocOrderProcInst uocOrderProcInst = new UocOrderProcInst();
        uocOrderProcInst.setOrderId(reqBO.getOrderId());
        uocOrderProcInst.setObjId(reqBO.getSaleOrderId());
        uocOrderProcInst.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.END_TASK);
        uocOrderProcInst.setFinishTime(new Date());
        this.iUocSaleOrderModel.updateProcInst(uocOrderProcInst);
        UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
        uocOrderTaskInst.setObjId(reqBO.getSaleOrderId());
        uocOrderTaskInst.setOrderId(reqBO.getOrderId());
        uocOrderTaskInst.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.FINISHED);
        uocOrderTaskInst.setDealOperId(reqBO.getUserId().toString());
        uocOrderTaskInst.setDealOperName(reqBO.getName());
        uocOrderTaskInst.setDealRemark("\u6d41\u7a0b\u7ec8\u6b62");
        this.iUocSaleOrderModel.updateTaskInst(uocOrderTaskInst);
    }
}

