/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.utils;

import com.alibaba.cloud.commons.lang.StringUtils;

public class AmountTransformUtils {
    private static final String[] NUMBERS = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
    private static final String[] IUNIT = new String[]{"\u5143", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf", "\u4ebf", "\u62fe", "\u4f70", "\u4edf"};
    private static final String[] DUNIT = new String[]{"\u89d2", "\u5206"};
    private static final String[] CN_NUMBERS = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
    private static final String[] CN_IUNIT = new String[]{"", "\u5341", "\u767e", "\u5343", "\u4e07", "\u5341", "\u767e", "\u5343", "\u4ebf", "\u5341", "\u767e", "\u5343"};

    private AmountTransformUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static String toChinese(String amount, boolean isSimplified) {
        if (StringUtils.isBlank((CharSequence)amount) || !amount.matches("(-)?[\\d]*(.)?[\\d]*")) {
            throw new RuntimeException("\u8bf7\u8f93\u5165\u6570\u5b57");
        }
        if ("0".equals(amount) || "0.00".equals(amount) || "0.0".equals(amount)) {
            return isSimplified ? "\u96f6" : "\u96f6\u5143";
        }
        boolean flag = false;
        if (amount.startsWith("-")) {
            flag = true;
            amount = amount.replaceAll("-", "");
        }
        amount = amount.replaceAll(",", "");
        String[] separateNum = AmountTransformUtils.separateNum(amount);
        String integerStr = separateNum[0];
        String decimalStr = separateNum[1];
        if (integerStr.length() > IUNIT.length) {
            throw new RuntimeException("\u8f93\u5165\u6570\u5b57\u8d85\u9650");
        }
        int[] integers = AmountTransformUtils.toIntArray(integerStr);
        if (integers.length > 1 && integers[0] == 0) {
            throw new RuntimeException("\u8f93\u5165\u6570\u5b57\u4e0d\u7b26\u5408\u8981\u6c42");
        }
        boolean isWan = AmountTransformUtils.isWan5(integerStr);
        int[] decimals = AmountTransformUtils.toIntArray(decimalStr);
        String result = "";
        String chineseInteger = AmountTransformUtils.getChineseInteger(integers, isWan, isSimplified);
        String chineseDecimal = AmountTransformUtils.getChineseDecimal(decimals, isSimplified);
        if (decimals.length > 0 && isSimplified) {
            result = chineseInteger;
            if (!chineseDecimal.equals("\u96f6\u96f6")) {
                result = result + "\u70b9" + chineseDecimal;
            }
        } else {
            result = chineseInteger + chineseDecimal;
        }
        if (flag) {
            return "\u8d1f" + result;
        }
        return result;
    }

    private static String[] separateNum(String str) {
        String decimalStr;
        String integerStr;
        if (str.indexOf(46) >= 1) {
            integerStr = str.substring(0, str.indexOf(46));
            decimalStr = str.substring(str.indexOf(46) + 1);
            if (decimalStr.length() > 2) {
                decimalStr = decimalStr.substring(0, 2);
            }
        } else if (str.indexOf(46) == 0) {
            integerStr = "";
            decimalStr = str.substring(1);
        } else {
            integerStr = str;
            decimalStr = "";
        }
        return new String[]{integerStr, decimalStr};
    }

    private static int[] toIntArray(String number) {
        int[] array = new int[number.length()];
        for (int i = 0; i < number.length(); ++i) {
            array[i] = Integer.parseInt(number.substring(i, i + 1));
        }
        return array;
    }

    private static String getChineseInteger(int[] integers, boolean isWan, boolean isSimplified) {
        int length = integers.length;
        if (!isSimplified && length == 1 && integers[0] == 0) {
            return "";
        }
        if (!isSimplified) {
            return AmountTransformUtils.traditionalChineseInteger(integers, isWan);
        }
        return AmountTransformUtils.simplifiedChineseInteger(integers, isWan);
    }

    private static String traditionalChineseInteger(int[] integers, boolean isWan) {
        StringBuilder chineseInteger = new StringBuilder("");
        int length = integers.length;
        for (int i = 0; i < length; ++i) {
            String key = "";
            if (integers[i] == 0) {
                if (length - i == 13) {
                    key = IUNIT[4];
                } else if (length - i == 9) {
                    key = IUNIT[8];
                } else if (length - i == 5 && isWan) {
                    key = IUNIT[4];
                } else if (length - i == 1) {
                    key = IUNIT[0];
                }
                if (length - i > 1 && integers[i + 1] != 0) {
                    key = key + NUMBERS[0];
                }
            }
            chineseInteger.append(integers[i] == 0 ? key : NUMBERS[integers[i]] + IUNIT[length - i - 1]);
        }
        return chineseInteger.toString();
    }

    private static String simplifiedChineseInteger(int[] integers, boolean isWan) {
        StringBuilder chineseInteger = new StringBuilder("");
        int length = integers.length;
        for (int i = 0; i < length; ++i) {
            String key = "";
            if (integers[i] == 0) {
                if (length - i == 13) {
                    key = CN_IUNIT[4];
                } else if (length - i == 9) {
                    key = CN_IUNIT[8];
                } else if (length - i == 5 && isWan) {
                    key = CN_IUNIT[4];
                } else if (length - i == 1) {
                    key = CN_IUNIT[0];
                }
                if (length - i > 1 && integers[i + 1] != 0) {
                    key = key + CN_NUMBERS[0];
                }
                if (length == 1 && integers[i] == 0) {
                    key = key + CN_NUMBERS[0];
                }
            }
            chineseInteger.append(integers[i] == 0 ? key : CN_NUMBERS[integers[i]] + CN_IUNIT[length - i - 1]);
        }
        return chineseInteger.toString();
    }

    private static String getChineseDecimal(int[] decimals, boolean isSimplified) {
        StringBuilder chineseDecimal = new StringBuilder("");
        if (!isSimplified) {
            for (int i = 0; i < decimals.length; ++i) {
                String key = "";
                if (decimals.length - i > 1 && decimals[i + 1] != 0) {
                    key = key + NUMBERS[0];
                }
                chineseDecimal.append(decimals[i] == 0 ? key : NUMBERS[decimals[i]] + DUNIT[i]);
            }
        } else {
            for (int i = 0; i < decimals.length; ++i) {
                chineseDecimal.append(CN_NUMBERS[decimals[i]]);
            }
        }
        return chineseDecimal.toString();
    }

    private static boolean isWan5(String integerStr) {
        int length = integerStr.length();
        if (length > 4) {
            String subInteger = "";
            subInteger = length > 8 ? integerStr.substring(length - 8, length - 4) : integerStr.substring(0, length - 4);
            return Integer.parseInt(subInteger) > 0;
        }
        return false;
    }

    public static void main(String[] args) {
        String amount = "123456789012.123";
        System.out.println(amount + ":" + AmountTransformUtils.toChinese(amount, true));
        amount = "0.123";
        System.out.println(amount + ":" + AmountTransformUtils.toChinese(amount, true));
        amount = "0";
        System.out.println(amount + ":" + AmountTransformUtils.toChinese(amount, true));
        amount = "-1123456789.123";
        System.out.println(amount + ":" + AmountTransformUtils.toChinese(amount, true));
        amount = "120001.01";
        System.out.println(amount + ":" + AmountTransformUtils.toChinese(amount, true));
        amount = "120001.00";
        System.out.println(amount + ":" + AmountTransformUtils.toChinese(amount, true));
        System.out.println("=================");
        System.out.println(amount + ":" + AmountTransformUtils.toChinese(amount, false));
        amount = "0.123";
        System.out.println(amount + ":" + AmountTransformUtils.toChinese(amount, false));
        amount = "0";
        System.out.println(amount + ":" + AmountTransformUtils.toChinese(amount, false));
        amount = "-1123456789.123";
        System.out.println(amount + ":" + AmountTransformUtils.toChinese(amount, false));
        amount = "120001.01";
        System.out.println(amount + ":" + AmountTransformUtils.toChinese(amount, false));
        amount = "120001.00";
        System.out.println(amount + ":" + AmountTransformUtils.toChinese(amount, false));
    }
}

