package com.tydic.dyc.oc.components.ordSourceProcessor.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.oc.components.ordSourceProcessor.UocOrderSourceProcessor;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 标题:UocOrderSourceProcessorNoAgr
 * 说明:电商处理类
 * 时间:2022/4/6 14:45
 * 作者:田桂银
 */
@Component
public class UocOrderSourceProcessorEstore implements UocOrderSourceProcessor {

    @Override
    public List<List<UocSaleOrderItem>> splitSaleOrder(List<UocSaleOrderItem> reqSaleItemList) {
        List<List<UocSaleOrderItem>> retList = new ArrayList<>();
        //根据供应商拆单
        Map<String, List<UocSaleOrderItem>> supAndModelMap = reqSaleItemList.stream().collect(Collectors.groupingBy(UocSaleOrderItem::getSupplierId));
        for (Map.Entry<String, List<UocSaleOrderItem>> entry : supAndModelMap.entrySet()) {
            //根据计划id是否为空，分两波处理，非计划的一组，计划的再根据计划id拆一次单
/*            List<UocSaleOrderItem> noPlanList = entry.getValue().stream().filter(item -> ObjectUtil.isEmpty(item.getPlanId())).collect(Collectors.toList());
            if (ObjectUtil.isNotEmpty(noPlanList)) {
                retList.add(noPlanList);
            }
            List<UocSaleOrderItem> planList = entry.getValue().stream().filter(item -> !ObjectUtil.isEmpty(item.getPlanId())).collect(Collectors.toList());
            if (ObjectUtil.isNotEmpty(planList)) {
                retList.addAll(planList.stream().collect(Collectors.groupingBy(UocSaleOrderItem::getPlanId)).values());
            }*/

            // todo lhl 后期电商下单会有预算，这个时候放开
            //按预算拆单
//            Map<Long, List<UocSaleOrderItem>> budgetMap = entry.getValue().stream().collect(Collectors.groupingBy(UocSaleOrderItem::getBudgetId));
//            for (Map.Entry<Long, List<UocSaleOrderItem>> budgetEntry : budgetMap.entrySet()) {
//                retList.add(budgetEntry.getValue());
//            }
            // todo lhl 后期电商下单会有预算，上面放开了，这一行就屏蔽掉
            retList.add(entry.getValue());
        }
        return retList;
    }

    @Override
    public Integer skuSource() {
        return UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT;
    }
}


