package com.tydic.dyc.oc.model.common.sub;


import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 类名: UocConfSupplierDO
 * 说明: 供应商支付配置DO
 * 时间: 2022-06-01 19:49
 * 作者: 王钟游
 **/
@Data
@EqualsAndHashCode(callSuper=false)
public class UocConfSupplierDO implements Serializable {

    private static final long serialVersionUID = 8930954270520327440L;

    //供应商id")
    private String supNo;

    //供应商名称")
    private String supName;

    //供应商标识")
    private String supType;

    //是否一次性发货             0 否             1 是")
    private Integer isOnceSendAll;

    //订单超限额度")
    private String orderQuota;

    //校验模式")
    private Integer checkFlag;

    //接收消息类型")
    private String dealType;

    //是否完结通知                         0 否                         1 是")
    private Integer completionFlag;

    //业务类型编码")
    private String businessTypeCode;

    //操作时间")
    private Date operatingTime;

    //操作时间 开始")
    private Date operatingTimeStart;

    //操作时间 结束")
    private Date operatingTimeEnd;

    //操作人ID")
    private String operatorId;

    //操作人名称")
    private String operatorName;

    //订单限额额度")
    private String orderLimit;

    //订单限额状态：0：生效；1：失效")
    private Integer limitStatus;

    //排序")
    private String orderBy;

    //供应商编号列表")
    private List<String> supplierNos;

}
