package com.tydic.dyc.oc.model.saleorder.qrybo;

import com.tydic.dyc.base.bo.BasePageReqBo;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocSaleOrderItemQryBo
 * 说明:销售订单明细
 * 时间:2022-02-21 19:11
 * 作者:罗有
 **/
@EqualsAndHashCode(callSuper = true)
@Data
public class UocSaleOrderItemQryBo extends BasePageReqBo {
	private static final long serialVersionUID =  -2942628359818493335L;

	//订单id")
	private Long orderId;

	//销售明细id")
	private Long saleOrderItemId;

	//销售单id")
	private Long saleOrderId;

	//订单明细id")
	private Long orderItemId;

	//明细类型             1 商品sku             2 物资             3 项目")
	private Integer itemType;

	//明细状态")
	private String saleItemState;

	//单品ID")
	private String skuId;

	//供应商ID")
	private String supplierId;

	//店铺ID")
	private String supplierShopId;

	//采购金额")
	private BigDecimal purchasePrice;

	//采购金额")
	private BigDecimal salePrice;

	//采购数量")
	private BigDecimal purchaseCount;

	//运费")
	private BigDecimal transFee;

	//采购金额")
	private BigDecimal purchaseFee;

	//应付金额")
	private BigDecimal payFee;

	//积分优惠金额")
	private BigDecimal integralDisFee;

	//活动优惠金额")
	private BigDecimal actDisFee;

	//其它优惠金额")
	private BigDecimal otherDisFee;

	//实付金额")
	private BigDecimal usedFee;

	//实付积分")
	private BigDecimal usedIntegral;

	//币种")
	private String currencyType;

	//税金")
	private String taxPrice;

	//税率")
	private String tax;

	//税务编码")
	private String taxId;

	//预计发货时间")
	private Date preSendTime;

	//预计发货时间 开始")
	private Date preSendTimeStart;

	//预计发货时间 结束")
	private Date preSendTimeEnd;

	//预计交货时间")
	private Date preOfferTime;

	//预计交货时间 开始")
	private Date preOfferTimeStart;

	//预计交货时间 结束")
	private Date preOfferTimeEnd;

	//计量单位")
	private String unitName;

	//结算计量单位")
	private String settleUnit;

	//售后在途数量")
	private BigDecimal afterServingCount;

	//外部电商主订单id")
	private String lmOrderId;

	//外部电商子订单id")
	private String lmSubOrderId;

	//到货周期")
	private String arrivalTime;

	//加价率")
	private Double markUpRate;

	//商品服务费 ")
	private String serPrice;

	//计划id")
	private String planId;

	//计划明细id ")
	private String planItemId;

	//计划明细编号")
	private String planItemNo;

	//创建时间")
	private Date createTime;

	//创建时间 开始")
	private Date createTimeStart;

	//创建时间 结束")
	private Date createTimeEnd;

	//创建工号")
	private String createOperId;

	//更新时间")
	private Date updateTime;

	//更新时间 开始")
	private Date updateTimeStart;

	//更新时间 结束")
	private Date updateTimeEnd;

	//更新工号")
	private String updateOperId;

	//备注")
	private String remark;

	//删除标志1已删除")
	private Integer delTag;

	//超验百分比，下单时保存（协议、无协议）")
	private Integer inspectionExcessPercent;

	//是否存在超验 0否 1是")
	private Integer inspSuper;

	//扩展字段")
	private String extField1;

	//扩展字段")
	private String extField2;

	//扩展字段")
	private String extField3;

    //扩展字段")
    private String extField4;

    //扩展字段")
    private String extField5;

    //排序")
    private String orderBy;

    //销售明细id List")
    private List<Long> saleOrderItemIdList;

    //发货数量")
    private BigDecimal sendCount;



	/**
	 * 议价单id
	 */
	private Long bargainingId;
	/**
	 * 议价单编码
	 */
	private String bargainingNo;
    
    
    //销售id List")
    private List<Long> saleOrderIdList;

	//组合销售明细id List")
	private List<Long> combSaleOrderItemIdList;
}
