package com.tydic.dyc.oc.service.cmporder;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.bo.RspBaseBO;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.cmporder.IUocCmpOrderModel;
import com.tydic.dyc.oc.model.cmporder.qrybo.UocCmpOrderQryBo;
import com.tydic.dyc.oc.model.cmporder.qrybo.UocDelCmpOrderBo;
import com.tydic.dyc.oc.service.cmporder.bo.UocDelCmpOrderServiceReqBo;
import com.tydic.dyc.oc.service.cmporder.bo.UocDelCmpOrderServiceRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * UocDelCmpOrderServiceImpl
 * 2023/3/1
 * Project:dyc-uoc-pro
 * Creator:印昌盛
 * Create Time:2023/3/1-15-50
 * 描述：删除比选单
 */
@HTServiceImpl
public class UocDelCmpOrderServiceImpl implements UocDelCmpOrderService {

    @Autowired
    private IUocCmpOrderModel uocCmpOrderModel;
    @Override
    public UocDelCmpOrderServiceRspBo dealCmpOrder(UocDelCmpOrderServiceReqBo reqBo) {
        //入参校验
        this.validate(reqBo);
        
        UocDelCmpOrderBo uocDelCmpOrderBo = new UocDelCmpOrderBo();
        uocDelCmpOrderBo.setCmpOrderId(reqBo.getCmpOrderId());
        uocDelCmpOrderBo.setCmpOrderNo(reqBo.getCmpOrderNo());
        try {
            int i = uocCmpOrderModel.dealCmpOrder(uocDelCmpOrderBo);
        } catch (Exception e) {
            e.printStackTrace();
        }
        UocDelCmpOrderServiceRspBo rspBO = new UocDelCmpOrderServiceRspBo();
        rspBO.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);
        return rspBO;
    }
    
    private void validate(UocDelCmpOrderServiceReqBo reqBo){
        if (ObjectUtil.isEmpty(reqBo)){
            throw new ZTBusinessException("入参对象[UocDelCmpOrderServiceReqBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getCmpOrderId())){
            throw new ZTBusinessException("入参比选单ID不能为空");
        }
//        if (ObjectUtil.isEmpty(reqBo.getCmpOrderNo())){
//            throw new ZTBusinessException("入参比选单编号不能为空");
//        }
        UocCmpOrderQryBo uocCmpOrderQryBo = new UocCmpOrderQryBo();
        uocCmpOrderQryBo.setCmpOrderId(reqBo.getCmpOrderId());
        uocCmpOrderQryBo.setCmpOrderNo(reqBo.getCmpOrderNo());
        uocCmpOrderQryBo = uocCmpOrderModel.qryCmpOrder(uocCmpOrderQryBo);
        if (ObjectUtil.isEmpty(uocCmpOrderQryBo.getCreateTime())){
            throw new ZTBusinessException("传入的比选单id不存在");
        }
    }
}
