package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.UocAfOrderDo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderItemQryBo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderItem;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderStakeholderQryBo;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderCancelReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderCancelRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 标题：类名称:UocAfterOrderCancelServiceImpl
 * 说明：描述一下类的作用TODO
 * 时间：2022/4/6 16:11
 * 作者 @author 尹栋梁
 */
@HTServiceImpl
public class UocAfterOrderCancelServiceImpl implements UocAfterOrderCancelService {
    @Autowired
    private IUocAfOrderModel afOrderModel;

    @Autowired
    private IUocInspOrderModel inspOrderModel;

    @Autowired
    private IUocSaleOrderModel saleOrderModel;
    @Autowired
    private IUocOrderModel orderModel;


    @Autowired
    private IUocShipOrderModel shipOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Override
    public UocAfterOrderCancelRspBo cancelAfterOrder(UocAfterOrderCancelReqBo reqBo) {
        UocAfterOrderCancelRspBo rspBo = UocRu.success(UocAfterOrderCancelRspBo.class);
        //参数校验
        validateArg(reqBo);
        //查询售后单信息
        UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
        uocAfOrderQryBo.setOrderId(reqBo.getOrderId());
        uocAfOrderQryBo.setAfOrderId(reqBo.getAfOrderId());
        UocAfOrder uocAfOrder = afOrderModel.getAfOrderById(uocAfOrderQryBo);

        if (ObjectUtil.isEmpty(uocAfOrder)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "查询售后单信息为空");
        }
        Integer servType = uocAfOrder.getServType();
        Integer servState = uocAfOrder.getServState();
        if (!UocDicConstant.SERVICE_STATE.SUMIT_APPLICATION.equals(servState)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "售后单不可取消");

        }
        //修改售后状态
        UocAfOrderDo uocAfOrderDo = new UocAfOrderDo();
        uocAfOrderDo.setAfOrderId(reqBo.getAfOrderId());
        uocAfOrderDo.setOrderId(reqBo.getOrderId());
        uocAfOrderDo.setServState(UocDicConstant.SERVICE_STATE.CANCEL);
        uocAfOrderDo.setPayState(UocDicConstant.PAY_AFTER_STATE.CANCELED);
        uocAfOrderDo.setUpdateTime(new Date());
        uocAfOrderDo.setCancelTime(new Date());
        uocAfOrderDo.setCancelOperId(String.valueOf(reqBo.getUserId()));
        uocAfOrderDo.setUpdateOperId(String.valueOf(reqBo.getUserId()));
        afOrderModel.modifyAfOrderState(uocAfOrderDo);
        List<UocAfOrderItem> afOrderItemList = afOrderModel.getAfOrderItemList(UocRu.js(reqBo, UocAfOrderItemQryBo.class));

        if (UocDicConstant.SERVICE_STATE.REMARK_COMPLATE.equals(servState) && UocConstant.AFTERORDER_SERVTYPE.RETURN.equals(servType)) {
            //修改发货单明细，销售单明细退货数量
            updateItemAndShipReturnCount(afOrderItemList, reqBo, rspBo);
        } else {
            //修改发货单明细，销售单明细在途数量
            updateItemAndShipAfterServringCount(afOrderItemList, reqBo, rspBo);

        }

        UocSaleOrderDo saleOrderDetail = getSaleOrderDetail(uocAfOrder.getOrderId(), uocAfOrder.getSaleOrderId());

        UocOrderStakeholderQryBo uocOrderStakeholderQryBo = new UocOrderStakeholderQryBo();
        uocOrderStakeholderQryBo.setOrderId(reqBo.getOrderId());
        uocOrderStakeholderQryBo.setStakeholderId(saleOrderDetail.getStakeholderId());
        List<UocOrderStakeholderQryBo> uocOrderStakeholderQryBos = orderModel.qryStakeholderList(uocOrderStakeholderQryBo);
        String supId = uocOrderStakeholderQryBos.get(0).getSupId();

        UocAfOrderItem uocAfOrderItem = afOrderItemList.get(0);
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setOrderId(uocAfOrderItem.getOrderId());
        uocShipOrderItemQryBo.setShipOrderItemId(uocAfOrderItem.getShipItemId());
        List<UocShipOrderItem> shipOrderItemList = shipOrderModel.getShipOrderItemList(uocShipOrderItemQryBo);
        rspBo.setSaleOrderId(uocAfOrder.getSaleOrderId());
        rspBo.setShipOrderId(shipOrderItemList.get(0).getShipOrderId());
        rspBo.setExtAfId(uocAfOrder.getExtAfId());
        rspBo.setSupId(supId);
        return rspBo;
    }

    private void updateItemAndShipAfterServringCount(List<UocAfOrderItem> afOrderItemList, UocAfterOrderCancelReqBo reqBo, UocAfterOrderCancelRspBo rspBo) {
        //查询发货单明细对应的销售单明细
        List<UocSaleOrderItem> saleOrderItemInfos = this.getSaleOrderItemInfos(afOrderItemList.get(0).getOrderId(), afOrderItemList.get(0).getSaleOrderId(), afOrderItemList.stream().map(UocAfOrderItem::getSaleItemId).distinct().collect(Collectors.toList()));
        Map<Long, UocSaleOrderItem> saleOrderItemMap = saleOrderItemInfos.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, u -> u));
        for (UocAfOrderItem uocAfOrderItem : afOrderItemList) {
            Long inspItemId = uocAfOrderItem.getInspItemId();
            Long orderItemId = uocAfOrderItem.getSaleItemId();
            Long orderId = uocAfOrderItem.getOrderId();
            Long shipItemId = uocAfOrderItem.getShipItemId();
            BigDecimal returnCount = uocAfOrderItem.getReturnCount();

            UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
            uocSaleOrderItem.setOrderId(orderId);
            uocSaleOrderItem.setSaleOrderItemId(orderItemId);
            uocSaleOrderItem.setAfterServingCount(returnCount.negate());
            uocSaleOrderItem.setUpdateTime(new Date());
            uocSaleOrderItem.setUpdateOperId(ObjectUtil.isEmpty(reqBo.getUserId()) ? null : String.valueOf(reqBo.getUserId()));
            saleOrderModel.modifySaleOrderItemAfterServingCount(uocSaleOrderItem);
            UocShipOrderItem uocShipOrderItem = new UocShipOrderItem();
            uocShipOrderItem.setOrderId(orderId);
            uocShipOrderItem.setShipOrderItemId(shipItemId);
            uocShipOrderItem.setAfterServingCount(returnCount.negate());
            uocShipOrderItem.setUpdateTime(new Date());
            uocShipOrderItem.setUpdateOperId(ObjectUtil.isEmpty(reqBo.getUserId()) ? null : String.valueOf(reqBo.getUserId()));
            shipOrderModel.modifyShipOrderItemAfterServingCount(uocShipOrderItem);
            UocSaleOrderItem saleOrderItem = saleOrderItemMap.get(orderItemId);
            //如果是组合商品，还要修改子商品的在途数量
            if (UocConstant.ItemType.COMB.equals(saleOrderItem.getItemType())) {
                for (UocSaleOrderItem subCommodityBo : saleOrderItem.getSubCommodityBos()) {
                    UocSaleOrderItem subUocSaleOrderItem = new UocSaleOrderItem();
                    subUocSaleOrderItem.setOrderId(orderId);
                    subUocSaleOrderItem.setSaleOrderItemId(subCommodityBo.getSaleOrderItemId());
                    subUocSaleOrderItem.setAfterServingCount((returnCount.multiply(subCommodityBo.getCombSubRelCount())).negate());
                    subUocSaleOrderItem.setUpdateTime(new Date());
                    subUocSaleOrderItem.setUpdateOperId(String.valueOf(reqBo.getUserId()));
                    this.saleOrderModel.modifySaleOrderItemAfterServingCount(subUocSaleOrderItem);
                }
            }
//        if (ObjectUtil.isNotEmpty(inspItemId)) {
//            UocInspOrderItem uocInspOrderItem = new UocInspOrderItem();
//            uocInspOrderItem.setOrderId(uocAfOrderItem.getOrderId());
//            uocInspOrderItem.setInspOrderItemId(inspItemId);
//            uocInspOrderItem.setReturnCount(uocAfOrderItem.getReturnCount());
//            uocInspOrderItem.setUpdateTime(new Date());
//            uocInspOrderItem.setUpdateOperId(ObjectUtil.isEmpty(reqBo.getUserId()) ? null : String.valueOf(reqBo.getUserId()));
//            inspOrderModel.modifySaleOrderItemReturningCount(uocInspOrderItem);
//            //出参es同步
//            List<Long> inspOrderIdList = rspBo.getInspOrderIdList();
//            UocInspOrderItemQryBo uocInspOrderItemQryBo = new UocInspOrderItemQryBo();
//            UocInspOrderDo listInspOrderItem = inspOrderModel.getListInspOrderItem(uocInspOrderItemQryBo);
//            inspOrderIdList.add(listInspOrderItem.getInspOrderId());
//        }
        }
    }

    /**
     * 查销售明细
     *
     * @param saleOrderId
     * @param orderId
     * @param saleOrderItemIdList
     * @return
     */
    private List<UocSaleOrderItem> getSaleOrderItemInfos(Long orderId, Long saleOrderId, List<Long> saleOrderItemIdList) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        //设置销售单明细id集合
        uocSaleOrderItemQryBo.setSaleOrderItemIdList(saleOrderItemIdList);
        //设置销售单id
        uocSaleOrderItemQryBo.setSaleOrderId(saleOrderId);
        //设置订单id
        uocSaleOrderItemQryBo.setOrderId(orderId);
        UocSaleOrderDo uocSaleOrderDo = this.iUocSaleOrderModel.qryListSaleOrderItem(uocSaleOrderItemQryBo);
        if (null != uocSaleOrderDo && !CollectionUtils.isEmpty(uocSaleOrderDo.getSaleOrderItems())) {
            //如果是组合商品，还需要吧子商品查出来
            if (uocSaleOrderDo.getSaleOrderItems().stream().anyMatch(bo -> UocConstant.ItemType.COMB.equals(bo.getItemType()))) {
                uocSaleOrderItemQryBo.setSaleOrderItemIdList(null);
                uocSaleOrderItemQryBo.setCombSaleOrderItemIdList(uocSaleOrderDo.getSaleOrderItems().stream().filter(bo->UocConstant.ItemType.COMB.equals(bo.getItemType())).map(UocSaleOrderItem::getSaleOrderItemId).collect(Collectors.toList()));
                List<UocSaleOrderItem> subSaleItemList = iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
                Map<Long, List<UocSaleOrderItem>> subSaleItemMap = subSaleItemList.stream().collect(Collectors.groupingBy(UocSaleOrderItem::getCombSaleItemId));
                uocSaleOrderDo.getSaleOrderItems().forEach(bo -> {
                    if (UocConstant.ItemType.COMB.equals(bo.getItemType())) {
                        bo.setSubCommodityBos(subSaleItemMap.get(bo.getSaleOrderItemId()));
                    }
                });
            }
            return uocSaleOrderDo.getSaleOrderItems();
        }else{
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARRIVA_ACCEPTANCE_ERROR, "获取销售明细为空");
        }
    }

    private void updateItemAndShipReturnCount(List<UocAfOrderItem> uocAfOrderItemList, UocAfterOrderCancelReqBo reqBo, UocAfterOrderCancelRspBo rspBo) {
        for (UocAfOrderItem uocAfOrderItem : uocAfOrderItemList) {
            Long inspItemId = uocAfOrderItem.getInspItemId();
            Long orderItemId = uocAfOrderItem.getSaleItemId();
            Long orderId = uocAfOrderItem.getOrderId();
            Long shipItemId = uocAfOrderItem.getShipItemId();
            BigDecimal returnCount = uocAfOrderItem.getReturnCount();

            UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
            uocSaleOrderItem.setOrderId(orderId);
            uocSaleOrderItem.setSaleOrderItemId(orderItemId);
            uocSaleOrderItem.setReturnCount(returnCount.negate());
            uocSaleOrderItem.setUpdateTime(new Date());
            uocSaleOrderItem.setUpdateOperId(ObjectUtil.isEmpty(reqBo.getUserId()) ? null : String.valueOf(reqBo.getUserId()));
            saleOrderModel.modifySaleOrderItemReturningCount(uocSaleOrderItem);
            UocShipOrderItem uocShipOrderItem = new UocShipOrderItem();
            uocShipOrderItem.setOrderId(orderId);
            uocShipOrderItem.setShipOrderItemId(shipItemId);
            uocShipOrderItem.setReturnCount(returnCount.negate());
            uocShipOrderItem.setUpdateTime(new Date());
            uocShipOrderItem.setUpdateOperId(ObjectUtil.isEmpty(reqBo.getUserId()) ? null : String.valueOf(reqBo.getUserId()));
            shipOrderModel.modifyShipOrderItemReturningCount(uocShipOrderItem);
//        if (ObjectUtil.isNotEmpty(inspItemId)) {
//            UocInspOrderItem uocInspOrderItem = new UocInspOrderItem();
//            uocInspOrderItem.setOrderId(uocAfOrderItem.getOrderId());
//            uocInspOrderItem.setInspOrderItemId(inspItemId);
//            uocInspOrderItem.setReturnCount(uocAfOrderItem.getReturnCount());
//            uocInspOrderItem.setUpdateTime(new Date());
//            uocInspOrderItem.setUpdateOperId(ObjectUtil.isEmpty(reqBo.getUserId()) ? null : String.valueOf(reqBo.getUserId()));
//            inspOrderModel.modifySaleOrderItemReturningCount(uocInspOrderItem);
//            //出参es同步
//            List<Long> inspOrderIdList = rspBo.getInspOrderIdList();
//            UocInspOrderItemQryBo uocInspOrderItemQryBo = new UocInspOrderItemQryBo();
//            UocInspOrderDo listInspOrderItem = inspOrderModel.getListInspOrderItem(uocInspOrderItemQryBo);
//            inspOrderIdList.add(listInspOrderItem.getInspOrderId());
//        }
        }

    }

    private UocSaleOrderDo getSaleOrderDetail(Long orderId,Long saleOrderId){
        UocSaleOrderQryBo qrySaleOrderQryBo = new UocSaleOrderQryBo();
        qrySaleOrderQryBo.setSaleOrderId(saleOrderId);
        qrySaleOrderQryBo.setOrderId(orderId);
        UocSaleOrderDo uocSaleOrderDo = saleOrderModel.qrySaleOrder(qrySaleOrderQryBo);
        return uocSaleOrderDo;
    }

    private void validateArg(UocAfterOrderCancelReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocAfterOrderCancelReqBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[订单ID]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getAfOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[售后单ID]不能为空");
        }
    }
}
