package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderSupplierConfirmReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderSupplierConfirmRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelSaleOrderConfirmOrRefuseReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelSaleOrderConfirmOrRefuseRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题：类名称:UocAfterOrderSupplierConfirmServiceImpl
 * 说明：描述一下类的作用TODO
 * 时间：2022/5/13 15:20
 * 作者 @author 尹栋梁
 */
@Slf4j
@HTServiceImpl
public class UocAfterOrderSupplierConfirmServiceImpl implements UocAfterOrderSupplierConfirmService {
    @Autowired
    private IUocAfOrderModel afOrderModel;

    @Autowired
    private IUocCommonModel iUocCommonModel;

    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public UocAfterOrderSupplierConfirmRspBo dealAfterOrderSupplierConfirm(UocAfterOrderSupplierConfirmReqBo reqBo) {
        log.info("供应商确认入参：{}", JSON.toJSONString(reqBo));
        UocAfterOrderSupplierConfirmRspBo rspBo = new UocAfterOrderSupplierConfirmRspBo();
        //参数校验
        validateArg(reqBo);
        boolean reConsume = afOrderModel.confirmAfOrderState(reqBo, reqBo.getConfirmflag(), rspBo);
        if (reConsume) {
            // 提交任务
            UocCommonDo uocCommonDo = new UocCommonDo();
            List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskBos = new ArrayList<>();
            UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
            taskBo.setTaskId(reqBo.getTaskId());
            taskBos.add(taskBo);
            uocCommonDo.setCompleteTaskInfos(taskBos);
            uocCommonDo.setUserId(11111l);
            uocCommonDo.setOrderId(reqBo.getOrderId());
            iUocCommonModel.dealTask(uocCommonDo);
        } else {
            log.info("重复消费，不提交任务");
            rspBo.setReConsume(false);
        }


        //本地线程同步es
        try {
            syncEs(reqBo, rspBo);
        } catch (Exception e) {
            log.error("同步es失败：", e);
        }


        return rspBo;
    }

    private void validateArg(UocAfterOrderSupplierConfirmReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocAfterOrderSupplierConfirmReqBo]不能为空");
        }
    }


    private void syncEs(UocAfterOrderSupplierConfirmReqBo reqBo, UocAfterOrderSupplierConfirmRspBo rspBo) {
        List<SyncEsRunnableBo> list = new ArrayList<>();
        SyncEsRunnableBo saleOrderBo = new SyncEsRunnableBo();

        if (rspBo.getSaleOrderId() != null) {
            saleOrderBo.setIndexName(uocIndexConfig.getSaleOrderIndex());
            saleOrderBo.setOrderId(reqBo.getOrderId());
            saleOrderBo.setObjId(rspBo.getSaleOrderId());
            saleOrderBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
            list.add(saleOrderBo);
        }

        if (rspBo.getShipOrderId() != null) {
            SyncEsRunnableBo shipOrderBo = new SyncEsRunnableBo();
            shipOrderBo.setIndexName(uocIndexConfig.getShipOrderIndex());
            shipOrderBo.setOrderId(reqBo.getOrderId());
            shipOrderBo.setObjId(rspBo.getShipOrderId());
            shipOrderBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
            list.add(shipOrderBo);
        }

        SyncEsRunnableBo afOrderBo = new SyncEsRunnableBo();
        afOrderBo.setIndexName(uocIndexConfig.getAfOrderIndex());
        afOrderBo.setOrderId(reqBo.getOrderId());
        afOrderBo.setObjId(reqBo.getAfOrderId());
        afOrderBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(afOrderBo);

        if (!CollectionUtil.isEmpty(rspBo.getInspOrderIdList())) {
            SyncEsRunnableBo inspOrderBo = new SyncEsRunnableBo();
            inspOrderBo.setIndexName(uocIndexConfig.getInspOrderIndex());
            inspOrderBo.setOrderId(reqBo.getOrderId());
            inspOrderBo.setObjId(rspBo.getInspOrderIdList().get(0));
            inspOrderBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
            list.add(inspOrderBo);
        }

        uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }

}
