package com.tydic.dyc.oc.service.saleorder;

import com.itextpdf.text.*;
import com.itextpdf.text.Font;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.common.sub.UocFile;
import com.tydic.dyc.oc.service.saleorder.bo.*;
import com.tydic.dyc.oc.utils.AmountTransformUtils;
import com.tydic.dyc.oc.utils.PDFTemplateUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import java.io.*;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import java.io.ByteArrayOutputStream;
import java.util.stream.Collectors;

/**
 * @description 销售单详情pdf导出
 * @author Luokan
 * @date 2024/05/15
 **/

@HTServiceImpl
public class UocSaleOrderPdfExportServiceImpl implements UocSaleOrderPdfExportService{

    @Value("${dyc.file.inst.data.path:dyc/file/instData}")
    private String instDataPath;
    @Value("${plugin.file.type}")
    private String fileType;
    @Autowired
    private IUocCommonModel iUocCommonModel;
    @Autowired
    private UocGetSaleOrderDetailService uocGetSaleOrderDetailService;

    @Override
    public UocSaleOrderPdfExportRspBO dealSaleOrderPdfExport(UocSaleOrderPdfExportReqBO reqBo) {
        UocSaleOrderPdfExportRspBO rspBO = new UocSaleOrderPdfExportRspBO();
        UocGetSaleOrderDetailServiceReqBo uocGetSaleOrderDetailServiceReqBo = new UocGetSaleOrderDetailServiceReqBo();
        BeanUtils.copyProperties(reqBo, uocGetSaleOrderDetailServiceReqBo);
        UocGetSaleOrderDetailServiceRspBo saleOrderInfo = this.uocGetSaleOrderDetailService.getSaleOrderDetail(uocGetSaleOrderDetailServiceReqBo);
        saleOrderInfo.setTotalSaleFeeStr(AmountTransformUtils.toChinese(saleOrderInfo.getTotalSaleFee().setScale(2).toString(), false));
        //如果是组合商品，则把子商品提到最外层
        BigDecimal totalPurchaseCount = BigDecimal.ZERO;
        if (UocConstant.ItemType.COMB.equals(saleOrderInfo.getShipItemReceiverAddressBoList().get(0).getSaleOrderDetailServiceRspItemBoList().get(0).getItemType())) {
            for (UocShipItemReceiverAddressBo bo : saleOrderInfo.getShipItemReceiverAddressBoList()) {
                List<UocGetSaleOrderDetailServiceRspItemBo> subSaleOrderDetailServiceRspItemBoList = bo.getSaleOrderDetailServiceRspItemBoList().stream().flatMap(subItem-> subItem.getSubCommodityBos().stream()).collect(Collectors.toList());
                bo.setSaleOrderDetailServiceRspItemBoList(subSaleOrderDetailServiceRspItemBoList);
                totalPurchaseCount = totalPurchaseCount.add(subSaleOrderDetailServiceRspItemBoList.stream().map(UocGetSaleOrderDetailServiceRspItemBo::getPurchaseCount).reduce(BigDecimal.ZERO, BigDecimal::add));
            }
        }
        saleOrderInfo.setTotalPurchaseCount(totalPurchaseCount);
        String filePath = this.doTest(saleOrderInfo);
        /*UocGetSaleOrderDetailServiceRspBo saleOrderInfo = this.uocGetSaleOrderDetailService.getSaleOrderDetail(reqBo);
        if (UocConstant.AgreementVariety.SERV.equals(saleOrderInfo.getAgreementVariety())) {
            this.doServExport(saleOrderInfo);
        }*/
        rspBO.setFilePath(filePath);
        return rspBO;
    }

    private String doTest(UocGetSaleOrderDetailServiceRspBo saleOrderInfo) {
        ByteArrayOutputStream baos = null;
        OutputStream out = null;
        try {
            // 模板中的数据，实际运用从数据库中查询
            /*Map<String,Object> data = new HashMap<>();
            data.put("curr", 1);
            data.put("one", 2);
            data.put("two", 1);
            data.put("three", 6);

            List<PDFDataTest> detailList = new ArrayList<>();
            detailList.add(new PDFDataTest(123456,"测试","测试","测试","测试"));
            detailList.add(new PDFDataTest(111111,"测试","测试","测试","测试"));
            detailList.add(new PDFDataTest(222222,"测试","测试","测试","测试"));
            data.put("detailList", detailList);*/
            Map<String, Object> data = new HashMap<>();
            data.put("saleOrderInfo", saleOrderInfo);
            String fileName = URLEncoder.encode("销售单详情.pdf", "UTF-8");
            String filetemplateName = "goodspdftemplate.ftl";
            if (UocConstant.AgreementVariety.SERV.equals(saleOrderInfo.getAgreementVariety())) {
                filetemplateName = "servpdftemplate.ftl";
            }
            baos = PDFTemplateUtil.createPDF(data, filetemplateName);;
            byte[] pdfBytes = baos.toByteArray();
            InputStream inputStream = new ByteArrayInputStream(pdfBytes);
            UocCommonDo uocCommonDo = new UocCommonDo();
            UocFile uocFile = new UocFile();
            uocFile.setPath(instDataPath);
            uocFile.setInputStream(inputStream);
            uocFile.setFilename(fileName);
            uocFile.setFileType(fileType);
            uocCommonDo.setUocFile(uocFile);
            String path = iUocCommonModel.uploadFile(uocCommonDo).getUocFile().getUrl();

            String fileUrl = path;
            System.out.println("fileUrl:" + fileUrl);
            //baos.writeTo(out);
            baos.close();
            return fileUrl;
        } catch (Exception e) {
            e.printStackTrace();
            throw new BaseBusinessException("8888", "导出失败：" + e.getMessage());
        } finally{
            if(baos != null){
                try {
                    baos.close();
                } catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if(out != null){
                try {
                    out.close();
                } catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private void doServExport(UocGetSaleOrderDetailServiceRspBo saleOrderInfo) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        //创建pdf文档
        Document document = new Document(PageSize.A4.rotate(), -75, -75, 15, 40);
        PdfWriter pdfWriter = null;
        try {
            pdfWriter = PdfWriter.getInstance(document, byteArrayOutputStream);
        } catch (DocumentException e) {
            e.printStackTrace();
        }

        //定义字体
        com.itextpdf.text.pdf.BaseFont baseFont = null;
        try {
            baseFont = com.itextpdf.text.pdf.BaseFont.createFont("STSong-Light", "UniGB-UCS2-H", BaseFont.EMBEDDED);
        } catch (Exception e) {
            e.printStackTrace();
        }
        //标题字体设置
        com.itextpdf.text.Font titleFont = new com.itextpdf.text.Font(baseFont, 14, com.itextpdf.text.Font.BOLD);
        //表格加粗字体设置
        com.itextpdf.text.Font contentBoldFont = new com.itextpdf.text.Font(baseFont, 8, com.itextpdf.text.Font.BOLD);
        //表格字体设置
        com.itextpdf.text.Font contentFont = new com.itextpdf.text.Font(baseFont, 8, com.itextpdf.text.Font.NORMAL);
        //页码字体设置
        com.itextpdf.text.Font footerFont = new com.itextpdf.text.Font(baseFont, 10, Font.BOLD);

        //定义列数
        final int COLUMNS = 10;
        //打开pdf文档
        document.open();

        //标题部分
        PdfPTable titleTable = new PdfPTable(1);
        PdfPCell titleCell = new PdfPCell(new Phrase("采购订单", titleFont));
        titleCell.setColspan(1);
        titleCell.setBorder(0);
        titleCell.setFixedHeight(30);
        titleCell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
        titleCell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
        titleTable.addCell(titleCell);
        try {
            document.add(titleTable);
        } catch (DocumentException e) {
            e.printStackTrace();
        }

        //商品编号
        PdfPTable saleNoTable = new PdfPTable(1);
        PdfPCell saleNoCell = new PdfPCell(new Phrase("订单编号：(" + saleOrderInfo.getSaleOrderNo() + ")", contentFont));
        saleNoCell.setColspan(1);
        saleNoCell.setBorder(0);
        saleNoCell.setFixedHeight(30);
        saleNoCell.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
        saleNoCell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
        saleNoTable.addCell(saleNoCell);
        try {
            document.add(saleNoTable);
        } catch (DocumentException e) {
            e.printStackTrace();
        }

        //第一行
        PdfPTable pdfPTable1 = new PdfPTable(COLUMNS);
        Paragraph paragraph = new Paragraph();
        Phrase phrase = new Phrase("框架协议", contentFont);
        Phrase phrase2 = new Phrase("名称/编号", contentFont);
        paragraph.add(phrase);
        paragraph.add(phrase2);
        PdfPCell pdfPCell1 = new PdfPCell(paragraph);
        pdfPCell1.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
        pdfPCell1.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
        pdfPCell1.setColspan(1);
        pdfPTable1.addCell(pdfPCell1);
        pdfPCell1.setPhrase(new Phrase(saleOrderInfo.getAgreementInfo().getAgreementName() + "("+ saleOrderInfo.getAgreementInfo().getEntAgreementCode()  +")", contentFont));
        pdfPCell1.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
        pdfPCell1.setColspan(2);
        pdfPTable1.addCell(pdfPCell1);
        try {
            document.add(pdfPTable1);
        } catch (DocumentException e) {
            e.printStackTrace();
        }


        //关闭pdf文档
        document.close();

        byte[] pdfBytes = byteArrayOutputStream.toByteArray();
        InputStream inputStream = new ByteArrayInputStream(pdfBytes);
        //String fileName = UUID.randomUUID().toString().replaceAll("-", "") + ".pdf";
        String fileName = "采购订单" + System.currentTimeMillis() + ".pdf";
        UocCommonDo uocCommonDo = new UocCommonDo();

        UocFile uocFile = new UocFile();
        uocFile.setPath(instDataPath);
        uocFile.setInputStream(inputStream);
        uocFile.setFilename(fileName);
        uocFile.setFileType(fileType);
        uocCommonDo.setUocFile(uocFile);
        String path = iUocCommonModel.uploadFile(uocCommonDo).getUocFile().getUrl();

        String fileUrl = path;
        System.out.println("fileUrl:" + fileUrl);
    }

}
