/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.config.UocPropertiesConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipItemMap;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderMap;
import com.tydic.dyc.oc.repository.UocShipOrderRepository;
import com.tydic.dyc.oc.repository.dao.UocShipItemMapMapper;
import com.tydic.dyc.oc.repository.dao.UocShipOrderItemMapper;
import com.tydic.dyc.oc.repository.dao.UocShipOrderMapMapper;
import com.tydic.dyc.oc.repository.dao.UocShipOrderMapper;
import com.tydic.dyc.oc.repository.po.UocShipItemMapPo;
import com.tydic.dyc.oc.repository.po.UocShipOrderItemPo;
import com.tydic.dyc.oc.repository.po.UocShipOrderMapPo;
import com.tydic.dyc.oc.repository.po.UocShipOrderPo;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UocShipOrderRepositoryImpl
implements UocShipOrderRepository {
    @Autowired
    private UocShipOrderMapper uocShipOrderMapper;
    @Autowired
    private UocShipOrderMapMapper uocShipOrderMapMapper;
    @Autowired
    private UocShipOrderItemMapper uocShipOrderItemMapper;
    @Autowired
    private UocShipItemMapMapper uocShipItemMapMapper;
    @Autowired
    private UocPropertiesConfig uocPropertiesConfig;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    public void createShipOrder(UocShipOrderDo uocShipOrderDo) {
        this.uocShipOrderMapper.insert((UocShipOrderPo)UocRu.js((Object)uocShipOrderDo, UocShipOrderPo.class));
        this.uocShipOrderItemMapper.insertBatch(UocRu.jsl((List)uocShipOrderDo.getShipOrderItemBoList(), UocShipOrderItemPo.class));
        if (!CollectionUtils.isEmpty((Collection)uocShipOrderDo.getExtParallelBoList())) {
            this.uocShipOrderMapMapper.insertBatch(UocRu.jsl((List)uocShipOrderDo.getExtParallelBoList(), UocShipOrderMapPo.class));
        }
        ArrayList uocShipItemMapList = new ArrayList();
        uocShipOrderDo.getShipOrderItemBoList().forEach(uocShipOrderItem -> {
            if (!CollectionUtils.isEmpty((Collection)uocShipOrderItem.getItemExtParallelBoList())) {
                uocShipItemMapList.addAll(uocShipOrderItem.getItemExtParallelBoList());
            }
        });
        if (!CollectionUtils.isEmpty(uocShipItemMapList)) {
            this.uocShipItemMapMapper.insertBatch(UocRu.jsl(uocShipItemMapList, UocShipItemMapPo.class));
        }
    }

    public void modifyBatchShipOrderArrivaRefuse(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderPo where = new UocShipOrderPo();
        where.setShipOrderIdList(uocShipOrderDo.getShipOrderIdList());
        where.setOrderId(uocShipOrderDo.getOrderId());
        where.setSaleOrderId(uocShipOrderDo.getSaleOrderId());
        this.uocShipOrderMapper.updateBy((UocShipOrderPo)UocRu.js((Object)uocShipOrderDo, UocShipOrderPo.class), where);
    }

    public void modifyArrivaShipOrderItem(UocShipOrderDo uocShipOrderDo) {
        if (null != uocShipOrderDo) {
            this.uocShipOrderItemMapper.updateItemArriveCount((UocShipOrderItemPo)UocRu.js((Object)uocShipOrderDo, UocShipOrderItemPo.class));
        }
    }

    public void modifyRefuseShipOrderItem(UocShipOrderDo uocShipOrderDo) {
        if (null != uocShipOrderDo) {
            this.uocShipOrderItemMapper.updateItemRefuseCount((UocShipOrderItemPo)UocRu.js((Object)uocShipOrderDo, UocShipOrderItemPo.class));
        }
    }

    public UocShipOrderDo getListShipOrderItem(UocShipOrderItemQryBo uocShipOrderItemQryBo) {
        List<UocShipOrderItemPo> uocShipOrderItemPoList;
        UocShipOrderDo uocShipOrderRspDo = new UocShipOrderDo();
        List<UocShipOrderPo> list = this.uocShipOrderMapper.getList((UocShipOrderPo)UocRu.js((Object)uocShipOrderItemQryBo, UocShipOrderPo.class));
        if (ObjectUtil.isNotEmpty(list)) {
            uocShipOrderRspDo = (UocShipOrderDo)UocRu.js((Object)list.get(0), UocShipOrderDo.class);
        }
        if (ObjectUtil.isNotEmpty(uocShipOrderItemPoList = this.uocShipOrderItemMapper.getList((UocShipOrderItemPo)UocRu.js((Object)uocShipOrderItemQryBo, UocShipOrderItemPo.class)))) {
            uocShipOrderRspDo.setShipOrderItemBoList(UocRu.jsl(uocShipOrderItemPoList, UocShipOrderItem.class));
            List<Long> shipOrderItemIdList = uocShipOrderItemPoList.stream().map(UocShipOrderItemPo::getShipOrderItemId).filter(Objects::nonNull).collect(Collectors.toList());
            List<Long> orderIdList = uocShipOrderItemPoList.stream().map(UocShipOrderItemPo::getOrderId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(shipOrderItemIdList)) {
                uocShipOrderRspDo.setShipOrderItemIdList(shipOrderItemIdList);
                UocShipItemMapPo uocShipItemMapPo = new UocShipItemMapPo();
                uocShipItemMapPo.setShipOrderItemIdList(shipOrderItemIdList);
                uocShipItemMapPo.setOrderIdList(orderIdList);
                uocShipItemMapPo.setDataAchiveTabSuffix(uocShipOrderItemQryBo.getDataAchiveTabSuffix());
                List<UocShipItemMapPo> uocShipItemMapPoList = this.uocShipItemMapMapper.getList(uocShipItemMapPo);
                if (ObjectUtil.isNotEmpty(uocShipItemMapPoList)) {
                    ConcurrentMap<Long, List<UocShipItemMapPo>> uocShipItemMap = uocShipItemMapPoList.stream().collect(Collectors.groupingByConcurrent(UocShipItemMapPo::getShipOrderItemId));
                    uocShipOrderRspDo.getShipOrderItemBoList().forEach(uocShipOrderItem -> uocShipOrderItem.setItemExtParallelBoList(UocRu.jsl((List)((List)uocShipItemMap.get(uocShipOrderItem.getShipOrderItemId())), UocShipItemMap.class)));
                }
            }
        }
        return uocShipOrderRspDo;
    }

    public List<UocShipOrderItem> getShipOrderItem(UocShipOrderItemQryBo uocShipOrderItemQryBo) {
        List<UocShipOrderItemPo> uocShipOrderItemPoList = this.uocShipOrderItemMapper.getList((UocShipOrderItemPo)UocRu.js((Object)uocShipOrderItemQryBo, UocShipOrderItemPo.class));
        return UocRu.jsl(uocShipOrderItemPoList, UocShipOrderItem.class);
    }

    public void modifyShipOrderMain(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderPo where = new UocShipOrderPo();
        where.setOrderId(uocShipOrderDo.getOrderId());
        where.setSaleOrderId(uocShipOrderDo.getSaleOrderId());
        where.setShipOrderIdList(uocShipOrderDo.getShipOrderIdList());
        where.setShipOperId(uocShipOrderDo.getShipOperId());
        where.setShipOrderId(uocShipOrderDo.getShipOrderId());
        this.uocShipOrderMapper.updateBy((UocShipOrderPo)UocRu.js((Object)uocShipOrderDo, UocShipOrderPo.class), where);
    }

    public void modifyBatchShipOrderItemInspCount(UocShipOrderDo uocShipOrderDo) {
        this.uocShipOrderItemMapper.updateItemInspCount(UocRu.jsl((List)uocShipOrderDo.getShipOrderItemBoList(), UocShipOrderItemPo.class), (UocShipOrderItemPo)UocRu.js((Object)uocShipOrderDo, UocShipOrderItemPo.class));
    }

    public UocShipOrderDo getShipOrderById(UocShipOrderQryBo uocShipOrderQryBo) {
        UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
        UocShipOrderPo uocShipOrderPo = new UocShipOrderPo();
        uocShipOrderPo.setShipOrderId(uocShipOrderQryBo.getShipOrderId());
        uocShipOrderPo.setDataAchiveTabSuffix(uocShipOrderQryBo.getDataAchiveTabSuffix());
        if (ObjectUtil.isNotEmpty((Object)uocShipOrderQryBo.getOrderId())) {
            uocShipOrderPo.setOrderId(uocShipOrderQryBo.getOrderId());
        }
        if (null != (uocShipOrderPo = this.uocShipOrderMapper.getModelBy(uocShipOrderPo))) {
            uocShipOrderDo = (UocShipOrderDo)UocRu.js((Object)uocShipOrderPo, UocShipOrderDo.class);
            UocShipOrderMapPo uocShipOrderMapPo = new UocShipOrderMapPo();
            uocShipOrderMapPo.setShipOrderId(uocShipOrderQryBo.getShipOrderId());
            uocShipOrderMapPo.setDataAchiveTabSuffix(uocShipOrderQryBo.getDataAchiveTabSuffix());
            List<UocShipOrderMapPo> uocShipOrderMapPoList = this.uocShipOrderMapMapper.getList(uocShipOrderMapPo);
            if (!CollectionUtils.isEmpty(uocShipOrderMapPoList)) {
                uocShipOrderDo.setExtParallelBoList(UocRu.jsl(uocShipOrderMapPoList, UocShipOrderMap.class));
            }
        } else {
            return null;
        }
        return uocShipOrderDo;
    }

    public List<UocShipOrderDo> getListShipOrder(UocShipOrderQryBo uocShipOrderQryBo) {
        List<UocShipOrderPo> uocShipOrderPoList = this.uocShipOrderMapper.getList((UocShipOrderPo)UocRu.js((Object)uocShipOrderQryBo, UocShipOrderPo.class));
        return UocRu.jsl(uocShipOrderPoList, UocShipOrderDo.class);
    }

    public UocShipOrderDo getShipOrderNo(UocShipOrderDo uocShipOrderDo) {
        return null;
    }

    public void modifyShipOrderItemChngingCount(UocShipOrderDo uocShipOrderDo) {
        if (null != uocShipOrderDo && !CollectionUtils.isEmpty((Collection)uocShipOrderDo.getShipOrderItemBoList())) {
            this.uocShipOrderItemMapper.updateItemChngingCount(UocRu.jsl((List)uocShipOrderDo.getShipOrderItemBoList(), UocShipOrderItemPo.class), (UocShipOrderItemPo)UocRu.js((Object)uocShipOrderDo, UocShipOrderItemPo.class));
        }
    }

    public void modifyItemReturnCountConfirm(UocShipOrderDo uocShipOrderDo) {
        if (null != uocShipOrderDo) {
            this.uocShipOrderItemMapper.updateItemReturnCountByChngingCount((UocShipOrderItemPo)UocRu.js((Object)uocShipOrderDo, UocShipOrderItemPo.class));
        }
    }

    public void modifyItemChngCountRefuse(UocShipOrderDo uocShipOrderDo) {
        if (null != uocShipOrderDo) {
            this.uocShipOrderItemMapper.updateItemReturnCountZero((UocShipOrderItemPo)UocRu.js((Object)uocShipOrderDo, UocShipOrderItemPo.class));
        }
    }

    public void updateShipStatusAndProCode(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderPo set = new UocShipOrderPo();
        if (!StringUtils.isBlank((CharSequence)uocShipOrderDo.getProcState())) {
            set.setProcState(uocShipOrderDo.getProcState());
        }
        set.setShipOrderState(uocShipOrderDo.getShipOrderState());
        set.setFinishFlag(uocShipOrderDo.getFinishFlag());
        UocShipOrderPo where = new UocShipOrderPo();
        where.setOrderId(uocShipOrderDo.getOrderId());
        where.setShipOrderId(uocShipOrderDo.getShipOrderId());
        this.uocShipOrderMapper.updateBy(set, where);
    }

    public void addShipOrderMap(UocShipOrderDo uocShipOrderDo) {
        if (null != uocShipOrderDo && !CollectionUtils.isEmpty((Collection)uocShipOrderDo.getExtParallelBoList())) {
            this.uocShipOrderMapMapper.insertBatch(UocRu.jsl((List)uocShipOrderDo.getExtParallelBoList(), UocShipOrderMapPo.class));
        }
    }

    public void updateBatchValue(UocShipOrderDo uocShipOrderDo) {
        if (null != uocShipOrderDo && !CollectionUtils.isEmpty((Collection)uocShipOrderDo.getExtParallelBoList())) {
            this.uocShipOrderMapMapper.updateBatchValue(UocRu.jsl((List)uocShipOrderDo.getExtParallelBoList(), UocShipOrderMapPo.class), (UocShipOrderMapPo)UocRu.js((Object)uocShipOrderDo, UocShipOrderMapPo.class));
        }
    }

    public void updateInvalid(UocShipOrderDo uocShipOrderDo) {
        if (null != uocShipOrderDo) {
            this.uocShipOrderMapMapper.updateInvalid((UocShipOrderMapPo)UocRu.js((Object)uocShipOrderDo, UocShipOrderMapPo.class));
        }
    }

    public void modifyShipOrderItemInspCountEqualArrivalCount(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderItemPo uocShipOrderItemPo = (UocShipOrderItemPo)UocRu.js((Object)uocShipOrderDo, UocShipOrderItemPo.class);
        this.uocShipOrderItemMapper.modifyShipOrderItemInspCountEqualArrivalCount(uocShipOrderItemPo);
    }

    public void batchModifyShipOrderItemInspCountEqualArrivalCount(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderItemPo uocShipOrderItemPo = (UocShipOrderItemPo)UocRu.js((Object)uocShipOrderDo, UocShipOrderItemPo.class);
        this.uocShipOrderItemMapper.batchModifyShipOrderItemInspCountEqualArrivalCount(uocShipOrderItemPo);
    }

    public void modifyItemArriveCountConfirm(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderItemPo uocShipOrderItemPo = (UocShipOrderItemPo)UocRu.js((Object)uocShipOrderDo, UocShipOrderItemPo.class);
        this.uocShipOrderItemMapper.modifyItemArriveCountConfirm(uocShipOrderItemPo);
    }

    public void modifyItemRefuseCountConfirm(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderItemPo uocShipOrderItemPo = (UocShipOrderItemPo)UocRu.js((Object)uocShipOrderDo, UocShipOrderItemPo.class);
        this.uocShipOrderItemMapper.modifyItemRefuseCountConfirm(uocShipOrderItemPo);
    }

    public void modifyShipArrivtime(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderMapPo uocShipOrderMapPo = (UocShipOrderMapPo)UocRu.js((Object)uocShipOrderDo, UocShipOrderMapPo.class);
        this.uocShipOrderMapMapper.updateByShipOrderId(uocShipOrderMapPo);
    }

    public void modifyItemArriveCount(UocShipOrderDo uocShipOrderDo) {
        for (UocShipOrderItem shipOrderItem : uocShipOrderDo.getShipOrderItemBoList()) {
            UocShipOrderItemPo set = new UocShipOrderItemPo();
            set.setArriveCount(shipOrderItem.getArriveCount());
            set.setRefuseCount(shipOrderItem.getRefuseCount());
            set.setShipItemState(shipOrderItem.getShipItemState());
            UocShipOrderItemPo where = new UocShipOrderItemPo();
            where.setShipOrderItemId(shipOrderItem.getShipOrderItemId());
            this.uocShipOrderItemMapper.updateItemArriveCountAndRefuseAccount(set, where);
        }
    }

    public void modifyShipStatus(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderPo uocShipOrderPo = new UocShipOrderPo();
        uocShipOrderPo.setOrderId(uocShipOrderDo.getOrderId());
        uocShipOrderPo.setSaleOrderId(uocShipOrderDo.getSaleOrderId());
        uocShipOrderPo.setShipOrderId(uocShipOrderDo.getShipOrderId());
        this.uocShipOrderMapper.updateShipStatus(uocShipOrderPo);
    }

    public void modifyStatChngShipStatus(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderPo uocShipOrderPo = new UocShipOrderPo();
        uocShipOrderPo.setOrderId(uocShipOrderDo.getOrderId());
        uocShipOrderPo.setShipOrderId(uocShipOrderDo.getShipOrderId());
        this.uocShipOrderMapper.updateStatChngShipStatus(uocShipOrderPo);
    }

    public void modifyShipOrderItemAfterServingCount(UocShipOrderItem uocShipOrderItem) {
        this.uocShipOrderMapper.modifyShipOrderItemAfterServingCount(uocShipOrderItem);
    }

    public void modifyShipOrderItemReturningCount(UocShipOrderItem uocShipOrderItem) {
        this.uocShipOrderMapper.modifyShipOrderItemReturningCount(uocShipOrderItem);
    }

    public List<UocShipOrderDo> getCheckVoterOrders(UocShipOrderDo record) {
        List<Object> uocShipOrderDos = new ArrayList<UocShipOrderDo>();
        List<UocShipOrderPo> uocShipOrderPos = this.uocShipOrderMapper.getCheckVoterOrders((UocShipOrderPo)UocRu.js((Object)record, UocShipOrderPo.class));
        if (ObjectUtil.isNotEmpty(uocShipOrderPos)) {
            uocShipOrderDos = UocRu.jsl(uocShipOrderPos, UocShipOrderDo.class);
            List<Long> shipOrderIds = uocShipOrderPos.stream().map(UocShipOrderPo::getShipOrderId).collect(Collectors.toList());
            UocShipOrderItemPo uocShipOrderItemPo = new UocShipOrderItemPo();
            uocShipOrderItemPo.setShipOrderIdList(shipOrderIds);
            List<UocShipOrderItemPo> shipOrderItemPos = this.uocShipOrderItemMapper.getList(uocShipOrderItemPo);
            Map<Long, List<UocShipOrderItemPo>> longListMap = shipOrderItemPos.stream().collect(Collectors.groupingBy(UocShipOrderItemPo::getShipOrderId));
            for (UocShipOrderDo uocShipOrderDo : uocShipOrderDos) {
                uocShipOrderDo.setShipOrderItemBoList(UocRu.jsl(longListMap.get(uocShipOrderDo.getShipOrderId()), UocShipOrderItem.class));
            }
        }
        return uocShipOrderDos;
    }

    public List<UocShipOrderDo> getCheckRefuseOrders(UocShipOrderDo record) {
        List<Object> uocShipOrderDos = new ArrayList<UocShipOrderDo>();
        List<UocShipOrderPo> uocShipOrderPos = this.uocShipOrderMapper.getCheckRefuseOrders((UocShipOrderPo)UocRu.js((Object)record, UocShipOrderPo.class));
        if (ObjectUtil.isNotEmpty(uocShipOrderPos)) {
            uocShipOrderDos = UocRu.jsl(uocShipOrderPos, UocShipOrderDo.class);
            List<Long> shipOrderIds = uocShipOrderPos.stream().map(UocShipOrderPo::getShipOrderId).collect(Collectors.toList());
            UocShipOrderItemPo uocShipOrderItemPo = new UocShipOrderItemPo();
            uocShipOrderItemPo.setShipOrderIdList(shipOrderIds);
            List<UocShipOrderItemPo> shipOrderItemPos = this.uocShipOrderItemMapper.getList(uocShipOrderItemPo);
            Map<Long, List<UocShipOrderItemPo>> longListMap = shipOrderItemPos.stream().collect(Collectors.groupingBy(UocShipOrderItemPo::getShipOrderId));
            for (UocShipOrderDo uocShipOrderDo : uocShipOrderDos) {
                uocShipOrderDo.setShipOrderItemBoList(UocRu.jsl(longListMap.get(uocShipOrderDo.getShipOrderId()), UocShipOrderItem.class));
            }
        }
        return uocShipOrderDos;
    }

    public void batchSyncShip() {
        int pageSize = this.uocPropertiesConfig.getSyncEsPageSize();
        Page page = new Page(this.uocPropertiesConfig.getSyncEsPageStart().intValue(), pageSize);
        List<UocShipOrderPo> listPage = this.uocShipOrderMapper.getListPage(new UocShipOrderPo(), (Page<UocShipOrderPo>)page);
        this.syncSaleEs(listPage);
        for (int i = 2; i <= page.getTotalPages(); ++i) {
            Page pageInner = new Page(i, pageSize);
            List<UocShipOrderPo> innerList = this.uocShipOrderMapper.getListPage(new UocShipOrderPo(), (Page<UocShipOrderPo>)pageInner);
            this.syncSaleEs(innerList);
        }
    }

    private void syncSaleEs(List<UocShipOrderPo> listPage) {
        ArrayList<SyncEsRunnableBo> syncEsRunnableBoList = new ArrayList<SyncEsRunnableBo>();
        for (UocShipOrderPo uocSaleOrderPo : listPage) {
            SyncEsRunnableBo signleSync = new SyncEsRunnableBo();
            signleSync.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
            signleSync.setOrderId(uocSaleOrderPo.getOrderId());
            signleSync.setObjId(uocSaleOrderPo.getShipOrderId());
            signleSync.setIndexName(this.uocIndexConfig.getShipOrderIndex());
            syncEsRunnableBoList.add(signleSync);
        }
        this.uocThreadPool.executeRunnable((Runnable)new UocSyncEsRunnable(syncEsRunnableBoList));
    }
}

