package com.tydic.dyc.oc.repository.dao;

import com.tydic.dyc.oc.repository.po.UocOrderAgreementPo;
import com.tydic.dyc.oc.repository.po.UocSaleItemShipAdressPO;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @ClassName: UocSaleItemShipAdressMapper
 * @Description: UocSaleItemShipAdressMapper
 * @author: Luokan
 * @date: 2024年04月26日11:10:16
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Mapper
@Repository
public interface UocSaleItemShipAdressMapper {

    /**
     * 描述: 根据条件查询
     *
     * @throws
     * @param: po
     * @return: List<UocSaleItemShipAdressPO>
     * @author: Luokan
     * @date: 2024年04月26日11:10:16
     */
    List<UocSaleItemShipAdressPO> selectByCondition(UocSaleItemShipAdressPO record);

    /**
     * 描述: 根据条件删除
     *
     * @throws
     * @param: po
     * @return: int
     * @author: Luokan
     * @date: 2024年04月26日11:10:16
     */
    int delete(UocSaleItemShipAdressPO record);

    /**
     * 描述: 插入单条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: Luokan
     * @date: 2024年04月26日11:10:16
     */
    int insert(UocSaleItemShipAdressPO record);

    /**
     * 描述: 更新单条数据（可选择的）
     *
     * @throws
     * @param: po
     * @return: int
     * @author: Luokan
     * @date: 2024年04月26日11:10:16
     */
    int update(UocSaleItemShipAdressPO record);

    /**
     * 批量插入数据
     *
     * @param list 参数列表
     */
    void insertBatch(List<UocSaleItemShipAdressPO> list);
	
}
