package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocTransactionPrice;
import com.tydic.dyc.oc.repository.po.UocSaleOrderItemPo;
import com.tydic.dyc.oc.repository.po.UocSaleOrderPo;
import com.tydic.dyc.oc.repository.po.UocShipOrderItemPo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:UocSaleOrderItemMapper
 * 说明:销售订单明细
 * 时间:2022-02-23 21:04
 * 作者:罗有
 **/
@Mapper
@Repository
public interface UocSaleOrderItemMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocSaleOrderItemPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocSaleOrderItemPo uocSaleOrderItemPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocSaleOrderItemPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocSaleOrderItemPo uocSaleOrderItemPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocSaleOrderItemPo set, @Param("where") UocSaleOrderItemPo where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocSaleOrderItemPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocSaleOrderItemPo uocSaleOrderItemPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocSaleOrderItemPo 参数对象
	 * @return UocSaleOrderItemPo 结果对象
	 */
	UocSaleOrderItemPo getModelBy(UocSaleOrderItemPo uocSaleOrderItemPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocSaleOrderItemPo 参数对象
	 * @return List<UocSaleOrderItemPo> 结果对象
	 */
	List<UocSaleOrderItemPo> getList(UocSaleOrderItemPo uocSaleOrderItemPo);

	/**
	 * 根据销售单明细id集合查询销售单明细
	 * @param itemIds
	 * @return
	 */
	List<UocSaleOrderItemPo> getListByItemIds(@Param("itemIds") List<Long> itemIds);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocSaleOrderItemPo 参数对象
	 * @param page 分页参数
	 * @return List<UocSaleOrderItemPo> 结果对象
	 */
	List<UocSaleOrderItemPo> getListPage(UocSaleOrderItemPo uocSaleOrderItemPo, Page<UocSaleOrderItemPo> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocSaleOrderItemPo> list);
	/**
	     * 描述：更新销售单明细验收数量
	     *
	     * @author: daiyuanyuan
	     * @date:   2022-04-02 16:00
	     */
	void updateBatchItemInspCount(@Param("list") List<UocSaleOrderItemPo> list, @Param("uocSaleOrderItemPo") UocSaleOrderItemPo uocSaleOrderItemPo);

	void updateBatchItemSendCount(@Param("list") List<UocSaleOrderItemPo> list,@Param("uocSaleOrderItemPo") UocSaleOrderItemPo uocSaleOrderItemPo);

	void updateBatchItemArrivalTime(@Param("list") List<UocSaleOrderItemPo> list,@Param("uocSaleOrderItemPo") UocSaleOrderItemPo uocSaleOrderItemPo);


	UocSaleOrderItemPo getCollectCount(UocSaleOrderItemPo uocSaleOrderItemPo);
	/**
	 * 描述：更新销售单明销售单价 sale_fee  sale_price
	 *
	 * @author: daiyuanyuan
	 * @date:   2022-04-02 16:00
	 */
	void modifyBatchItemSalePrice(@Param("list") List<UocSaleOrderItemPo> list,@Param("uocSaleOrderItemPo") UocSaleOrderItemPo uocSaleOrderItemPo);
	/**
	     * 描述：统计销售总金额
	     *
	     * @author: daiyuanyuan
	     * @date:   2022-04-06 19:29
	     */
	UocSaleOrderPo getSaleItemTotalPrice(UocSaleOrderPo uocSaleOrderPo);



    void updateItemReturningCount(UocSaleOrderItem uocSaleOrderItem);
    /**
         * 描述：更新销售单明细验收数量=到货数量
         *
         * @author: daiyuanyuan
         * @date:   2022-04-07 17:28
         */
	void modifySaleOrderItemInspCountEqualArrivalCount(UocSaleOrderItemPo uocSaleOrderItemPo);

	/**
         * 描述：批量更新销售单明细验收数量=到货数量
         *
         * @author: daiyuanyuan
         * @date:   2022-04-07 17:28
         */
	void batchModifySaleOrderItemInspCountEqualArrivalCount(UocSaleOrderItemPo uocSaleOrderItemPo);


	/**
	 * 批量更新异常变更在途数量
	 */
	void updateBatchItemChngingCount(@Param("list") List<UocSaleOrderItem> list, @Param("uocSaleOrderItem") UocSaleOrderItem uocSaleOrderItem);

	void updateItemReturnCountZero(UocSaleOrderItem uocSaleOrderItem);

	void updateItemReturnCountByChngingCount(UocSaleOrderItem uocSaleOrderItem);

    void updateSaleOrderItemAfterServingCount(UocSaleOrderItem uocSaleOrderItem);

    /**
         * 描述：修改超验标识
         *
         * @author: daiyuanyuan
         * @date:   2022-04-11 16:24
         */
	void modifyInspSuper(UocSaleOrderItemPo uocSaleOrderItemPo);

    void modifyItemRefuseCountConfirm(UocSaleOrderItem uocSaleOrderItem);

	void modifyItemArriveCountConfirm(UocSaleOrderItem uocSaleOrderItem);
	/**
	 * 描述：更新销售单明采购单价 purchase_fee  purchase_price
	 *
	 * @author: daiyuanyuan
	 * @date:   2022-04-02 16:00
	 */
	void modifyBatchItemPurchasePrice(@Param("list") List<UocSaleOrderItemPo> list,@Param("uocSaleOrderItemPo") UocSaleOrderItemPo uocSaleOrderItemPo);

	void modifyItemChngCountRefuse(UocSaleOrderItem saleOrderItem);

	void modifyItemChngCountConfirm(UocSaleOrderItem saleOrderItem);

	void modifyItemChngCountConfirmAdd(UocSaleOrderItem saleOrderItem);

	void modifyItemChngCountConfirmReduce(UocSaleOrderItem saleOrderItem);
    
    int updateAccount(@Param("set") UocSaleOrderItemPo set, @Param("where") UocSaleOrderItemPo where);

	List<UocTransactionPrice> qryTransactionPrice(UocTransactionPrice reqBO);
}
