package com.tydic.dyc.oc.repository.dao;

import com.tydic.dyc.oc.repository.po.UocTodoPo;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:UocTodoMapper
 * 说明:待办
 * 时间:2022-10-27 10:04
 * 作者:王久鑫
 **/
@Mapper
@Repository
public interface UocTodoMapper {

	/**
	 * 插入单条数据
	 * @param uocTodoPo
	 * @return
	 */
	int insert(UocTodoPo uocTodoPo);

	/**
	 * 根据主键更新数据
	 * @param uocTodoPo
	 * @return
	 */
	int updateById(UocTodoPo uocTodoPo);


	/**
	 * 根据条件查询单条数据
	 * @param uocTodoPo
	 * @return
	 */
	UocTodoPo getModelBy(UocTodoPo uocTodoPo);

	/**
	 * 根据条件查询列表数据
	 * @param uocTodoPo
	 * @return
	 */
	List<UocTodoPo> getList(UocTodoPo uocTodoPo);


	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocTodoPo> list);

}
