package com.tydic.dyc.oc.repository.po;

import lombok.Data;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 描述：system_busi_log
 * 
 * @author 文乐
 * @date 2023-07-21 18:09
 **/
@Data
public class SystemBusiLogPO implements Serializable {
	private static final long serialVersionUID =  2259435862570362910L;

	/**
	 * 日志数据id
	 */
	private Long logId;
	/**
	 * 系统类型，1内部系统，2外部系统
	 */
	private Integer systemType;
	/**
	 * 日志方向，1正向日志，2回滚日志
	 */
	private Integer logType;
	/**
	 * 日志类型，1成功日志，2失败日志
	 */
	private Integer logFlag;
	/**
	 * 分库键对象id
	 */
	private Long partitionObjId;
	/**
	 * 业务对象id
	 */
	private Long busiObjId;
	/**
	 * 业务对象类型，1单品   2.商品   3.协议   4.审批单  
	 */
	private Integer busiObjType;
	/**
	 * 业务场景类型，1提交 2上架 3下架 4恢复上架 5冻结 6加价 7修改商品信息 8推送待办 9发送通知 10同步单品索引 11同步一物一码状态 12 同步一物一码价格 13协议变更
	 */
	private Integer busiType;
	/**
	 * 发起调用服务类（记录类名）
	 */
	private String sendService;
	/**
	 * 被调用服务类（记录类名）
	 */
	private String callService;
	/**
	 * 入参
	 */
	private String reqParam;
	/**
	 * 出参
	 */
	private String rspParam;
	/**
	 * 创建时间，外传（对应业务发生时间，根据业务排序）
	 */
	private Date createTime;
	private Date createTimeStart;
	private Date createTimeEnd;
	/**
	 * 创建时间，内部生成
	 */
	private Date createTimeInner;
	private Date createTimeInnerStart;
	private Date createTimeInnerEnd;
	/**
	 * 涉及金额
	 */
	private BigDecimal amount;
	/**
	 * 失败次数
	 */
	private Integer failureCount;
	/**
	 * 最后失败原因
	 */
	private String failureReason;
	/**
	 * 删除标志，1删，0未删，默认0
	 */
	private Integer delFlag;
	/**
	 * 排序
	 */
	private String orderBy;

}
