package com.tydic.dyc.oc.repository.po;


import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 标题:UocOrderPo
 * 说明:订单表
 * 时间:2022-04-11 16:23
 * 作者:罗有
 **/
@Data
@EqualsAndHashCode(callSuper=false)
public class UocOrderPo implements Serializable {
	private static final long serialVersionUID = -343583979265797397L;

	//订单id")
	private Long orderId;

	//父订单id")
	private Long upperOrderId;

	//订单编码")
	private String orderNo;

	//外部订单编码")
	private String orderNoExt;

	//订单名称")
	private String orderName;

	//下单系统")
	private String orderSystem;

	//订单级别             1 个人订单             2 企业订单")
	private Integer orderLevel;

	//订单类型 :1.采购电商")
	private Integer orderType;

	//支付类型")
	private Integer payMod;

	//支付方式")
	private String payType;

	//支付状态")
	private String payState;

	//需要开票标识 0不开票 1需要开票")
	private Integer needInvoiceTag;

	//订单状态")
	private String orderState;

	//流转状态")
	private String procState;

	//订单说明")
	private String orderDesc;

	//销售金额")
	private BigDecimal totalSaleFee;

	//采购金额")
	private BigDecimal totalPurchaseFee;

	//优惠金额")
	private BigDecimal totalActShareFee;

	//收货地址ID")
	private Long contactId;

	//运费")
	private BigDecimal totalTransFee;

	//实付金额")
	private BigDecimal usedFee;

	//实付积分")
	private BigDecimal usedIntegral;

	//竣工标志       0 在途         1 竣工          ")
	private Integer finishFlag;

	//租户ID")
	private String tenantId;

	//送货时间")
	private Date sendTime;

	//送货时间 开始")
	private Date sendTimeStart;

	//送货时间 结束")
	private Date sendTimeEnd;

	//创建时间")
	private Date createTime;

	//创建时间 开始")
	private Date createTimeStart;

	//创建时间 结束")
	private Date createTimeEnd;

	//创建工号")
	private String createOperId;

	//创建人名称")
	private String createOperName;

	//更新时间")
	private Date updateTime;

	//更新时间 开始")
	private Date updateTimeStart;

	//更新时间 结束")
	private Date updateTimeEnd;

	//更新工号")
	private String updateOperId;

	//更新人名称")
	private String updateOperName;

	//撤单时间")
	private Date cancelTime;

	//撤单时间 开始")
	private Date cancelTimeStart;

	//撤单时间 结束")
	private Date cancelTimeEnd;

	//撤单工号")
	private String cancelOperId;

	//撤单原因")
	private String cancelReason;

	//撤单标志:1 已撤单             0 未撤单")
	private Integer cancelFlag;

	//备注")
	private String remark;

	//竣工时间")
	private Date finishTime;

	//竣工时间 开始")
	private Date finishTimeStart;

	//竣工时间 结束")
	private Date finishTimeEnd;

	//逾期时间")
	private Date expTime;

	//逾期时间 开始")
	private Date expTimeStart;

	//逾期时间 结束")
	private Date expTimeEnd;

	//扩展字段1")
	private String extField1;

	//扩展字段2")
	private String extField2;

	//扩展字段3")
	private String extField3;

	//扩展字段4")
	private String extField4;

	//扩展字段5")
	private String extField5;

	//扩展字段6")
	private String extField6;

	//扩展字段7")
	private String extField7;

	//扩展字段8")
	private String extField8;

	//扩展字段9")
	private String extField9;

	//扩展字段10")
	private String extField10;

	//删除标志1已删除")
	private Integer delTag;

	//排序")
	private String orderBy;

	/**
	 * 用户类型：1 外部个人 2 外部企业 3内部个人 4 内部企业
	 */
	private String userType;
	 //@DocField(value = "归档表后缀")
	private String dataAchiveTabSuffix;

}
