/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.security.filter;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tydic.umc.security.base.UmcMemInfoBO;
import com.tydic.umc.security.base.UmcMemInfoHelper;
import com.tydic.umc.security.base.UmcUserDetails;
import com.tydic.umc.security.filter.ParameterRequestWrapper;
import com.tydic.umc.security.jwt.UmcJwt;
import com.tydic.umc.security.jwt.UmcTokenState;
import com.tydic.umc.security.service.GetLogInUserInfoService;
import com.tydic.umc.security.service.LoginTimeServcie;
import com.tydic.umc.security.service.bo.GetLogInUserInfoReqBo;
import com.tydic.umc.security.service.bo.LoginExpTimeReqBO;
import com.tydic.umc.security.service.bo.LoginExpTimeRspBO;
import com.tydic.umc.security.utils.RegexUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.minidev.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.GenericFilterBean;

@Order(value=0x7FFFFFFD)
@Component
public class UmcTokenAuthenticationFilter
extends GenericFilterBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcTokenAuthenticationFilter.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    @Value(value="${static.resources}")
    private String staticResources;
    @Value(value="${black.list.url:}")
    private String blackListUrl;
    @Value(value="${login.expTime:7200}")
    private Long expTime;
    @Value(value="${login.whiteFlag:true}")
    private Boolean whiteFlag;
    private static ThreadLocal<Boolean> allowSessionCreation = new ThreadLocal();
    @Autowired
    private GetLogInUserInfoService getLogInUserInfoService;
    @Autowired
    private LoginTimeServcie loginTimeServcie;
    @Value(value="${verify.referer}")
    private String verifyReferer;
    @Value(value="${login.checkSessionJwt:false}")
    private Boolean checkSessionJwt;
    @Value(value="${gateway.request.prefix:SAAS_GROUP_DEV}")
    private String gatewayRequestPrefix;
    @Value(value="${gateway.request.no.auth.pwd:1qaz@WSX}")
    private String gatewayRequestNoAuthPwd;
    private static final String AUTH_FLAG_NO = "0";
    @Value(value="${nginxRejectHeadParam:127.0.0.1;127.0.0.2}")
    private String nginxRejectHeadParam;
    private String[] verifyReferers = null;

    @PostConstruct
    public void init() {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.verifyReferer})) {
            this.verifyReferers = this.verifyReferer.split(",");
        }
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException {
        LOGGER.debug("\u8bf7\u6c42\u5934" + mapper.writeValueAsString((Object)request.getParameterMap()));
        String referer = request.getHeader("Referer");
        boolean isCsr = true;
        for (String vReferer : this.verifyReferers) {
            if (referer != null && !referer.trim().startsWith(vReferer)) continue;
            isCsr = false;
            break;
        }
        String token = request.getHeader("auth-token");
        LOGGER.debug("\u67e5\u770b\u8bf7\u6c42cookie" + mapper.writeValueAsString((Object)request.getCookies()));
        if (StringUtils.isEmpty((CharSequence)token)) {
            Cookie[] cookies = request.getCookies();
            request.getSession().getId();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!cookie.getName().equals("auth-token")) continue;
                    token = cookie.getValue();
                }
            }
        }
        com.alibaba.fastjson.JSONObject jsonObject = new com.alibaba.fastjson.JSONObject();
        com.alibaba.fastjson.JSONObject dataJsonObject = new com.alibaba.fastjson.JSONObject();
        LOGGER.debug("\u83b7\u53d6\u5f53\u524dtoken" + token);
        if (token == null) {
            dataJsonObject.put("respCode", (Object)"AE401");
            dataJsonObject.put("respDesc", (Object)"\u767b\u5f55\u4fe1\u606f\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
            jsonObject.put("data", (Object)dataJsonObject);
        } else {
            JSONObject payload = UmcJwt.getPayload(token);
            String whiteList = payload.getAsString("whiteList");
            if (!this.whiteFlag.booleanValue()) {
                whiteList = null;
            }
            LoginExpTimeReqBO reqBO = new LoginExpTimeReqBO();
            Long loginExpTime = 0L;
            if (StringUtils.isBlank((CharSequence)whiteList)) {
                reqBO.setToken(token);
                LoginExpTimeRspBO rspBO = this.loginTimeServcie.getLoginExpTime(reqBO);
                LOGGER.debug("\u8c03\u7528\u83b7\u53d6\u5230\u671f\u65f6\u95f4\u670d\u52a1" + JSON.toJSONString((Object)((Object)rspBO)));
                if ("0000".equals(rspBO.getRespCode())) {
                    loginExpTime = rspBO.getExpTime();
                    LOGGER.debug("\u83b7\u53d6\u5230\u671f\u65f6\u95f4" + loginExpTime);
                }
            }
            Map<String, Object> resultMap = UmcJwt.validToken(token, loginExpTime, whiteList);
            LOGGER.debug("\u89e3\u6790\u5b8c\u6210\u540e\u53c2\u6570\uff1a" + mapper.writeValueAsString(resultMap));
            UmcTokenState state = UmcTokenState.getTokenState((String)resultMap.get("state"));
            LOGGER.debug("\u67e5\u770bstate\uff1a" + mapper.writeValueAsString((Object)state));
            switch (state) {
                case VALID: {
                    JSONObject data = (JSONObject)resultMap.get("data");
                    request.setAttribute("data", (Object)data);
                    String appCode = data.getAsString("appCode");
                    if (isCsr && !referer.equals(data.getAsString("referer"))) {
                        LOGGER.error("\u7591\u4f3cCSRF\u653b\u51fb\uff0creferer:" + referer);
                        response.setContentType("text/html;charset=UTF-8");
                        response.setCharacterEncoding("UTF-8");
                        response.setStatus(403);
                        response.getWriter().print("<font size=6 color=red>\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u8bf7\u6c42\u975e\u6cd5\uff0c\u7cfb\u7edf\u62d2\u7edd\u54cd\u5e94!</font>");
                        return null;
                    }
                    if (this.checkSessionJwt.booleanValue()) {
                        String sessionIdJwt = data.getAsString("sessionId");
                        String sessionId = request.getSession().getId();
                        if (!sessionId.equals(sessionIdJwt)) {
                            dataJsonObject.put("respCode", (Object)"AE401");
                            dataJsonObject.put("respDesc", (Object)"\u767b\u5f55\u4fe1\u606f\u5f02\u5e38");
                            jsonObject.put("data", (Object)dataJsonObject);
                            break;
                        }
                    }
                    reqBO.setUserId((Long)data.get((Object)"userId"));
                    reqBO.setLoginSource((String)data.get((Object)"loginSource"));
                    this.loginTimeServcie.updateLoginExpTime(reqBO);
                    GetLogInUserInfoReqBo userReqBo = new GetLogInUserInfoReqBo();
                    userReqBo.setTagId((String)data.get((Object)"tagId"));
                    userReqBo.setUserId((Long)data.get((Object)"userId"));
                    userReqBo.setToken(token);
                    userReqBo.setUri(request.getRequestURI());
                    userReqBo.setAppCode(appCode);
                    userReqBo.setLoginSource(reqBO.getLoginSource());
                    UmcUserDetails user = this.getLogInUserInfoService.getLoginUserInfo(userReqBo);
                    if ("0000".equals(user.getRespCode())) {
                        return new UsernamePasswordAuthenticationToken((Object)user.getUserDetails(), (Object)user.getUserDetails().getPassword(), user.getUserDetails().getAuthorities());
                    }
                    dataJsonObject.put("respCode", (Object)user.getRespCode());
                    dataJsonObject.put("respDesc", (Object)user.getRespDesc());
                    jsonObject.put("data", (Object)dataJsonObject);
                    LOGGER.info(user.getRespCode());
                    break;
                }
                case EXPIRED: {
                    dataJsonObject.put("respCode", (Object)"AE401");
                    dataJsonObject.put("respDesc", (Object)"\u767b\u5f55\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
                    jsonObject.put("data", (Object)dataJsonObject);
                    break;
                }
                default: {
                    dataJsonObject.put("respCode", (Object)"AE401");
                    dataJsonObject.put("respDesc", (Object)"\u767b\u5f55\u4fe1\u606f\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
                    jsonObject.put("data", (Object)dataJsonObject);
                }
            }
        }
        if ("AE403".equals(dataJsonObject.getString("respCode"))) {
            response.setStatus(403);
        } else {
            response.setStatus(401);
        }
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        jsonObject.put("code", (Object)"1");
        jsonObject.put("message", (Object)"\u5931\u8d25");
        String jsonString = jsonObject.toJSONString();
        LOGGER.debug("\u8d70\u5b8c\u8fc7\u6ee4\u5668\u6253\u5370\u65e5\u5fd7\uff1a" + jsonString);
        out.write(jsonString);
        out.close();
        return null;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        boolean needTokenFlag;
        allowSessionCreation.set(true);
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        ServletRequest requestWrapper = null;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.blackListUrl})) {
            String[] split;
            for (String blackUrl : split = this.blackListUrl.split(";")) {
                if (!RegexUtils.wildcardEquals(blackUrl, request.getRequestURI())) continue;
                response.setStatus(404);
                response.setContentType("text/html;charset=UTF-8");
                PrintWriter out = response.getWriter();
                com.alibaba.fastjson.JSONObject jsonObject = new com.alibaba.fastjson.JSONObject();
                jsonObject.put("code", (Object)"1");
                jsonObject.put("message", (Object)"\u5931\u8d25");
                String jsonString = jsonObject.toJSONString();
                LOGGER.debug("\u9ed1\u540d\u5355:{}", (Object)request.getRequestURI());
                out.write(jsonString);
                out.close();
                return;
            }
        }
        if (needTokenFlag = this.isNeedToken(request)) {
            Authentication auth = this.attemptAuthentication(request, response);
            if (auth == null) {
                return;
            }
            allowSessionCreation.set(false);
            SecurityContextHolder.getContext().setAuthentication(auth);
            requestWrapper = this.parameterRequest(request.getHeader("auth-token"), request, response);
            HashMap hashMap = new HashMap(requestWrapper.getParameterMap());
        }
        if (requestWrapper == null) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            LOGGER.debug("UmcUserInfoWrapperFilter---1\uff1a");
        } else {
            LOGGER.debug("UmcUserInfoWrapperFilter---2\uff1a");
            chain.doFilter(requestWrapper, (ServletResponse)response);
        }
    }

    private boolean isNeedToken(HttpServletRequest request) {
        String authFlag;
        String nginxIps;
        String url = request.getRequestURI();
        boolean needToken = true;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.staticResources})) {
            String[] split;
            for (String staticResource : split = this.staticResources.split(";")) {
                if (!RegexUtils.wildcardEquals(staticResource, url)) continue;
                return false;
            }
        }
        if (!StringUtils.isBlank((CharSequence)(nginxIps = request.getHeader("X-forwarded-for")))) {
            String[] confIps;
            for (String ip : confIps = this.nginxRejectHeadParam.split(";")) {
                if (StringUtils.isBlank((CharSequence)ip) || !nginxIps.contains(ip)) continue;
                return true;
            }
        }
        if (!StringUtils.isBlank((CharSequence)(authFlag = request.getHeader("auth-flag"))) && url.startsWith(this.gatewayRequestPrefix) && AUTH_FLAG_NO.equals(authFlag) && this.gatewayRequestNoAuthPwd.equals(request.getHeader("auth-pwd"))) {
            needToken = false;
        }
        if (RegexUtils.wildcardEquals("**/**/users/signup/**", url)) {
            needToken = false;
        }
        if (RegexUtils.wildcardEquals("**/**/noauth/**", url)) {
            needToken = false;
        }
        if (RegexUtils.wildcardEquals("**/**/**/noauth/**", url)) {
            needToken = false;
        }
        if (RegexUtils.wildcardEquals("**/**/api/token/get", url)) {
            needToken = false;
        }
        return needToken;
    }

    private ServletRequest parameterRequest(String token, HttpServletRequest request, HttpServletResponse response) {
        UmcMemInfoBO userInfo = UmcMemInfoHelper.getCurrentUser();
        ParameterRequestWrapper requestWrapper = null;
        if (userInfo != null) {
            if (LOGGER.isDebugEnabled()) {
                // empty if block
            }
            if (userInfo.getUserId() != null && request instanceof HttpServletRequest) {
                LOGGER.debug("UmcUserInfoWrapperFilter---\u81ea\u5b9a\u4e49\u5305\u88c5\u5668\uff1a");
                requestWrapper = new ParameterRequestWrapper(request);
            }
        }
        LOGGER.debug("UmcUserInfoWrapperFilter---requestWrapper\uff1a");
        return requestWrapper;
    }

    public static boolean isAllowSessionCreation() {
        return allowSessionCreation.get();
    }
}

