/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.pay.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.atom.base.utils.DycEsbUtil;
import com.tydic.dyc.atom.base.utils.DycPropertiesUtil;
import com.tydic.dyc.atom.pay.api.DycFscBillOrderPushFunction;
import com.tydic.dyc.atom.pay.bo.DycFscComOrderPushRspBO;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DycFscBillOrderPushFunctionImpl
implements DycFscBillOrderPushFunction {
    private static final Logger log = LoggerFactory.getLogger(DycFscBillOrderPushFunctionImpl.class);
    @Value(value="${esb.retry.count}")
    private int esbRetryCount;

    @Override
    public DycFscComOrderPushRspBO billOrderPush(Map<String, Object> reqBO) {
        DycFscComOrderPushRspBO rspBo = new DycFscComOrderPushRspBO();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        String callUrl = DycPropertiesUtil.getProperty((String)"ESB_PUSH_BILL_ORDER_URL");
        log.info("\u8c03\u7528\u63a8\u9001\u62a5\u8d26\u4fe1\u606f\u63a5\u53e3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(reqBO));
        int retryCount = this.esbRetryCount;
        int retryInterval = 1000;
        rspBo.setPushStatus(1);
        boolean aBoolean = true;
        for (int retry = 0; retry < retryCount; ++retry) {
            log.info("\u63a8\u9001\u62a5\u8d26\u4fe1\u606f\u5931\u8d25\uff0c\u5f00\u59cb\u7b2c{}\u6b21\u91cd\u8bd5", (Object)(retry + 1));
            String returnString = DycEsbUtil.doPostReuest((String)callUrl, (String)JSON.toJSONString(reqBO));
            log.info("\u63a8\u9001\u62a5\u8d26\u4fe1\u606f\u7b2c{}\u6b21\u91cd\u8bd5\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)(retry + 1), (Object)returnString);
            JSONObject jsonObject = JSONObject.parseObject((String)returnString);
            Object o1 = jsonObject.get((Object)"code");
            if (null == o1 || !StringUtils.equals((CharSequence)"000000000", (CharSequence)o1.toString())) {
                aBoolean = false;
            } else {
                JSONObject data = jsonObject.getJSONObject("msgType");
                if (null != data) {
                    Object isSuccess = data.get((Object)"name");
                    if (null == isSuccess || !StringUtils.equals((CharSequence)"SUCCESS", (CharSequence)isSuccess.toString())) {
                        aBoolean = false;
                    }
                } else {
                    aBoolean = false;
                }
            }
            if (aBoolean) {
                rspBo.setPushStatus(1);
                break;
            }
            rspBo.setPushStatus(2);
            rspBo.setRespCode((String)jsonObject.get((Object)"resultCode"));
            rspBo.setRespDesc((String)jsonObject.get((Object)"resultMessage"));
            try {
                Thread.sleep(retryInterval);
                continue;
            }
            catch (InterruptedException e) {
                log.error("\u63a8\u9001\u62a5\u8d26\u4fe1\u606f\u5931\u8d25\uff0c\u91cd\u8bd5\u95f4\u9694\u5f02\u5e38", (Throwable)e);
            }
        }
        return rspBo;
    }
}

