/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.selfrun.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.base.utils.DycEsbUtil;
import com.tydic.dyc.atom.base.utils.DycPropertiesUtil;
import com.tydic.dyc.atom.base.utils.IdUtil;
import com.tydic.dyc.atom.selfrun.api.DycUocProjectBudgetControlFunction;
import com.tydic.dyc.atom.selfrun.bo.DycUocProjectBudgetControlFuncReqBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocProjectBudgetControlFuncRspBO;
import com.tydic.dyc.atom.selfrun.bo.UocProjectBudgetControlFailFuncBO;
import com.tydic.dyc.atom.selfrun.util.EsbQryProjectHeaderUtil;
import com.tydic.dyc.psbc.api.budgetrecord.BudgetControlRecordApiService;
import com.tydic.dyc.psbc.bo.budgetrecord.ProjectBudgetControlInfoBo;
import com.tydic.dyc.psbc.bo.budgetrecord.ProjectBudgetControlQryRspBo;
import com.tydic.dyc.psbc.bo.budgetrecord.ProjectBudgetControlReqBo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DycUocProjectBudgetControlFunctionImpl
implements DycUocProjectBudgetControlFunction {
    private static final Logger log = LoggerFactory.getLogger(DycUocProjectBudgetControlFunctionImpl.class);
    @Autowired
    private BudgetControlRecordApiService budgetControlApiService;

    @Override
    public DycUocProjectBudgetControlFuncRspBO projectBudgetControl(DycUocProjectBudgetControlFuncReqBO reqBO) {
        Integer modifyType = reqBO.getModifyType();
        Integer operationStatus = 1;
        ProjectBudgetControlReqBo budgetControlServiceReqBo = new ProjectBudgetControlReqBo();
        switch (modifyType) {
            case 1: {
                BeanUtils.copyProperties((Object)((Object)reqBO), (Object)budgetControlServiceReqBo);
                budgetControlServiceReqBo.setOrgId(reqBO.getOrgId());
                budgetControlServiceReqBo.setCreateTime(new Date());
                budgetControlServiceReqBo.setId(Long.valueOf(IdUtil.nextId()));
                this.budgetControlApiService.save(budgetControlServiceReqBo);
                break;
            }
            case 2: {
                if (reqBO.getOperationType() != 0) {
                    return null;
                }
                ProjectBudgetControlReqBo budgetControlQryReq = new ProjectBudgetControlReqBo();
                BeanUtils.copyProperties((Object)((Object)reqBO), (Object)budgetControlQryReq);
                budgetControlQryReq.setPageNo(Integer.valueOf(1));
                budgetControlQryReq.setPageSize(Integer.valueOf(1));
                ProjectBudgetControlQryRspBo uocProjectBudgetControlQryServiceRspBo = this.budgetControlApiService.query(budgetControlQryReq);
                List rows = uocProjectBudgetControlQryServiceRspBo.getRows();
                ProjectBudgetControlInfoBo infoBo = (ProjectBudgetControlInfoBo)rows.get(0);
                BeanUtils.copyProperties((Object)infoBo, (Object)budgetControlServiceReqBo);
                reqBO = new DycUocProjectBudgetControlFuncReqBO();
                BeanUtils.copyProperties((Object)infoBo, (Object)((Object)reqBO));
                break;
            }
        }
        DycUocProjectBudgetControlFuncRspBO dycUocProjectBudgetControlRspBO = this.projectBudgetModify(reqBO);
        if (!"0000".equals(dycUocProjectBudgetControlRspBO.getRespCode()) || !dycUocProjectBudgetControlRspBO.getIsSuccess().booleanValue()) {
            operationStatus = 2;
            List<UocProjectBudgetControlFailFuncBO> failList = dycUocProjectBudgetControlRspBO.getFailList();
            if (null != failList && !failList.isEmpty()) {
                UocProjectBudgetControlFailFuncBO uocProjectBudgetControlFailBO = failList.get(0);
                budgetControlServiceReqBo.setFailureReason(uocProjectBudgetControlFailBO.getErrorMsg());
            }
        } else {
            operationStatus = 1;
        }
        budgetControlServiceReqBo.setOperationType(reqBO.getOperationType());
        budgetControlServiceReqBo.setOperationStatus(operationStatus);
        this.budgetControlApiService.update(budgetControlServiceReqBo);
        return dycUocProjectBudgetControlRspBO;
    }

    public DycUocProjectBudgetControlFuncRspBO projectBudgetModify(DycUocProjectBudgetControlFuncReqBO reqBO) {
        DycUocProjectBudgetControlFuncRspBO rspBO = new DycUocProjectBudgetControlFuncRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setIsSuccess(true);
        rspBO.setSaleOrderNo(reqBO.getSaleOrderNo());
        JSONObject json = new JSONObject();
        this.initParams(json, reqBO);
        try {
            log.info("\u9879\u76ee\u9884\u7b97\u63a7\u5236\u63a5\u53e3\u5165\u53c2\uff1a" + json.toJSONString());
            log.info("\u9879\u76ee\u9884\u7b97\u63a7\u5236\u63a5\u53e3url\uff1a" + DycPropertiesUtil.getProperty((String)"ESB_PROJECT_BUDGET_CONTROL"));
            String httpRspStr = DycEsbUtil.doPostReuest((String)DycPropertiesUtil.getProperty((String)"ESB_PROJECT_BUDGET_CONTROL"), (String)json.toJSONString());
            log.info("\u9879\u76ee\u9884\u7b97\u63a7\u5236\u63a5\u53e3,\u8fd4\u56de\u51fa\u53c2: {}", (Object)httpRspStr);
            JSONObject jsonObject = JSONObject.parseObject((String)httpRspStr);
            JSONObject data = jsonObject.getJSONObject("data");
            Object isSuccess = data.get((Object)"isSuccess");
            if (null == isSuccess || StringUtils.equals((CharSequence)"1", (CharSequence)isSuccess.toString())) {
                rspBO.setIsSuccess(false);
                JSONArray errorList = data.getJSONArray("errorList");
                List budgetControlFailBOS = Optional.ofNullable(errorList.toJavaList(UocProjectBudgetControlFailFuncBO.class)).orElse(new ArrayList());
                rspBO.setFailList(budgetControlFailBOS);
            }
        }
        catch (ZTBusinessException e) {
            log.error("\u9879\u76ee\u9884\u7b97\u63a7\u5236\u5f02\u5e38: {}", (Object)e.getMessage());
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u9879\u76ee\u9884\u7b97\u63a7\u5236\u5931\u8d25");
            return rspBO;
        }
        return rspBO;
    }

    private void initParams(JSONObject json, DycUocProjectBudgetControlFuncReqBO reqBO) {
        JSONObject txHeader = EsbQryProjectHeaderUtil.initTxHeader();
        JSONObject txBody = new JSONObject();
        JSONObject txEntity = new JSONObject();
        JSONObject data = new JSONObject();
        data.put("busiId", (Object)reqBO.getSaleOrderNo());
        data.put("ctrtType", (Object)reqBO.getCtrtType());
        data.put("projId", (Object)reqBO.getProjectId());
        data.put("projNo", (Object)reqBO.getProjectNo());
        data.put("lvl1SceneId", (Object)reqBO.getLvl1SceneId());
        data.put("lvl2SceneId", (Object)reqBO.getLvl2SceneId());
        data.put("projType", (Object)reqBO.getProjectType());
        data.put("busiHappAmt", (Object)reqBO.getTotalSaleFee());
        data.put("ctrlFlag", (Object)(reqBO.getOperationType() == 1 ? "1" : "0"));
        JSONArray dataArray = new JSONArray();
        dataArray.add((Object)data);
        txEntity.put("data", (Object)dataArray);
        txBody.put("txEntity", (Object)txEntity);
        json.put("txBody", (Object)txBody);
        json.put("txHeader", (Object)txHeader);
    }
}

