/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.selfrun.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.base.utils.DycEsbUtil;
import com.tydic.dyc.atom.base.utils.DycPropertiesUtil;
import com.tydic.dyc.atom.base.utils.IdUtil;
import com.tydic.dyc.atom.selfrun.api.DycUocPushPurchaseInfoFunction;
import com.tydic.dyc.atom.selfrun.bo.DycUocPurchaseItemFuncBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocPushPurchaseInfoFuncReqBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocPushPurchaseInfoFuncRspBO;
import com.tydic.dyc.atom.selfrun.util.EsbQryProjectHeaderUtil;
import com.tydic.dyc.psbc.api.pushPurchaseInfo.PsbcPushPurchaseInfoRecordApiService;
import com.tydic.dyc.psbc.bo.budgetrecord.PushPurchaseInfoQryRspBo;
import com.tydic.dyc.psbc.bo.budgetrecord.PushPurchaseInfoReqBo;
import com.tydic.dyc.psbc.bo.budgetrecord.PushPurchaseInfoRspBo;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DycUocPushPurchaseInfoFunctionImpl
implements DycUocPushPurchaseInfoFunction {
    private static final Logger log = LoggerFactory.getLogger(DycUocPushPurchaseInfoFunctionImpl.class);
    @Autowired
    private PsbcPushPurchaseInfoRecordApiService purchaseInfoRecordService;

    @Override
    public DycUocPushPurchaseInfoFuncRspBO pushPurchaseInfo(DycUocPushPurchaseInfoFuncReqBO reqBO) {
        Integer modifyType = reqBO.getModifyType();
        Integer operationStatus = 1;
        PushPurchaseInfoReqBo purchaseInfoReqBo = new PushPurchaseInfoReqBo();
        String jsonStr = "";
        switch (modifyType) {
            case 1: {
                BeanUtils.copyProperties((Object)reqBO, (Object)purchaseInfoReqBo);
                purchaseInfoReqBo.setOrgId(reqBO.getOrgId());
                purchaseInfoReqBo.setCreateTime(new Date());
                purchaseInfoReqBo.setId(Long.valueOf(IdUtil.nextId()));
                JSONObject json = new JSONObject();
                this.initParams(json, reqBO);
                jsonStr = json.toJSONString();
                purchaseInfoReqBo.setReqData(jsonStr);
                this.purchaseInfoRecordService.save(purchaseInfoReqBo);
                break;
            }
            case 2: {
                PushPurchaseInfoReqBo budgetControlQryReq = new PushPurchaseInfoReqBo();
                BeanUtils.copyProperties((Object)reqBO, (Object)budgetControlQryReq);
                budgetControlQryReq.setPageNo(Integer.valueOf(1));
                budgetControlQryReq.setPageSize(Integer.valueOf(1));
                PushPurchaseInfoQryRspBo pushPurchaseInfoQryRspBo = this.purchaseInfoRecordService.query(budgetControlQryReq);
                List rows = pushPurchaseInfoQryRspBo.getRows();
                PushPurchaseInfoRspBo infoBo = (PushPurchaseInfoRspBo)rows.get(0);
                BeanUtils.copyProperties((Object)infoBo, (Object)purchaseInfoReqBo);
                reqBO = new DycUocPushPurchaseInfoFuncReqBO();
                BeanUtils.copyProperties((Object)infoBo, (Object)reqBO);
                jsonStr = infoBo.getReqData();
                break;
            }
        }
        DycUocPushPurchaseInfoFuncRspBO dycUocProjectBudgetControlRspBO = this.push(reqBO, jsonStr);
        if (!"0000".equals(dycUocProjectBudgetControlRspBO.getRespCode()) || !dycUocProjectBudgetControlRspBO.getIsSuccess().booleanValue()) {
            operationStatus = 2;
            purchaseInfoReqBo.setFailureReason(dycUocProjectBudgetControlRspBO.getErrorMsg());
        } else {
            operationStatus = 1;
        }
        purchaseInfoReqBo.setOperationType(reqBO.getOperationType());
        purchaseInfoReqBo.setOperationStatus(operationStatus);
        this.purchaseInfoRecordService.update(purchaseInfoReqBo);
        return dycUocProjectBudgetControlRspBO;
    }

    public DycUocPushPurchaseInfoFuncRspBO push(DycUocPushPurchaseInfoFuncReqBO reqBO, String reqStr) {
        DycUocPushPurchaseInfoFuncRspBO rspBO = new DycUocPushPurchaseInfoFuncRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setIsSuccess(true);
        rspBO.setSaleOrderNo(reqBO.getSaleOrderNo());
        try {
            log.info("\u63a8\u9001\u91c7\u8d2d\u660e\u7ec6\u63a5\u53e3\u5165\u53c2\uff1a" + reqStr);
            log.info("\u63a8\u9001\u91c7\u8d2d\u660e\u7ec6\u63a5\u53e3url\uff1a" + DycPropertiesUtil.getProperty((String)"ESB_PUSH_PURCHASE_INFO"));
            String httpRspStr = DycEsbUtil.doPostReuest((String)DycPropertiesUtil.getProperty((String)"ESB_PUSH_PURCHASE_INFO"), (String)reqStr);
            log.info("\u63a8\u9001\u91c7\u8d2d\u660e\u7ec6\u63a5\u53e3,\u8fd4\u56de\u51fa\u53c2: {}", (Object)httpRspStr);
            JSONObject jsonObject = JSONObject.parseObject((String)httpRspStr);
            Object o1 = jsonObject.get((Object)"code");
            if (null == o1 || !StringUtils.equals((CharSequence)"000000000", (CharSequence)o1.toString())) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc(jsonObject.get((Object)"message").toString());
                return rspBO;
            }
        }
        catch (ZTBusinessException e) {
            log.error("\u63a8\u9001\u91c7\u8d2d\u660e\u7ec6\u5f02\u5e38: {}", (Object)e.getMessage());
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u63a8\u9001\u91c7\u8d2d\u660e\u7ec6\u5931\u8d25");
            return rspBO;
        }
        return rspBO;
    }

    private void initParams(JSONObject json, DycUocPushPurchaseInfoFuncReqBO reqBO) {
        JSONObject txHeader = EsbQryProjectHeaderUtil.initTxHeader();
        JSONObject txBody = new JSONObject();
        JSONObject txEntity = new JSONObject();
        JSONObject data = new JSONObject();
        BigDecimal totalPurchaseFee = reqBO.getTotalPurchaseFee();
        data.put("actlPchsAmt", (Object)totalPurchaseFee);
        data.put("exptPchsAmt", (Object)totalPurchaseFee);
        if (reqBO.getOperationType() != 1) {
            data.put("actlPchsAmt", (Object)totalPurchaseFee.negate());
            data.put("exptPchsAmt", (Object)totalPurchaseFee.negate());
        }
        data.put("fixedNumFlag", (Object)reqBO.getFixedNumFlag());
        data.put("pchsDtlFlag", (Object)reqBO.getPchsDtlFlag());
        data.put("instNo", (Object)reqBO.getOrgNo());
        data.put("lvl1SceneId", (Object)reqBO.getLvl1SceneId());
        data.put("lvl2SceneId", (Object)reqBO.getLvl2SceneId());
        data.put("pachName", (Object)reqBO.getSaleOrderNo());
        data.put("pchsId", (Object)reqBO.getSaleOrderNo());
        data.put("projId", (Object)reqBO.getProjectId());
        data.put("projNo", (Object)reqBO.getProjectNo());
        data.put("projType", (Object)reqBO.getProjectType());
        data.put("tellerNo", (Object)reqBO.getTellerNo());
        JSONArray purchaseItemArray = new JSONArray();
        if (null != reqBO.getPchsDtlFlag() && reqBO.getPchsDtlFlag() == 1) {
            for (DycUocPurchaseItemFuncBO item : reqBO.getPurchaseItemList()) {
                JSONObject itemObj = new JSONObject();
                itemObj.put("pchsGoodsName", (Object)item.getPchsGoodsName());
                itemObj.put("pchsGoodsNo", (Object)item.getPchsGoodsNo());
                itemObj.put("projInfoDtlId", (Object)item.getPchsGoodsNo());
                itemObj.put("exptPchsPrice", (Object)item.getPurchasePrice());
                itemObj.put("exptPchsNum", (Object)item.getPurchaseNum());
                itemObj.put("exptPchsStamt", (Object)item.getPurchaseTotalPrice());
                itemObj.put("actlPchsPrice", (Object)item.getActualPurchasePrice());
                itemObj.put("actlPchsNum", (Object)item.getActualPurchaseNum());
                itemObj.put("actlPchsStamt", (Object)item.getActualPurchaseTotalPrice());
                if (reqBO.getOperationType() != 1) {
                    itemObj.put("actlPchsNum", (Object)item.getActualPurchaseNum().negate());
                    itemObj.put("actlPchsStamt", (Object)item.getActualPurchaseTotalPrice().negate());
                }
                purchaseItemArray.add((Object)itemObj);
            }
            data.put("pchsDtlList", (Object)purchaseItemArray);
        }
        txEntity.put("data", (Object)data);
        txBody.put("txEntity", (Object)txEntity);
        json.put("txBody", (Object)txBody);
        json.put("txHeader", (Object)txHeader);
    }
}

