/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.enterprise;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.UmcEnterpriseInfoDo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseOrgQryBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseOrgQryRspBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcOrgInfoRspBo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgInfo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgTagRel;
import com.tydic.dyc.umc.model.sysdictionary.IUmcSysDicDictionaryModel;
import com.tydic.dyc.umc.model.sysdictionary.SysDicDictionaryDo;
import com.tydic.dyc.umc.service.enterprise.UmcQryEnterpriseOrgTreeService;
import com.tydic.dyc.umc.service.enterprise.bo.UmcEnterpriseOrgTreeBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcParentOrgInfoBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryEnterpriseOrgTreeReqBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryEnterpriseOrgTreeRspBo;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.enterprise.UmcQryEnterpriseOrgTreeService"})
public class UmcQryEnterpriseOrgTreeServiceImpl
implements UmcQryEnterpriseOrgTreeService {
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;
    @Autowired
    private IUmcSysDicDictionaryModel iUmcSysDicDictionaryModel;

    @PostMapping(value={"qryEnterpriseOrgTree"})
    public UmcQryEnterpriseOrgTreeRspBo qryEnterpriseOrgTree(@RequestBody UmcQryEnterpriseOrgTreeReqBo reqBo) {
        UmcEnterpriseOrgQryBo enterpriseOrgQryBo = UmcRu.js(reqBo, UmcEnterpriseOrgQryBo.class);
        StrUtil.noNullStringAttr(enterpriseOrgQryBo);
        UmcEnterpriseOrgQryRspBo enterpriseInfoDoBasePageRspBo = this.iUmcEnterpriseInfoModel.getEnterpriseOrgListPage(enterpriseOrgQryBo);
        UmcQryEnterpriseOrgTreeRspBo rspBo = UmcRu.success(UmcQryEnterpriseOrgTreeRspBo.class);
        ArrayList<UmcEnterpriseOrgTreeBo> rows = new ArrayList<UmcEnterpriseOrgTreeBo>(enterpriseInfoDoBasePageRspBo.getRows().size());
        Map<String, String> map = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "ORG_TRADE_CAPACITY")).getMap();
        if (!CollectionUtils.isEmpty((Collection)enterpriseInfoDoBasePageRspBo.getRows())) {
            Map<Long, String> orgIdToNameMap = this.packagingOrgIdToNameMap(enterpriseInfoDoBasePageRspBo.getRows());
            for (UmcEnterpriseInfoDo enterpriseInfoDo : enterpriseInfoDoBasePageRspBo.getRows()) {
                UmcEnterpriseOrgTreeBo enterpriseOrgTreeBo = UmcRu.js((Object)enterpriseInfoDo.getOrgInfo(), UmcEnterpriseOrgTreeBo.class);
                this.setExtend(enterpriseOrgTreeBo, enterpriseInfoDo);
                List<UmcOrgTagRel> orgTagRelList = enterpriseInfoDo.getOrgInfo().getOrgTagRelList();
                if (!CollectionUtils.isEmpty(orgTagRelList)) {
                    List tags = orgTagRelList.stream().map(UmcOrgTagRel::getTagId).collect(Collectors.toList());
                    String tagStr = tags.toString();
                    String isProfessionalOrg = "";
                    isProfessionalOrg = tagStr.contains("2") ? "2" : (tagStr.contains("0") ? "0" : (tagStr.contains("1") ? "1" : ""));
                    enterpriseOrgTreeBo.setIsProfessionalOrg(isProfessionalOrg);
                    enterpriseOrgTreeBo.setIsProfessionalOrgStr(map.get(isProfessionalOrg));
                }
                if (enterpriseInfoDo.getIsParent() > 0) {
                    enterpriseOrgTreeBo.setIsParentOrg("1");
                    enterpriseOrgTreeBo.setIsParent("0");
                } else {
                    enterpriseOrgTreeBo.setIsParentOrg("0");
                    enterpriseOrgTreeBo.setIsParent("1");
                }
                this.packagingParentOrgInfoList(enterpriseOrgTreeBo, orgIdToNameMap);
                rows.add(enterpriseOrgTreeBo);
            }
        }
        rspBo.setRows(rows);
        rspBo.setPageNo(enterpriseInfoDoBasePageRspBo.getPageNo());
        rspBo.setTotal(enterpriseInfoDoBasePageRspBo.getTotal());
        rspBo.setRecordsTotal(enterpriseInfoDoBasePageRspBo.getRecordsTotal());
        return rspBo;
    }

    private void setExtend(UmcEnterpriseOrgTreeBo enterpriseOrgTreeBo, UmcEnterpriseInfoDo enterpriseInfoDo) {
        enterpriseOrgTreeBo.setOrgExtField1(enterpriseInfoDo.getOrgExtField1());
        enterpriseOrgTreeBo.setOrgExtField2(enterpriseInfoDo.getOrgExtField2());
        enterpriseOrgTreeBo.setOrgExtField3(enterpriseInfoDo.getOrgExtField3());
        enterpriseOrgTreeBo.setOrgExtField4(enterpriseInfoDo.getOrgExtField4());
        enterpriseOrgTreeBo.setOrgExtField5(enterpriseInfoDo.getOrgExtField5());
        enterpriseOrgTreeBo.setOrgExtField6(enterpriseInfoDo.getOrgExtField6());
        enterpriseOrgTreeBo.setOrgExtField7(enterpriseInfoDo.getOrgExtField7());
        enterpriseOrgTreeBo.setOrgExtField8(enterpriseInfoDo.getOrgExtField8());
        enterpriseOrgTreeBo.setOrgExtField9(enterpriseInfoDo.getOrgExtField9());
        enterpriseOrgTreeBo.setOrgExtField10(enterpriseInfoDo.getOrgExtField10());
    }

    public Map<Long, String> packagingOrgIdToNameMap(List<UmcEnterpriseInfoDo> umcEnterpriseInfoDoList) {
        ArrayList<Long> orgIds = new ArrayList<Long>(10);
        for (UmcEnterpriseInfoDo umcEnterpriseInfoDo : umcEnterpriseInfoDoList) {
            String[] arr;
            for (String s : arr = umcEnterpriseInfoDo.getOrgInfo().getOrgTreePath().split("-")) {
                orgIds.add(Long.valueOf(s));
            }
        }
        Map<Long, String> orgIdToNameMap = new HashMap<Long, String>(10);
        if (!CollectionUtils.isEmpty(orgIds)) {
            UmcEnterpriseInfoDo umcEnterpriseInfoDo;
            umcEnterpriseInfoDo = new UmcEnterpriseInfoDo();
            umcEnterpriseInfoDo.setOrgIds(orgIds);
            UmcOrgInfoRspBo umcOrgInfoRspBo = this.iUmcEnterpriseInfoModel.batchQueryOrgInfoListByOrgIds(umcEnterpriseInfoDo);
            if (!CollectionUtils.isEmpty((Collection)umcOrgInfoRspBo.getRows())) {
                orgIdToNameMap = umcOrgInfoRspBo.getRows().stream().filter(umcOrgInfo -> ObjectUtil.isNotEmpty((Object)umcOrgInfo.getOrgName())).collect(Collectors.toMap(UmcOrgInfo::getOrgId, UmcOrgInfo::getOrgName, (key1, key2) -> key2));
            }
        }
        return orgIdToNameMap;
    }

    public void packagingParentOrgInfoList(UmcEnterpriseOrgTreeBo enterpriseOrgTreeBo, Map<Long, String> orgIdToNameMap) {
        if (!CollectionUtils.isEmpty(orgIdToNameMap)) {
            ArrayList<UmcParentOrgInfoBo> parentOrgInfoBoList = new ArrayList<UmcParentOrgInfoBo>(10);
            String[] arr = enterpriseOrgTreeBo.getOrgTreePath().split("-");
            if (arr.length > 0 && !arr[arr.length - 1].isEmpty()) {
                String[] trimmedParts = new String[arr.length - 1];
                System.arraycopy(arr, 0, trimmedParts, 0, arr.length - 1);
                ArrayList<String> orgIds = new ArrayList<String>(Arrays.asList(trimmedParts));
                for (String orgId : orgIds) {
                    if (Long.parseLong(orgId) == 1L || !ObjectUtil.isNotEmpty((Object)orgIdToNameMap.get(Long.valueOf(orgId)))) continue;
                    UmcParentOrgInfoBo umcParentOrgInfoBo = new UmcParentOrgInfoBo();
                    umcParentOrgInfoBo.setOrgId(Long.valueOf(orgId));
                    umcParentOrgInfoBo.setOrgName(orgIdToNameMap.get(Long.valueOf(orgId)));
                    parentOrgInfoBoList.add(umcParentOrgInfoBo);
                }
            }
            enterpriseOrgTreeBo.setParentOrgInfoBoList(parentOrgInfoBoList);
        }
    }

    public static void main(String[] args) {
        String originalString = "\u8fd9\u662f\u4e00\u4e2a,\u793a\u4f8b,\u5b57\u7b26\u4e32,\u6700\u540e\u4e00\u4e2a\u662f\u591a\u4f59\u7684";
        String[] parts = originalString.split(",");
        if (parts.length > 0 && !parts[parts.length - 1].isEmpty()) {
            String[] trimmedParts = new String[parts.length - 1];
            System.arraycopy(parts, 0, trimmedParts, 0, parts.length - 1);
            for (String part : trimmedParts) {
                System.out.println(part);
            }
        } else {
            System.out.println("\u6700\u540e\u4e00\u4e2a\u5143\u7d20\u662f\u7a7a\u7684");
        }
    }
}

