/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.invoiceaddress;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.model.invoiceaddress.IUmcInvoiceAddressModel;
import com.tydic.dyc.umc.model.invoiceaddress.UmcInvoiceAddressDo;
import com.tydic.dyc.umc.model.invoiceaddress.qrybo.UmcInvoiceAddressListRspBo;
import com.tydic.dyc.umc.model.invoiceaddress.qrybo.UmcInvoiceAddressQryBo;
import com.tydic.dyc.umc.service.invoiceaddress.UmcInvoiceAddressOperService;
import com.tydic.dyc.umc.service.invoiceaddress.bo.UmcInvoiceAddressOperReqBo;
import com.tydic.dyc.umc.service.invoiceaddress.bo.UmcInvoiceAddressOperRspBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.invoiceaddress.UmcInvoiceAddressOperService"})
public class UmcInvoiceAddressOperServiceImpl
implements UmcInvoiceAddressOperService {
    @Autowired
    private IUmcInvoiceAddressModel iUmcInvoiceAddressModel;

    @PostMapping(value={"operInvoiceAddress"})
    public UmcInvoiceAddressOperRspBo operInvoiceAddress(@RequestBody UmcInvoiceAddressOperReqBo reqBo) {
        this.validateParam(reqBo);
        UmcInvoiceAddressOperRspBo rspBo = UmcRu.success(UmcInvoiceAddressOperRspBo.class);
        for (Long invoiceAddId : reqBo.getInvoiceAddrIdList()) {
            UmcInvoiceAddressQryBo qryBo = new UmcInvoiceAddressQryBo();
            qryBo.setInvoiceAddrId(invoiceAddId);
            UmcInvoiceAddressDo invoiceAddressDo = this.iUmcInvoiceAddressModel.getInvoiceAddress(qryBo);
            if (null == invoiceAddressDo) {
                throw new BaseBusinessException("201004", "\u4e0d\u5b58\u5728id=" + invoiceAddId + "\u7684\u53d1\u7968\u90ae\u5bc4\u5730\u5740\u4fe1\u606f\uff01");
            }
            UmcInvoiceAddressDo invoiceAddressDo1 = new UmcInvoiceAddressDo();
            invoiceAddressDo1.setInvoiceAddrId(invoiceAddId);
            if (UmcCommConstant.InvAddrOperType.START.equals(reqBo.getOperType())) {
                invoiceAddressDo1.setAddrStatus("01");
            }
            if (UmcCommConstant.InvAddrOperType.STOP.equals(reqBo.getOperType())) {
                invoiceAddressDo1.setAddrStatus("00");
            }
            if (UmcCommConstant.InvAddrOperType.DELETE.equals(reqBo.getOperType())) {
                invoiceAddressDo1.setAddrStatus("01");
                invoiceAddressDo1.setDelFlag("1");
            }
            if (UmcCommConstant.InvAddrOperType.SET_MAIN.equals(reqBo.getOperType())) {
                List<UmcInvoiceAddressDo> invoiceAddressDoList = null != invoiceAddressDo.getAccountId() ? this.qryAddrByAccountId(invoiceAddressDo.getAccountId()) : this.qryAddrByOrgId(invoiceAddressDo.getOrgId());
                if (!CollectionUtils.isEmpty(invoiceAddressDoList)) {
                    this.cancleMainFlagAddr(invoiceAddressDoList);
                }
                invoiceAddressDo1.setMainFlag(UmcCommConstant.InvAddrMainFlag.YES);
            }
            invoiceAddressDo1.setUpdateTime(new Date());
            invoiceAddressDo1.setUpdateOperId(reqBo.getUserIdIn());
            invoiceAddressDo1.setUpdateOperName(reqBo.getCustNameIn());
            this.iUmcInvoiceAddressModel.updateInvoiceAddress(invoiceAddressDo1);
        }
        return rspBo;
    }

    private List<UmcInvoiceAddressDo> qryAddrByAccountId(Long accountId) {
        UmcInvoiceAddressQryBo qryBo = new UmcInvoiceAddressQryBo();
        qryBo.setAccountId(accountId);
        qryBo.setMainFlag(UmcCommConstant.InvAddrMainFlag.YES);
        qryBo.setDelFlag("0");
        UmcInvoiceAddressListRspBo umcInvoiceAddressListRspBo = this.iUmcInvoiceAddressModel.getInvoiceAddressList(qryBo);
        return umcInvoiceAddressListRspBo.getRows();
    }

    private List<UmcInvoiceAddressDo> qryAddrByOrgId(Long orgId) {
        UmcInvoiceAddressQryBo qryBo = new UmcInvoiceAddressQryBo();
        qryBo.setCompanyId(orgId);
        qryBo.setMainFlag(UmcCommConstant.InvAddrMainFlag.YES);
        qryBo.setDelFlag("0");
        UmcInvoiceAddressListRspBo umcInvoiceAddressListRspBo = this.iUmcInvoiceAddressModel.getInvoiceAddressList(qryBo);
        return umcInvoiceAddressListRspBo.getRows();
    }

    private void cancleMainFlagAddr(List<UmcInvoiceAddressDo> invoiceAddressDoList) {
        UmcInvoiceAddressDo invoiceAddressDo = new UmcInvoiceAddressDo();
        List collect = invoiceAddressDoList.stream().map(UmcInvoiceAddressDo::getInvoiceAddrId).collect(Collectors.toList());
        for (Long id : collect) {
            invoiceAddressDo.setInvoiceAddrId(id);
            invoiceAddressDo.setMainFlag(UmcCommConstant.InvAddrMainFlag.NO);
            this.iUmcInvoiceAddressModel.updateInvoiceAddress(invoiceAddressDo);
        }
    }

    private void validateParam(UmcInvoiceAddressOperReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("201001", "\u4f1a\u5458\u4e2d\u5fc3\u53d1\u7968\u90ae\u5bc4\u5730\u5740\u542f\u505c/\u5220\u9664\u4e1a\u52a1\u670d\u52a1API\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBo.getOperType()) {
            throw new BaseBusinessException("201001", "\u4f1a\u5458\u4e2d\u5fc3\u53d1\u7968\u90ae\u5bc4\u5730\u5740\u542f\u505c/\u5220\u9664\u4e1a\u52a1\u670d\u52a1API\u5165\u53c2\u3010operType\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!(UmcCommConstant.InvAddrOperType.START.equals(reqBo.getOperType()) || UmcCommConstant.InvAddrOperType.STOP.equals(reqBo.getOperType()) || UmcCommConstant.InvAddrOperType.DELETE.equals(reqBo.getOperType()) || UmcCommConstant.InvAddrOperType.SET_MAIN.equals(reqBo.getOperType()))) {
            throw new BaseBusinessException("201001", "\u4f1a\u5458\u4e2d\u5fc3\u53d1\u7968\u90ae\u5bc4\u5730\u5740\u542f\u505c/\u5220\u9664\u4e1a\u52a1\u670d\u52a1API\u5165\u53c2\u3010operType\u3011\u975e\u6cd5\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getInvoiceAddrIdList())) {
            throw new BaseBusinessException("201001", "\u4f1a\u5458\u4e2d\u5fc3\u53d1\u7968\u90ae\u5bc4\u5730\u5740\u542f\u505c/\u5220\u9664\u4e1a\u52a1\u670d\u52a1API\u5165\u53c2\u3010ids\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

