/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.user;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcEnumConstant;
import com.tydic.dyc.umc.constants.UmcStatusConstant;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.UmcEnterpriseInfoDo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseContactQryBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseInfoQryBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcOrgInfoQryBo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseContact;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgInfo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgTagRel;
import com.tydic.dyc.umc.model.user.IUmcUserInfoModel;
import com.tydic.dyc.umc.model.user.UmcUserInfoDo;
import com.tydic.dyc.umc.model.user.qrybo.UmcCustInfoQryBo;
import com.tydic.dyc.umc.model.user.qrybo.UmcUserInfoQryBo;
import com.tydic.dyc.umc.model.user.sub.UmcBatchAddUser;
import com.tydic.dyc.umc.model.user.sub.UmcCustInfo;
import com.tydic.dyc.umc.model.user.sub.UmcCustInfoSyncTemp;
import com.tydic.dyc.umc.model.user.sub.UmcUserExtMap;
import com.tydic.dyc.umc.model.user.sub.UmcUserRoleRel;
import com.tydic.dyc.umc.model.user.sub.UmcUserTagRel;
import com.tydic.dyc.umc.service.user.UmcSyncUserInfoService;
import com.tydic.dyc.umc.service.user.bo.UmcCustInfoBo;
import com.tydic.dyc.umc.service.user.bo.UmcCustInfoSynBo;
import com.tydic.dyc.umc.service.user.bo.UmcCustPartJobTempBo;
import com.tydic.dyc.umc.service.user.bo.UmcCustPartJobTempDealReqBo;
import com.tydic.dyc.umc.service.user.bo.UmcCustPartJobTempDealRspBo;
import com.tydic.dyc.umc.service.user.bo.UmcRoleBo;
import com.tydic.dyc.umc.service.user.bo.UmcSyncUserInfoReqBo;
import com.tydic.dyc.umc.service.user.bo.UmcSyncUserInfoRspBo;
import com.tydic.dyc.umc.service.user.bo.UmcUserInfoBo;
import com.tydic.dyc.umc.service.user.bo.UmcUserRoleRelBo;
import com.tydic.dyc.umc.service.user.bo.UmcUserSyncRoleBo;
import com.tydic.dyc.umc.service.user.bo.UmcUserTagRelBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.user.UmcSyncUserInfoService"})
public class UmcSyncUserInfoServiceImpl
implements UmcSyncUserInfoService {
    private static final Logger log = LoggerFactory.getLogger(UmcSyncUserInfoServiceImpl.class);
    @Autowired
    private IUmcUserInfoModel iUmcUserInfoModel;
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;
    @Value(value="${syncCust.defaultRoleId:5}")
    private Long DEFAULT_ROLE_ID;
    @Value(value="${syncCust.supRoleId:[1042843911619371008]}")
    private String SUP_ROLE_ID;
    private static final Long DEFAULT_USER_ID = 1L;
    private static final String DEFAULT_USER_NAME = "\u7cfb\u7edf\u7ba1\u7406\u5458";
    private static final String AUTH_TYPE = "auth:default:manage";
    @Value(value="${syncCust.tenantId:10000}")
    private Long tenantId;
    @Value(value="${syncCust.isCreateDefaultRole:false}")
    private Boolean isCreateDefaultRole;
    @Value(value="${syncCust.defaultHeadUrl:}")
    private String defaultHeadUrl;
    @Value(value="${eComCreditNoList:9131010405769500XK}")
    private String[] eComCreditNoList;

    @PostMapping(value={"syncUserInfo"})
    public UmcSyncUserInfoRspBo syncUserInfo(@RequestBody UmcSyncUserInfoReqBo reqBo) {
        UmcSyncUserInfoRspBo umcSyncUserInfoRspBo = UmcRu.success(UmcSyncUserInfoRspBo.class);
        this.validate(reqBo);
        ArrayList<String> extCustIdList = new ArrayList<String>();
        ArrayList<String> orgCodeList = new ArrayList<String>();
        reqBo.getUmcCustInfoSynBos().forEach(umcCustInfoSynBo -> {
            extCustIdList.add(umcCustInfoSynBo.getExtCustId());
            if (StringUtils.isNotBlank((CharSequence)umcCustInfoSynBo.getOrgCode())) {
                orgCodeList.add(umcCustInfoSynBo.getOrgCode());
            }
        });
        Map<Object, Object> orgInfoMap = new HashMap();
        UmcOrgInfoQryBo umcOrgInfoQryBo = new UmcOrgInfoQryBo();
        umcOrgInfoQryBo.setOrgCodes(orgCodeList);
        List umcOrgInfoList = this.iUmcEnterpriseInfoModel.getOrgInfoList(umcOrgInfoQryBo).getRows();
        if (!CollectionUtils.isEmpty((Collection)umcOrgInfoList)) {
            orgInfoMap = umcOrgInfoList.stream().collect(Collectors.toMap(UmcOrgInfo::getOrgCode, o -> o));
        }
        Map<Object, Object> enterpriseInfoMap = new HashMap();
        UmcEnterpriseInfoQryBo umcEnterpriseInfoQryBo = new UmcEnterpriseInfoQryBo();
        umcEnterpriseInfoQryBo.setOrgIds(umcOrgInfoList.stream().map(UmcOrgInfo::getOrgId).collect(Collectors.toList()));
        List umcEnterpriseInfoDoList = this.iUmcEnterpriseInfoModel.getEnterpriseInfoList(umcEnterpriseInfoQryBo).getRows();
        if (CollectionUtils.isEmpty((Collection)umcEnterpriseInfoDoList)) {
            this.updateUserTemp(reqBo.getUmcCustInfoSynBos());
            return UmcRu.success(UmcSyncUserInfoRspBo.class);
        }
        if (!CollectionUtils.isEmpty((Collection)umcEnterpriseInfoDoList)) {
            enterpriseInfoMap = umcEnterpriseInfoDoList.stream().collect(Collectors.toMap(UmcEnterpriseInfoDo::getOrgId, o -> o));
        }
        Map<Object, Object> updateExtCustIdCustInfoMap = new HashMap();
        UmcCustInfoQryBo umcCustInfoQryBo = new UmcCustInfoQryBo();
        umcCustInfoQryBo.setExtCustIdList(extCustIdList);
        List umcCustInfoList = this.iUmcUserInfoModel.getCustInfoList(umcCustInfoQryBo).getRows();
        if (!CollectionUtils.isEmpty((Collection)umcCustInfoList)) {
            updateExtCustIdCustInfoMap = umcCustInfoList.stream().collect(Collectors.toMap(UmcCustInfo::getExtCustId, o -> o, (o1, o2) -> o1));
        }
        Map<Object, Object> umcCustAndDelInfoMap = new HashMap();
        UmcCustInfoQryBo umcCustAndDelQryBo = new UmcCustInfoQryBo();
        umcCustAndDelQryBo.setExtCustIdList(extCustIdList);
        List umcCustAndDelInfoList = this.iUmcUserInfoModel.getCustAndDelInfoList(umcCustAndDelQryBo).getRows();
        if (!CollectionUtils.isEmpty((Collection)umcCustAndDelInfoList)) {
            umcCustAndDelInfoMap = umcCustAndDelInfoList.stream().collect(Collectors.toMap(UmcCustInfo::getExtCustId, o -> o, (o1, o2) -> o1));
        }
        Map updateUserInfoMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)umcCustInfoList)) {
            UmcUserInfoQryBo umcUserInfoQryBo = new UmcUserInfoQryBo();
            umcUserInfoQryBo.setCustIdList(umcCustInfoList.stream().map(UmcCustInfo::getCustId).collect(Collectors.toList()));
            List umcUserInfoQryBoList = this.iUmcUserInfoModel.getUserInfoWithoutCustList(umcUserInfoQryBo).getRows();
            if (!CollectionUtils.isEmpty((Collection)umcUserInfoQryBoList)) {
                updateUserInfoMap = umcUserInfoQryBoList.stream().collect(Collectors.groupingByConcurrent(UmcUserInfoQryBo::getCustId));
            }
        }
        HashMap<String, UmcRoleBo> roleMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)reqBo.getUmcRoleBos())) {
            roleMap = reqBo.getUmcRoleBos().stream().collect(Collectors.toMap(UmcRoleBo::getAuthIdentity, o -> o));
        }
        log.debug("\u8be5\u6279\u6b21\u7528\u6237\u89d2\u8272\u4fe1\u606fmap:{}", (Object)JSON.toJSONString(roleMap));
        ArrayList<UmcCustInfo> insertCustInfoList = new ArrayList<UmcCustInfo>();
        ArrayList<UmcCustInfo> updateCustInfoList = new ArrayList<UmcCustInfo>();
        ArrayList<UmcUserInfoDo> deleteUserList = new ArrayList<UmcUserInfoDo>();
        ArrayList<UmcUserInfoDo> insertUserInfoList = new ArrayList<UmcUserInfoDo>();
        ArrayList<UmcUserInfoDo> updateUserInfoList = new ArrayList<UmcUserInfoDo>();
        ArrayList<UmcUserExtMap> insertUserExtMapList = new ArrayList<UmcUserExtMap>();
        ArrayList<UmcUserTagRel> insertUserTagRelList = new ArrayList<UmcUserTagRel>();
        ArrayList<UmcUserRoleRel> insertUserRoleRelList = new ArrayList<UmcUserRoleRel>();
        ArrayList<UmcCustInfoSynBo> successCustInfoSynBos = new ArrayList<UmcCustInfoSynBo>();
        ArrayList<UmcCustInfoSynBo> notDealData = new ArrayList<UmcCustInfoSynBo>();
        ArrayList<UmcUserInfoDo> toCreateContract = new ArrayList<UmcUserInfoDo>();
        ConcurrentMap<String, UmcUserInfoBo> extCustOrgIdMap = this.iUmcUserInfoModel.getExtCustOrgIdMap(extCustIdList);
        UmcCustPartJobTempDealReqBo partJobTempDealReqBo = new UmcCustPartJobTempDealReqBo();
        ArrayList<UmcCustPartJobTempBo> umcCustPartJobTempBoList = new ArrayList<UmcCustPartJobTempBo>();
        for (UmcCustInfoSynBo umcCustInfoSynBo2 : reqBo.getUmcCustInfoSynBos()) {
            if ("1".equals(umcCustInfoSynBo2.getDelFlag())) {
                List umcUserInfoQryBos;
                UmcCustInfo custInfo = (UmcCustInfo)updateExtCustIdCustInfoMap.get(umcCustInfoSynBo2.getExtCustId());
                if (null == custInfo || CollectionUtils.isEmpty((Collection)(umcUserInfoQryBos = (List)updateUserInfoMap.get(custInfo.getCustId())))) continue;
                deleteUserList.addAll(UmcRu.jsl(umcUserInfoQryBos, UmcUserInfoDo.class));
                successCustInfoSynBos.add(umcCustInfoSynBo2);
                continue;
            }
            UmcCustInfo umcCustInfo = (UmcCustInfo)updateExtCustIdCustInfoMap.get(umcCustInfoSynBo2.getExtCustId());
            if (null != umcCustInfo) {
                if (!extCustOrgIdMap.containsKey(umcCustInfoSynBo2.getExtCustId() + "-" + umcCustInfoSynBo2.getOrgCode())) {
                    UmcCustPartJobTempBo umcCustPartJobTempBo = new UmcCustPartJobTempBo();
                    umcCustPartJobTempBo.setId(umcCustInfoSynBo2.getId());
                    umcCustPartJobTempBo.setExtCustId(umcCustInfoSynBo2.getExtCustId());
                    umcCustPartJobTempBo.setExtOrgId(umcCustInfoSynBo2.getOrgCode());
                    umcCustPartJobTempBo.setSyncTime(umcCustInfoSynBo2.getSyncTime());
                    umcCustPartJobTempBoList.add(umcCustPartJobTempBo);
                    continue;
                }
                this.setUpdateCustInfo(umcCustInfo, umcCustInfoSynBo2);
                updateCustInfoList.add(umcCustInfo);
                UmcUserInfoBo umcUserInfoBo = (UmcUserInfoBo)extCustOrgIdMap.get(umcCustInfoSynBo2.getExtCustId() + "-" + umcCustInfoSynBo2.getOrgCode());
                if (null == umcUserInfoBo) {
                    notDealData.add(umcCustInfoSynBo2);
                    continue;
                }
                UmcUserInfoQryBo umcUserInfoQryBo = new UmcUserInfoQryBo();
                BeanUtils.copyProperties((Object)umcUserInfoBo, (Object)((Object)umcUserInfoQryBo));
                UmcUserInfoDo umcUserInfoDo = this.setUpdateUserInfo(umcUserInfoQryBo, umcCustInfoSynBo2);
                updateUserInfoList.add(umcUserInfoDo);
                this.setExtMap(insertUserExtMapList, umcCustInfoSynBo2, umcUserInfoDo);
            } else {
                if (ObjectUtil.isEmpty((Object)umcCustInfoSynBo2.getOrgCode())) {
                    notDealData.add(umcCustInfoSynBo2);
                    continue;
                }
                UmcOrgInfo umcOrgInfo = (UmcOrgInfo)((Object)orgInfoMap.get(umcCustInfoSynBo2.getOrgCode()));
                if (null == umcOrgInfo) {
                    notDealData.add(umcCustInfoSynBo2);
                    continue;
                }
                UmcEnterpriseInfoDo umcEnterpriseInfoDo = (UmcEnterpriseInfoDo)((Object)enterpriseInfoMap.get(umcOrgInfo.getOrgId()));
                if (null == umcEnterpriseInfoDo) {
                    notDealData.add(umcCustInfoSynBo2);
                    continue;
                }
                log.debug("\u65b0\u589e\u5ba2\u6237\uff1a{}", (Object)JSON.toJSONString((Object)umcCustInfoSynBo2));
                UmcCustInfo umcCustAndDeInfo = (UmcCustInfo)umcCustAndDelInfoMap.get(umcCustInfoSynBo2.getExtCustId());
                umcCustInfo = this.setInsertCustInfo(umcCustInfoSynBo2, umcCustAndDeInfo);
                insertCustInfoList.add(umcCustInfo);
                UmcUserInfoDo umcUserInfoDo = this.setInsertUserInfo(umcCustInfoSynBo2, umcCustInfo, umcOrgInfo, umcEnterpriseInfoDo);
                insertUserInfoList.add(umcUserInfoDo);
                this.setExtMap(insertUserExtMapList, umcCustInfoSynBo2, umcUserInfoDo);
                this.setUserTag(insertUserTagRelList, umcCustInfoSynBo2, umcOrgInfo, umcUserInfoDo);
                this.setUserRoleRel(insertUserRoleRelList, umcCustInfoSynBo2, umcUserInfoDo, roleMap, enterpriseInfoMap);
                if (null != umcCustInfoSynBo2.getIsProfess() && umcCustInfoSynBo2.getIsProfess().contains("2") && !"1".equals(umcCustInfoSynBo2.getDelFlag())) {
                    toCreateContract.add(umcUserInfoDo);
                }
            }
            successCustInfoSynBos.add(umcCustInfoSynBo2);
        }
        this.delUser(deleteUserList);
        this.addUser(insertCustInfoList, insertUserInfoList, insertUserExtMapList, insertUserTagRelList, insertUserRoleRelList);
        this.addEnterPriseContact(toCreateContract, insertCustInfoList);
        this.updateUser(updateCustInfoList, updateUserInfoList, insertUserExtMapList);
        partJobTempDealReqBo.setUmcCustPartJobTempBoList(umcCustPartJobTempBoList);
        log.info("\u65b0\u589e\u517c\u804c:{}", (Object)JSON.toJSONString((Object)partJobTempDealReqBo));
        UmcCustPartJobTempDealRspBo umcCustPartJobTempDealRspBo = this.iUmcUserInfoModel.dealCustPartJobYc(partJobTempDealReqBo);
        if (null != umcCustPartJobTempDealRspBo && null != umcCustPartJobTempDealRspBo.getAddCustPartJobBo()) {
            if (CollectionUtil.isNotEmpty((Collection)umcCustPartJobTempDealRspBo.getAddCustPartJobBo().getNotDealData())) {
                notDealData.addAll(umcCustPartJobTempDealRspBo.getAddCustPartJobBo().getNotDealData());
            }
            if (CollectionUtil.isNotEmpty((Collection)umcCustPartJobTempDealRspBo.getAddCustPartJobBo().getSuccessCustInfoSynBos())) {
                successCustInfoSynBos.addAll(umcCustPartJobTempDealRspBo.getAddCustPartJobBo().getSuccessCustInfoSynBos());
            }
            if (CollectionUtil.isNotEmpty((Collection)umcCustPartJobTempDealRspBo.getAddCustPartJobBo().getSysPartJobUserInfoBoList())) {
                umcCustPartJobTempDealRspBo.getAddCustPartJobBo().getSysPartJobUserInfoBoList().forEach(sysPartJobUserInfoBo -> {
                    UmcUserInfoDo umcUserInfoDo = (UmcUserInfoDo)BeanUtil.copyProperties((Object)sysPartJobUserInfoBo, UmcUserInfoDo.class);
                    umcUserInfoDo.setStopStatus("01");
                    insertUserInfoList.add(umcUserInfoDo);
                });
            }
            if (CollectionUtil.isNotEmpty((Collection)umcCustPartJobTempDealRspBo.getAddCustPartJobBo().getSysPartJobUserTagRelBoList())) {
                umcCustPartJobTempDealRspBo.getAddCustPartJobBo().getSysPartJobUserTagRelBoList().forEach(e -> {
                    UmcUserTagRel userTagRel = (UmcUserTagRel)BeanUtil.copyProperties((Object)e, UmcUserTagRel.class);
                    insertUserTagRelList.add(userTagRel);
                });
            }
            if (CollectionUtil.isNotEmpty((Collection)umcCustPartJobTempDealRspBo.getAddCustPartJobBo().getSysPartJobUserRoleBoList())) {
                umcCustPartJobTempDealRspBo.getAddCustPartJobBo().getSysPartJobUserRoleBoList().forEach(e -> {
                    UmcUserRoleRel userRoleRel = (UmcUserRoleRel)BeanUtil.copyProperties((Object)e, UmcUserRoleRel.class);
                    insertUserRoleRelList.add(userRoleRel);
                });
            }
        }
        this.updateUserTemp(notDealData);
        umcSyncUserInfoRspBo.setSuccessSynBos(successCustInfoSynBos);
        umcSyncUserInfoRspBo.setDeleteUserInfo(UmcRu.jsl(deleteUserList, UmcUserInfoBo.class));
        umcSyncUserInfoRspBo.setAddUserInfoBos(UmcRu.jsl(insertUserInfoList, UmcUserInfoBo.class));
        umcSyncUserInfoRspBo.setUpdateUserInfoBos(UmcRu.jsl(updateUserInfoList, UmcUserInfoBo.class));
        umcSyncUserInfoRspBo.setAddCustInfoBos(UmcRu.jsl(insertCustInfoList, UmcCustInfoBo.class));
        umcSyncUserInfoRspBo.setUpdateCustInfoBos(UmcRu.jsl(updateCustInfoList, UmcCustInfoBo.class));
        umcSyncUserInfoRspBo.setAddAuthDistributeBos(UmcRu.jsl(insertUserRoleRelList, UmcUserRoleRelBo.class));
        umcSyncUserInfoRspBo.setAddUserTagRelBos(UmcRu.jsl(insertUserTagRelList, UmcUserTagRelBo.class));
        return umcSyncUserInfoRspBo;
    }

    private void addEnterPriseContact(List<UmcUserInfoDo> toCreateContract, List<UmcCustInfo> insertCustInfoList) {
        Map<Long, UmcUserInfoDo> umcUserInfoDoMap = toCreateContract.stream().collect(Collectors.toMap(UmcUserInfoDo::getOrgId, o -> o, (old, cur) -> old));
        Map<Long, UmcCustInfo> umcCustInfoMap = insertCustInfoList.stream().collect(Collectors.toMap(UmcCustInfo::getCustId, o -> o));
        if (!CollectionUtils.isEmpty(umcUserInfoDoMap)) {
            UmcEnterpriseContactQryBo umcEnterpriseContactQryBo = new UmcEnterpriseContactQryBo();
            umcEnterpriseContactQryBo.setOrgIds(new ArrayList<Long>(umcUserInfoDoMap.keySet()));
            umcEnterpriseContactQryBo.setDelFlag(Convert.toStr((Object)UmcEnumConstant.DelFlag.NOT_DELETE.getCode()));
            UmcEnterpriseInfoDo enterpriseContact = this.iUmcEnterpriseInfoModel.getEnterpriseContactList(umcEnterpriseContactQryBo);
            List<UmcEnterpriseContact> enterpriseContactList = enterpriseContact.getEnterpriseContactList();
            if (!CollectionUtils.isEmpty(enterpriseContactList)) {
                for (UmcEnterpriseContact umcEnterpriseContact : enterpriseContactList) {
                    if (null == umcUserInfoDoMap.get(umcEnterpriseContact.getOrgId())) continue;
                    UmcEnterpriseContact update = new UmcEnterpriseContact();
                    update.setContactId(umcEnterpriseContact.getContactId());
                    update.setCustId(umcUserInfoDoMap.get(umcEnterpriseContact.getOrgId()).getCustId());
                    update.setContactName(umcCustInfoMap.get(update.getCustId()).getCustName());
                    update.setPhoneNumber(umcCustInfoMap.get(update.getCustId()).getRegMobile());
                    update.setEmail(umcCustInfoMap.get(update.getCustId()).getRegEmail());
                    this.iUmcEnterpriseInfoModel.updateEnterpriseContact(update);
                }
            }
        }
    }

    private void updateUserTemp(List<UmcCustInfoSynBo> notDealData) {
        if (!CollectionUtils.isEmpty(notDealData)) {
            UmcUserInfoDo umcUserInfoDo = new UmcUserInfoDo();
            UmcCustInfoSyncTemp umcCustInfoSyncTemp = new UmcCustInfoSyncTemp();
            umcCustInfoSyncTemp.setDealResult(UmcStatusConstant.SyncDealResult.NEXT_PROCESSING);
            umcCustInfoSyncTemp.setIds(notDealData.stream().map(UmcCustInfoSynBo::getId).collect(Collectors.toList()));
            umcUserInfoDo.setUmcCustInfoSyncTemp(umcCustInfoSyncTemp);
            this.iUmcUserInfoModel.updateCustSyncInfoTempState(umcUserInfoDo);
        }
    }

    private void updateUser(List<UmcCustInfo> updateCustInfoList, List<UmcUserInfoDo> updateUserInfoList, List<UmcUserExtMap> insertUserExtMapList) {
        if (!CollectionUtils.isEmpty(updateCustInfoList)) {
            for (UmcCustInfo umcCustInfo : updateCustInfoList) {
                this.iUmcUserInfoModel.updateCustInfo(umcCustInfo);
            }
        }
        if (!CollectionUtils.isEmpty(updateUserInfoList)) {
            for (UmcUserInfoDo umcUserInfoDo : updateUserInfoList) {
                this.iUmcUserInfoModel.updateUserInfo(umcUserInfoDo);
            }
        }
        if (!CollectionUtils.isEmpty(insertUserExtMapList)) {
            this.iUmcUserInfoModel.insertUserExtMap(insertUserExtMapList);
        }
    }

    private void addUser(List<UmcCustInfo> insertCustInfoList, List<UmcUserInfoDo> insertUserInfoList, List<UmcUserExtMap> insertUserExtMapList, List<UmcUserTagRel> insertUserTagRelList, List<UmcUserRoleRel> insertUserRoleRelList) {
        if (!CollectionUtils.isEmpty(insertCustInfoList)) {
            UmcBatchAddUser umcBatchAddUser = new UmcBatchAddUser();
            umcBatchAddUser.setCustInfoList(insertCustInfoList);
            umcBatchAddUser.setUserInfoDoList(insertUserInfoList);
            umcBatchAddUser.setUserTagRelList(insertUserTagRelList);
            umcBatchAddUser.setUserRoleRelList(insertUserRoleRelList);
            umcBatchAddUser.setUserExtMapList(insertUserExtMapList);
            this.iUmcUserInfoModel.addUser(umcBatchAddUser);
        }
    }

    private void delUser(List<UmcUserInfoDo> deleteUserList) {
        for (UmcUserInfoDo umcUserInfoDo : deleteUserList) {
            if (null == umcUserInfoDo.getUserId()) continue;
            UmcUserInfoDo delUser = new UmcUserInfoDo();
            delUser.setUserId(umcUserInfoDo.getUserId());
            delUser.setDelFlag("1");
            this.iUmcUserInfoModel.updateUserInfo(delUser);
            UmcCustInfo umcCustInfo = new UmcCustInfo();
            umcCustInfo.setCustId(umcUserInfoDo.getCustId());
            umcCustInfo.setDelFlag("1");
            this.iUmcUserInfoModel.updateCustInfo(umcCustInfo);
            UmcUserTagRel umcUserTagRel = new UmcUserTagRel();
            umcUserTagRel.setUserId(umcUserInfoDo.getUserId());
            umcUserTagRel.setDelFlag("1");
            this.iUmcUserInfoModel.updateUserTagRel(umcUserTagRel);
            UmcUserRoleRel umcUserRoleRel = new UmcUserRoleRel();
            umcUserRoleRel.setUserId(umcUserInfoDo.getUserId());
            umcUserRoleRel.setDelFlag("1");
            this.iUmcUserInfoModel.delUserRoleByUserId(umcUserRoleRel);
        }
    }

    private void setUserRoleRel(List<UmcUserRoleRel> umcUserRoleRelList, UmcCustInfoSynBo umcCustInfoSynBo, UmcUserInfoDo umcUserInfoDo, Map<String, UmcRoleBo> roleMap, Map<Long, UmcEnterpriseInfoDo> enterpriseInfoMap) {
        if (this.isCreateDefaultRole.booleanValue()) {
            UmcUserRoleRel defaultUserRole = new UmcUserRoleRel();
            defaultUserRole.setUserId(umcUserInfoDo.getUserId());
            defaultUserRole.setRelId(IdUtil.nextId());
            defaultUserRole.setDelFlag("0");
            defaultUserRole.setRoleId(this.DEFAULT_ROLE_ID);
            defaultUserRole.setTagId("1");
            defaultUserRole.setTenantId(null == umcCustInfoSynBo.getTenantId() ? this.tenantId : umcCustInfoSynBo.getTenantId());
            if (null == umcCustInfoSynBo.getCreateOperId()) {
                defaultUserRole.setCreateOperId(DEFAULT_USER_ID);
            } else {
                defaultUserRole.setCreateOperId(umcCustInfoSynBo.getCreateOperId());
            }
            if (StringUtils.isBlank((CharSequence)umcCustInfoSynBo.getCreateOperName())) {
                defaultUserRole.setCreateOperName(DEFAULT_USER_NAME);
            } else {
                defaultUserRole.setCreateOperName(umcCustInfoSynBo.getCreateOperName());
            }
            if (null == umcCustInfoSynBo.getCreateTime()) {
                defaultUserRole.setCreateTime(new Date());
            } else {
                defaultUserRole.setCreateTime(umcCustInfoSynBo.getCreateTime());
            }
            umcUserRoleRelList.add(defaultUserRole);
        }
        if (!StringUtils.isBlank((CharSequence)umcCustInfoSynBo.getRoleJson())) {
            List roles = JSON.parseArray((String)umcCustInfoSynBo.getRoleJson(), UmcUserSyncRoleBo.class);
            log.debug("\u7528\u6237\u9884\u7f6e\u89d2\u8272\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)roles));
            if ("2".equals(umcCustInfoSynBo.getCustType())) {
                log.debug("apollo\u7535\u5546\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801:{}", (Object)JSON.toJSONString((Object)this.eComCreditNoList));
                log.debug("\u6570\u636e\u5e93\u7535\u5546\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801:{}", (Object)JSON.toJSONString((Object)enterpriseInfoMap.get(umcUserInfoDo.getOrgId()).getCreditNo()));
                if (StringUtils.isNotEmpty((CharSequence)enterpriseInfoMap.get(umcUserInfoDo.getOrgId()).getCreditNo()) && JSON.toJSONString((Object)this.eComCreditNoList).contains(enterpriseInfoMap.get(umcUserInfoDo.getOrgId()).getCreditNo())) {
                    roles.removeIf(roleBo -> "business:null:gongyingshangyewuyuan".equals(roleBo.getRoleCode()));
                } else {
                    roles.removeIf(roleBo -> "business:null:dianshanggongyingshang".equals(roleBo.getRoleCode()));
                }
            }
            if (!CollectionUtils.isEmpty((Collection)roles)) {
                log.debug("\u7528\u6237\u771f\u5b9e\u89d2\u8272\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)roles));
                roles.forEach(roleBo -> {
                    UmcRoleBo umcRoleBo = (UmcRoleBo)roleMap.get(roleBo.getRoleCode());
                    if (null != umcRoleBo) {
                        UmcUserRoleRel umcUserRoleRel = new UmcUserRoleRel();
                        umcUserRoleRel.setUserId(umcUserInfoDo.getUserId());
                        umcUserRoleRel.setRelId(IdUtil.nextId());
                        umcUserRoleRel.setDelFlag("0");
                        umcUserRoleRel.setRoleId(umcRoleBo.getRoleId());
                        umcUserRoleRel.setTagId(umcRoleBo.getTagId());
                        umcUserRoleRel.setTenantId(null == umcCustInfoSynBo.getTenantId() ? this.tenantId : umcCustInfoSynBo.getTenantId());
                        if (null == umcCustInfoSynBo.getCreateOperId()) {
                            umcUserRoleRel.setCreateOperId(DEFAULT_USER_ID);
                        } else {
                            umcUserRoleRel.setCreateOperId(umcCustInfoSynBo.getCreateOperId());
                        }
                        if (StringUtils.isBlank((CharSequence)umcCustInfoSynBo.getCreateOperName())) {
                            umcUserRoleRel.setCreateOperName(DEFAULT_USER_NAME);
                        } else {
                            umcUserRoleRel.setCreateOperName(umcCustInfoSynBo.getCreateOperName());
                        }
                        if (null == umcCustInfoSynBo.getCreateTime()) {
                            umcUserRoleRel.setCreateTime(new Date());
                        } else {
                            umcUserRoleRel.setCreateTime(umcCustInfoSynBo.getCreateTime());
                        }
                        umcUserRoleRelList.add(umcUserRoleRel);
                    }
                });
            }
        }
    }

    private void setExtMap(List<UmcUserExtMap> insertUserExtMapList, UmcCustInfoSynBo umcCustInfoSynBo, UmcUserInfoDo umcUserInfoDo) {
        if (!StringUtils.isBlank((CharSequence)umcCustInfoSynBo.getExtField())) {
            JSONArray jsonArray = JSONObject.parseArray((String)umcCustInfoSynBo.getExtField());
            ArrayList<UmcUserExtMap> umcUserExtMapList = new ArrayList<UmcUserExtMap>();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                UmcUserExtMap umcUserExtMap = new UmcUserExtMap();
                umcUserExtMap.setExtId(IdUtil.nextId());
                umcUserExtMap.setUserId(umcUserInfoDo.getUserId());
                umcUserExtMap.setDelFlag("0");
                umcUserExtMap.setFieldCode(jsonObject.getString("fieldCode"));
                umcUserExtMap.setFieldName(jsonObject.getString("fieldName"));
                umcUserExtMap.setFieldValue(jsonObject.getString("fieldValue"));
                umcUserExtMap.setTenantId(null == umcCustInfoSynBo.getTenantId() ? this.tenantId : umcCustInfoSynBo.getTenantId());
                if (null == umcCustInfoSynBo.getCreateOperId()) {
                    umcUserExtMap.setCreateOperId(DEFAULT_USER_ID);
                } else {
                    umcUserExtMap.setCreateOperId(umcCustInfoSynBo.getCreateOperId());
                }
                if (StringUtils.isBlank((CharSequence)umcCustInfoSynBo.getCreateOperName())) {
                    umcUserExtMap.setCreateOperName(DEFAULT_USER_NAME);
                } else {
                    umcUserExtMap.setCreateOperName(umcCustInfoSynBo.getCreateOperName());
                }
                if (null == umcCustInfoSynBo.getCreateTime()) {
                    umcUserExtMap.setCreateTime(new Date());
                } else {
                    umcUserExtMap.setCreateTime(umcCustInfoSynBo.getCreateTime());
                }
                umcUserExtMapList.add(umcUserExtMap);
            }
            insertUserExtMapList.addAll(umcUserExtMapList);
        }
    }

    private void setUserTag(List<UmcUserTagRel> insertUserTagRelList, UmcCustInfoSynBo umcCustInfoSynBo, UmcOrgInfo umcOrgInfo, UmcUserInfoDo umcUserInfoDo) {
        List<UmcOrgTagRel> orgTagRelList = umcOrgInfo.getOrgTagRelList();
        if (!CollectionUtils.isEmpty(orgTagRelList)) {
            ArrayList umcUserTagRelList = new ArrayList();
            orgTagRelList.forEach(umcOrgTagRel -> {
                UmcUserTagRel umcUserTagRel = new UmcUserTagRel();
                umcUserTagRel.setTagId(umcOrgTagRel.getTagId());
                umcUserTagRel.setUserId(umcUserInfoDo.getUserId());
                umcUserTagRel.setDelFlag("0");
                umcUserTagRel.setRelId(IdUtil.nextId());
                umcUserTagRel.setTenantId(umcUserInfoDo.getTenantId());
                umcUserTagRel.setIsDefalt("0");
                if (null == umcCustInfoSynBo.getCreateOperId()) {
                    umcUserTagRel.setCreateOperId(DEFAULT_USER_ID);
                } else {
                    umcUserTagRel.setCreateOperId(umcCustInfoSynBo.getCreateOperId());
                }
                if (StringUtils.isBlank((CharSequence)umcCustInfoSynBo.getCreateOperName())) {
                    umcUserTagRel.setCreateOperName(DEFAULT_USER_NAME);
                } else {
                    umcUserTagRel.setCreateOperName(umcCustInfoSynBo.getCreateOperName());
                }
                if (null == umcCustInfoSynBo.getCreateTime()) {
                    umcUserTagRel.setCreateTime(new Date());
                } else {
                    umcUserTagRel.setCreateTime(umcCustInfoSynBo.getCreateTime());
                }
                umcUserTagRelList.add(umcUserTagRel);
            });
            boolean tag2Exists = false;
            for (UmcUserTagRel umcUserTagRel : umcUserTagRelList) {
                if (!"2".equals(umcUserTagRel.getTagId())) continue;
                umcUserTagRel.setIsDefalt("1");
                tag2Exists = true;
                break;
            }
            if (!tag2Exists && !umcUserTagRelList.isEmpty()) {
                ((UmcUserTagRel)umcUserTagRelList.get(0)).setIsDefalt("1");
            }
            insertUserTagRelList.addAll(umcUserTagRelList);
        }
    }

    private UmcUserInfoDo setUpdateUserInfo(UmcUserInfoQryBo userInfoQryBo, UmcCustInfoSynBo umcCustInfoSynBo) {
        UmcUserInfoDo umcUserInfoDo = UmcRu.js((Object)userInfoQryBo, UmcUserInfoDo.class);
        umcUserInfoDo.setStopStatus(umcCustInfoSynBo.getStopStatus());
        if (null == umcCustInfoSynBo.getUpdateOperId()) {
            umcUserInfoDo.setUpdateOperId(DEFAULT_USER_ID);
        } else {
            umcUserInfoDo.setUpdateOperId(umcCustInfoSynBo.getUpdateOperId());
        }
        if (StringUtils.isBlank((CharSequence)umcCustInfoSynBo.getUpdateOperName())) {
            umcUserInfoDo.setUpdateOperName(DEFAULT_USER_NAME);
        } else {
            umcUserInfoDo.setUpdateOperName(umcCustInfoSynBo.getUpdateOperName());
        }
        if (null == umcCustInfoSynBo.getUpdateTime()) {
            umcUserInfoDo.setUpdateTime(new Date());
        } else {
            umcUserInfoDo.setUpdateTime(umcCustInfoSynBo.getUpdateTime());
        }
        return umcUserInfoDo;
    }

    private UmcUserInfoDo setInsertUserInfo(UmcCustInfoSynBo umcCustInfoSynBo, UmcCustInfo umcCustInfo, UmcOrgInfo umcOrgInfo, UmcEnterpriseInfoDo umcEnterpriseInfoDo) {
        UmcUserInfoDo umcUserInfoDo = new UmcUserInfoDo();
        umcUserInfoDo.setUserId(IdUtil.nextId());
        umcUserInfoDo.setCompanyId(umcOrgInfo.getCompanyId());
        umcUserInfoDo.setOrgId(umcOrgInfo.getOrgId());
        umcUserInfoDo.setCustId(umcCustInfo.getCustId());
        umcUserInfoDo.setMainCustId(umcCustInfo.getCustId());
        umcUserInfoDo.setIsMain("1");
        umcUserInfoDo.setOrgTreePath(umcOrgInfo.getOrgTreePath());
        umcUserInfoDo.setUserType(umcEnterpriseInfoDo.getOrgClass());
        umcUserInfoDo.setStopStatus(umcCustInfoSynBo.getStopStatus());
        umcUserInfoDo.setTenantId(null == umcCustInfoSynBo.getTenantId() ? this.tenantId : umcCustInfoSynBo.getTenantId());
        umcUserInfoDo.setDelFlag("0");
        umcUserInfoDo.setAuthorityType(AUTH_TYPE);
        if ("2".equals(umcEnterpriseInfoDo.getOrgClass())) {
            umcUserInfoDo.setSupRole(this.SUP_ROLE_ID);
        }
        if (null == umcCustInfoSynBo.getCreateOperId()) {
            umcUserInfoDo.setCreateOperId(DEFAULT_USER_ID);
        } else {
            umcUserInfoDo.setCreateOperId(umcCustInfoSynBo.getCreateOperId());
        }
        if (StringUtils.isBlank((CharSequence)umcCustInfoSynBo.getCreateOperName())) {
            umcUserInfoDo.setCreateOperName(DEFAULT_USER_NAME);
        } else {
            umcUserInfoDo.setCreateOperName(umcCustInfoSynBo.getCreateOperName());
        }
        if (null == umcCustInfoSynBo.getCreateTime()) {
            umcUserInfoDo.setCreateTime(new Date());
        } else {
            umcUserInfoDo.setCreateTime(umcCustInfoSynBo.getCreateTime());
        }
        return umcUserInfoDo;
    }

    private UmcCustInfo setInsertCustInfo(UmcCustInfoSynBo umcCustInfoSynBo, UmcCustInfo umcCustAndDeInfo) {
        UmcCustInfo umcCustInfo = UmcRu.js(umcCustInfoSynBo, UmcCustInfo.class);
        umcCustInfo.setCustId(IdUtil.nextId());
        umcCustInfo.setDelFlag("0");
        umcCustInfo.setIsOnline("0");
        umcCustInfo.setIsBlacklist("0");
        umcCustInfo.setHeadUrl(this.defaultHeadUrl);
        if (!StringUtils.isBlank((CharSequence)umcCustInfo.getPasswd())) {
            umcCustInfo.setIsPasswdValid("1");
        } else {
            umcCustInfo.setIsPasswdValid("0");
        }
        if (null == umcCustInfoSynBo.getCreateOperId()) {
            umcCustInfo.setCreateOperId(DEFAULT_USER_ID);
        } else {
            umcCustInfo.setCreateOperId(umcCustInfoSynBo.getCreateOperId());
        }
        if (StringUtils.isBlank((CharSequence)umcCustInfoSynBo.getCreateOperName())) {
            umcCustInfo.setCreateOperName(DEFAULT_USER_NAME);
        } else {
            umcCustInfo.setCreateOperName(umcCustInfoSynBo.getCreateOperName());
        }
        if (null == umcCustInfoSynBo.getCreateTime()) {
            umcCustInfo.setCreateTime(new Date());
        } else {
            umcCustInfo.setCreateTime(umcCustInfoSynBo.getCreateTime());
        }
        if (umcCustAndDeInfo != null) {
            umcCustInfo.setExtField1(umcCustAndDeInfo.getExtField1());
            umcCustInfo.setExtField2(umcCustAndDeInfo.getExtField2());
        }
        return umcCustInfo;
    }

    private void setUpdateCustInfo(UmcCustInfo umcCustInfo, UmcCustInfoSynBo umcCustInfoSynBo) {
        umcCustInfo.setBirthday(umcCustInfoSynBo.getBirthday());
        umcCustInfo.setCustName(umcCustInfoSynBo.getCustName());
        umcCustInfo.setCertNo(umcCustInfoSynBo.getCertNo());
        umcCustInfo.setCertType(umcCustInfoSynBo.getCertType());
        umcCustInfo.setCustClassify(umcCustInfoSynBo.getCustClassify());
        umcCustInfo.setCustStatus(umcCustInfoSynBo.getCustStatus());
        umcCustInfo.setStopStatus(umcCustInfoSynBo.getStopStatus());
        umcCustInfo.setRegEmail(umcCustInfoSynBo.getRegEmail());
        umcCustInfo.setRegMobile(umcCustInfoSynBo.getRegMobile());
        umcCustInfo.setCustNickname(umcCustInfoSynBo.getCustNickname());
        umcCustInfo.setWorkNo(umcCustInfoSynBo.getWorkNo());
        umcCustInfo.setPasswd(umcCustInfoSynBo.getPasswd());
        umcCustInfo.setOfficePhone(umcCustInfoSynBo.getOfficePhone());
        umcCustInfo.setSex(umcCustInfoSynBo.getSex());
        if (null == umcCustInfoSynBo.getUpdateOperId()) {
            umcCustInfo.setUpdateOperId(DEFAULT_USER_ID);
        } else {
            umcCustInfo.setUpdateOperId(umcCustInfoSynBo.getUpdateOperId());
        }
        if (StringUtils.isBlank((CharSequence)umcCustInfoSynBo.getUpdateOperName())) {
            umcCustInfo.setUpdateOperName(DEFAULT_USER_NAME);
        } else {
            umcCustInfo.setUpdateOperName(umcCustInfoSynBo.getUpdateOperName());
        }
        if (null == umcCustInfoSynBo.getUpdateTime()) {
            umcCustInfo.setUpdateTime(new Date());
        } else {
            umcCustInfo.setUpdateTime(umcCustInfoSynBo.getUpdateTime());
        }
    }

    private void validate(UmcSyncUserInfoReqBo reqBo) {
        if (CollectionUtils.isEmpty((Collection)reqBo.getUmcCustInfoSynBos())) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61[umcCustInfoSyncTempBoList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public static void main(String[] args) {
        Object[] eComCreditNoList = new String[]{"9131010405769500XK"};
        System.out.println(Arrays.toString(eComCreditNoList));
        System.out.println(JSON.toJSONString((Object)eComCreditNoList));
    }
}

