/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.enterprise;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.UmcEnterpriseInfoDo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseBankQryBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseContactQryBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseExtMapQryBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseInfoQryBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseInvoiceQryBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcOrgInfoQryBo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseBank;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseContact;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseExtMap;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseInvoice;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgInfo;
import com.tydic.dyc.umc.model.sysdictionary.IUmcSysDicDictionaryModel;
import com.tydic.dyc.umc.model.sysdictionary.SysDicDictionaryDo;
import com.tydic.dyc.umc.service.enterprise.UmcQryEnterpriseInfoDetailService;
import com.tydic.dyc.umc.service.enterprise.bo.UmcEnterpriseBankBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcEnterpriseContactBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcEnterpriseExtMapBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcEnterpriseInvoiceBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcOrgInfoBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcOrgTagRelBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryEnterpriseInfoDetailReqBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryEnterpriseInfoDetailRspBo;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.enterprise.UmcQryEnterpriseInfoDetailService"})
public class UmcQryEnterpriseInfoDetailServiceImpl
implements UmcQryEnterpriseInfoDetailService {
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;
    @Autowired
    private IUmcSysDicDictionaryModel iUmcSysDicDictionaryModel;
    private static final String LEVEL_E = "\u672a\u8bc4\u7ea7";
    private static final String LEVEL_D = "\u5f85\u8003\u5bdf";
    private static final String LEVEL_C = "\u666e\u901a";
    private static final String LEVEL_B = "\u826f\u597d";
    private static final String LEVEL_A = "\u4f18\u8d28";

    @PostMapping(value={"qryEnterpriseInfoDetail"})
    public UmcQryEnterpriseInfoDetailRspBo qryEnterpriseInfoDetail(@RequestBody UmcQryEnterpriseInfoDetailReqBo reqBo) {
        UmcOrgInfoQryBo orgInfoQryBo;
        UmcQryEnterpriseInfoDetailRspBo rspBo = UmcRu.success(UmcQryEnterpriseInfoDetailRspBo.class);
        UmcEnterpriseInfoQryBo enterpriseInfoQryBo = StrUtil.noNullStringAttr(UmcRu.js(reqBo, UmcEnterpriseInfoQryBo.class));
        UmcEnterpriseInfoDo enterpriseInfoDo = this.iUmcEnterpriseInfoModel.getEnterpriseInfo(enterpriseInfoQryBo);
        if (null == enterpriseInfoDo) {
            throw new BaseBusinessException("201006", "\u4f01\u4e1a\u8be6\u60c5\u67e5\u8be2\u4e3a\u7a7a");
        }
        BeanUtils.copyProperties((Object)((Object)enterpriseInfoDo), (Object)rspBo);
        UmcOrgInfoQryBo enterpriseOrgQryBo = new UmcOrgInfoQryBo();
        enterpriseOrgQryBo.setOrgId(enterpriseInfoDo.getOrgId());
        UmcOrgInfo orgInfo = this.iUmcEnterpriseInfoModel.getOrgInfo(enterpriseOrgQryBo);
        if (null == orgInfo) {
            throw new BaseBusinessException("201006", "\u4f01\u4e1a\u8be6\u60c5\u67e5\u8be2\uff0c\u673a\u6784\u4fe1\u606f\u4e3a\u7a7a");
        }
        UmcOrgInfoBo enterpriseOrgBo = UmcRu.js((Object)orgInfo, UmcOrgInfoBo.class);
        enterpriseOrgBo.setSupStatus(orgInfo.getExtField1());
        ArrayList<Long> orgIds = new ArrayList<Long>();
        orgIds.add(orgInfo.getOrgId());
        UmcEnterpriseInfoDo pathReqDo = new UmcEnterpriseInfoDo();
        pathReqDo.setOrgIds(orgIds);
        Map<Long, String> orgFullNameMap = this.iUmcEnterpriseInfoModel.getOrgFullNameByOrgIds(pathReqDo).getOrgFullNameByOrgIds();
        if (!CollectionUtils.isEmpty(orgFullNameMap)) {
            enterpriseOrgBo.setOrgFullName(orgFullNameMap.get(orgInfo.getOrgId()));
        }
        if (null != enterpriseOrgBo.getParentId() && 0L != enterpriseOrgBo.getParentId()) {
            orgInfoQryBo = new UmcOrgInfoQryBo();
            orgInfoQryBo.setOrgId(enterpriseOrgBo.getParentId());
            UmcOrgInfo parentOrgInfo = this.iUmcEnterpriseInfoModel.getOrgInfo(orgInfoQryBo);
            if (null == parentOrgInfo) {
                throw new BaseBusinessException("201006", "\u4f01\u4e1a\u8be6\u60c5\u67e5\u8be2\uff0c\u7236\u7ea7\u673a\u6784\u4fe1\u606f\u4e3a\u7a7a");
            }
            enterpriseOrgBo.setParentOrgName(parentOrgInfo.getOrgName());
            enterpriseOrgBo.setParentOrgType(parentOrgInfo.getOrgType());
        }
        orgInfoQryBo = new UmcOrgInfoQryBo();
        orgInfoQryBo.setParentId(reqBo.getOrgId());
        StrUtil.noNullStringAttr(orgInfoQryBo);
        Integer checkResult = this.iUmcEnterpriseInfoModel.getCheckOrgInfo(orgInfoQryBo).getNumber();
        if (checkResult > 0) {
            rspBo.setIsParentOrg("1");
        } else {
            rspBo.setIsParentOrg("0");
        }
        rspBo.setOrgInfoBo(enterpriseOrgBo);
        UmcEnterpriseInvoiceQryBo enterpriseInvoiceQryBo = new UmcEnterpriseInvoiceQryBo();
        enterpriseInvoiceQryBo.setOrgId(enterpriseInfoDo.getOrgId());
        List<UmcEnterpriseInvoice> enterpriseInvoiceList = this.iUmcEnterpriseInfoModel.getEnterpriseInvoiceList(enterpriseInvoiceQryBo).getEnterpriseInvoiceList();
        rspBo.setEnterpriseInvoiceBoList(UmcRu.jsl(enterpriseInvoiceList, UmcEnterpriseInvoiceBo.class));
        UmcEnterpriseBankQryBo enterpriseBankQryBo = new UmcEnterpriseBankQryBo();
        enterpriseBankQryBo.setOrgId(enterpriseInfoDo.getOrgId());
        List<UmcEnterpriseBank> enterpriseBankList = this.iUmcEnterpriseInfoModel.getEnterpriseBankList(enterpriseBankQryBo).getEnterpriseBankList();
        rspBo.setEnterpriseBankBoList(UmcRu.jsl(enterpriseBankList, UmcEnterpriseBankBo.class));
        UmcEnterpriseContactQryBo enterpriseContactQryBo = new UmcEnterpriseContactQryBo();
        enterpriseContactQryBo.setOrgId(enterpriseInfoDo.getOrgId());
        List<UmcEnterpriseContact> enterpriseContactList = this.iUmcEnterpriseInfoModel.getEnterpriseContactList(enterpriseContactQryBo).getEnterpriseContactList();
        rspBo.setEnterpriseContactBoList(UmcRu.jsl(enterpriseContactList, UmcEnterpriseContactBo.class));
        UmcEnterpriseExtMapQryBo enterpriseExtMapQryBo = new UmcEnterpriseExtMapQryBo();
        enterpriseExtMapQryBo.setOrgId(reqBo.getOrgId());
        List<UmcEnterpriseExtMap> umcEnterpriseExtMapList = this.iUmcEnterpriseInfoModel.getEnterpriseExtMapList(enterpriseExtMapQryBo).getEnterpriseExt();
        rspBo.setEnterpriseExt(UmcRu.jsl(umcEnterpriseExtMapList, UmcEnterpriseExtMapBo.class));
        this.transRspParam(rspBo);
        return rspBo;
    }

    private void transRspParam(UmcQryEnterpriseInfoDetailRspBo rspBo) {
        Map<String, String> orgClassMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "UMC_ORG_CLASS")).getMap();
        Map<String, String> orgTagRelMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "ORG_TRADE_CAPACITY")).getMap();
        Map<String, String> orgAbrodaMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "IS_ABROAD_ORG")).getMap();
        Map<String, String> orgNatureMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "ORG_NATURE")).getMap();
        Map<String, String> idCardTypeMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "ID_CARD_TYPE")).getMap();
        Map<String, String> orgStatuesMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "ENTERPRISE_ORG_STATUS")).getMap();
        Map<String, String> industryMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "TRADE_TYPE")).getMap();
        Map<String, String> inVirtualMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "IS_VIRTUAL")).getMap();
        if (!CollectionUtils.isEmpty(orgClassMap) && !StringUtils.isEmpty((Object)rspBo.getOrgClass())) {
            rspBo.setOrgClassStr(orgClassMap.get(rspBo.getOrgClass()));
        }
        if (!CollectionUtils.isEmpty(orgAbrodaMap) && !StringUtils.isEmpty((Object)rspBo.getIsAbroad())) {
            rspBo.setIsAbroadStr(orgAbrodaMap.get(rspBo.getIsAbroad()));
        }
        if (!CollectionUtils.isEmpty(orgNatureMap) && !StringUtils.isEmpty((Object)rspBo.getOrgNature())) {
            rspBo.setOrgNatureStr(orgNatureMap.get(rspBo.getOrgNature()));
        }
        if (!CollectionUtils.isEmpty(idCardTypeMap) && !StringUtils.isEmpty((Object)rspBo.getLegalCertificateType())) {
            rspBo.setLegalCertificateTypeStr(idCardTypeMap.get(rspBo.getLegalCertificateType()));
        }
        if (!CollectionUtils.isEmpty(industryMap) && !StringUtils.isEmpty((Object)rspBo.getIndustry())) {
            rspBo.setIndustryStr(industryMap.get(rspBo.getIndustry()));
        }
        if (!CollectionUtils.isEmpty(inVirtualMap) && !StringUtils.isEmpty((Object)rspBo.getOrgInfoBo().getIsVirtual())) {
            rspBo.getOrgInfoBo().setIsVirtualStr(inVirtualMap.get(rspBo.getOrgInfoBo().getIsVirtual()));
        }
        if ("0".equals(rspBo.getIsMerchant()) && !StringUtils.isEmpty((Object)rspBo.getSupplierLevel())) {
            if (rspBo.getSupplierLevel().equals("E")) {
                rspBo.setSupplierLevelTag(LEVEL_E);
            }
            if (rspBo.getSupplierLevel().equals("D")) {
                rspBo.setSupplierLevelTag(LEVEL_D);
            }
            if (rspBo.getSupplierLevel().equals("C")) {
                rspBo.setSupplierLevelTag(LEVEL_C);
            }
            if (rspBo.getSupplierLevel().equals("B")) {
                rspBo.setSupplierLevelTag(LEVEL_B);
            }
            if (rspBo.getSupplierLevel().equals("A")) {
                rspBo.setSupplierLevelTag(LEVEL_A);
            }
        } else if ("1".equals(rspBo.getIsMerchant()) && StringUtils.isEmpty((Object)rspBo.getSupplierLevel())) {
            rspBo.setSupplierLevelTag(LEVEL_E);
        }
        if (null != rspBo.getOrgInfoBo()) {
            rspBo.getOrgInfoBo().setOrgStatusStr(orgStatuesMap.get(rspBo.getOrgInfoBo().getOrgStatus()));
            if (!StringUtils.isEmpty((Object)rspBo.getOrgInfoBo().getSupStatus())) {
                rspBo.getOrgInfoBo().setSupStatusStr(orgStatuesMap.get(rspBo.getOrgInfoBo().getSupStatus()));
            }
            if (!CollectionUtils.isEmpty((Collection)rspBo.getOrgInfoBo().getOrgTagRelList())) {
                for (UmcOrgTagRelBo orgTagRelBo : rspBo.getOrgInfoBo().getOrgTagRelList()) {
                    if (null == orgTagRelBo.getTagId()) continue;
                    orgTagRelBo.setTagIdStr(orgTagRelMap.get(orgTagRelBo.getTagId()));
                }
            }
        }
    }
}

