/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.todo;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.model.todo.IUmcTodoModel;
import com.tydic.dyc.umc.model.todo.UmcTodoDo;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoDone;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoDoneList;
import com.tydic.dyc.umc.model.user.IUmcUserInfoModel;
import com.tydic.dyc.umc.model.user.qrybo.UmcUserInfoQryBo;
import com.tydic.dyc.umc.service.todo.UmcSendHaveDoneService;
import com.tydic.dyc.umc.service.todo.bo.UmcSendHaveDoneReqBo;
import com.tydic.dyc.umc.service.todo.bo.UmcSendHaveDoneRspBo;
import com.tydic.dyc.umc.service.todo.bo.UmcTodoExtBo;
import com.tydic.dyc.umc.service.todo.bo.UmcTodoPushExtBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.todo.UmcSendHaveDoneService"})
public class UmcSendHaveDoneServiceImpl
implements UmcSendHaveDoneService {
    private static final Logger log = LoggerFactory.getLogger(UmcSendHaveDoneServiceImpl.class);
    @Autowired
    private IUmcTodoModel iUmcTodoModel;
    @Resource(name="umcTodoSyncProvider")
    private ProxyMessageProducer proxyMessageProducer;
    @Value(value="${umc.todo.sync.topic:UMC_TODO_SYNC_TOPIC}")
    private String todoSyncTopic;
    @Value(value="${umc.todo.sync.tag:*}")
    private String todoSyncTag;
    @Value(value="${umc.have.done.sync.enable:true}")
    private boolean haveDoneSyncEnable;
    private static final Integer PUSH = 1;
    private static final Integer PASS = 1;
    @Autowired
    private IUmcUserInfoModel iUmcUserInfoModel;

    @PostMapping(value={"sendHaveDone"})
    public UmcSendHaveDoneRspBo sendHaveDone(@RequestBody UmcSendHaveDoneReqBo reqBO) {
        UmcTodoDo qryDo = new UmcTodoDo();
        BeanUtils.copyProperties((Object)reqBO, (Object)qryDo);
        List<UmcTodoDo> results = this.iUmcTodoModel.getTodoList(qryDo);
        if (CollectionUtils.isEmpty(results)) {
            throw new BaseBusinessException("200100", "\u67e5\u8be2\u5f85\u529e\u5217\u8868\u4e3a\u7a7a");
        }
        Date now = new Date();
        ArrayList<UmcTodoDone> todoDoneList = new ArrayList<UmcTodoDone>();
        ArrayList<Long> deleteTodoIdList = new ArrayList<Long>();
        UmcTodoDo dealUmcTodoDo = results.get(0);
        UmcTodoDone umcTodoDone = new UmcTodoDone();
        BeanUtils.copyProperties((Object)dealUmcTodoDo, (Object)umcTodoDone);
        umcTodoDone.setTodoStatus(UmcCommConstant.TODO_STATUS.DONE);
        umcTodoDone.setTodoCreateTime(dealUmcTodoDo.getCreateTime());
        umcTodoDone.setCreateTime(now);
        todoDoneList.add(umcTodoDone);
        deleteTodoIdList.add(umcTodoDone.getTodoId());
        if (reqBO.getIsAllDeal().booleanValue()) {
            qryDo.setDealUserId(null);
            List<UmcTodoDo> otherTodoList = this.iUmcTodoModel.getTodoList(qryDo);
            if (CollectionUtils.isEmpty(otherTodoList)) {
                throw new BaseBusinessException("200100", "\u67e5\u8be2\u5f85\u529e\u5217\u8868\u4e3a\u7a7a");
            }
            for (UmcTodoDo bo : otherTodoList) {
                if (Objects.equals(bo.getDealUserId(), reqBO.getDealUserId())) continue;
                UmcTodoDone otherUmcTodoDone = new UmcTodoDone();
                BeanUtils.copyProperties((Object)bo, (Object)otherUmcTodoDone);
                otherUmcTodoDone.setTodoStatus(UmcCommConstant.TODO_STATUS.REVOKE);
                otherUmcTodoDone.setTodoCreateTime(dealUmcTodoDo.getCreateTime());
                otherUmcTodoDone.setCreateTime(now);
                otherUmcTodoDone.setCreateUserId(dealUmcTodoDo.getCreateUserId());
                otherUmcTodoDone.setCreateName(dealUmcTodoDo.getCreateName());
                otherUmcTodoDone.setCreateOrgId(dealUmcTodoDo.getCreateOrgId());
                otherUmcTodoDone.setCreateOrgName(dealUmcTodoDo.getCreateOrgName());
                todoDoneList.add(otherUmcTodoDone);
                deleteTodoIdList.add(otherUmcTodoDone.getTodoId());
            }
        }
        UmcTodoDoneList umcTodoDoneList = new UmcTodoDoneList();
        umcTodoDoneList.setUmcTodoDoneList(todoDoneList);
        int isInsert = this.iUmcTodoModel.createDone(umcTodoDoneList);
        UmcTodoDo delTodoDo = new UmcTodoDo();
        delTodoDo.setTodoIdList(deleteTodoIdList);
        List<UmcTodoDo> delTodoList = this.iUmcTodoModel.getTodoList(qryDo);
        UmcTodoDo deleteUmcTodoDo = new UmcTodoDo();
        deleteUmcTodoDo.setTodoIdList(deleteTodoIdList);
        int isDelete = this.iUmcTodoModel.deleteTodo(deleteUmcTodoDo).getCheck();
        if (this.haveDoneSyncEnable) {
            this.sendMq(todoDoneList, reqBO, now, delTodoList);
        }
        return UmcRu.success(UmcSendHaveDoneRspBo.class);
    }

    private void sendMq(List<UmcTodoDone> todoDoneList, UmcSendHaveDoneReqBo reqBO, Date now, List<UmcTodoDo> delTodoList) {
        List umcTodoDones = todoDoneList.stream().filter(umcTodoDone -> PUSH.equals(umcTodoDone.getPushFlag())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(umcTodoDones)) {
            List dealUserIds = umcTodoDones.stream().map(UmcTodoDone::getDealUserId).collect(Collectors.toList());
            dealUserIds.addAll(umcTodoDones.stream().map(UmcTodoDone::getCreateUserId).distinct().collect(Collectors.toList()));
            if (!CollectionUtils.isEmpty(delTodoList)) {
                dealUserIds.addAll(delTodoList.stream().map(UmcTodoDo::getCreateUserId).distinct().collect(Collectors.toList()));
                dealUserIds.addAll(delTodoList.stream().map(UmcTodoDo::getDealUserId).distinct().collect(Collectors.toList()));
            }
            if (null != reqBO.getDealUserId()) {
                dealUserIds.add(reqBO.getDealUserId());
            }
            UmcUserInfoQryBo qryBO = new UmcUserInfoQryBo();
            qryBO.setUserIdList(dealUserIds.stream().distinct().collect(Collectors.toList()));
            List umcUserInfoQryBoList = this.iUmcUserInfoModel.getTodoUserInfoList(qryBO).getRows();
            if (!CollectionUtils.isEmpty((Collection)umcUserInfoQryBoList)) {
                List<UmcTodoDone> delList;
                Map userMap = umcUserInfoQryBoList.stream().collect(Collectors.toConcurrentMap(UmcUserInfoQryBo::getUserId, o -> o, (o1, o2) -> o1));
                List<UmcTodoDone> doneList = umcTodoDones.stream().filter(umcTodoDone -> UmcCommConstant.TODO_STATUS.DONE.equals(umcTodoDone.getTodoStatus())).collect(Collectors.toList());
                ConcurrentMap<Long, UmcTodoDo> delTodoMap = delTodoList.stream().collect(Collectors.toConcurrentMap(UmcTodoDo::getTodoId, o -> o, (o1, o2) -> o1));
                if (!CollectionUtils.isEmpty(doneList)) {
                    UmcTodoPushExtBo umcTodoPushExtBo = UmcSendHaveDoneServiceImpl.assembleDone(reqBO, now, userMap, doneList, delTodoMap);
                    log.info("\u5df2\u529e\u53d1\u9001\u6d88\u606f\u5185\u5bb9 umcTodoPushExtBo:{}", (Object)JSON.toJSONString((Object)umcTodoPushExtBo));
                    if (!CollectionUtils.isEmpty((Collection)umcTodoPushExtBo.getTodoInfoList())) {
                        this.proxyMessageProducer.send(new ProxyMessage(this.todoSyncTopic, this.todoSyncTag, JSON.toJSONString((Object)umcTodoPushExtBo)));
                    }
                }
                if (!CollectionUtils.isEmpty(delList = umcTodoDones.stream().filter(umcTodoDone -> UmcCommConstant.TODO_STATUS.REVOKE.equals(umcTodoDone.getTodoStatus())).collect(Collectors.toList()))) {
                    UmcTodoPushExtBo umcTodoPushExtBo = this.assembleDelTodo(reqBO, now, userMap, delList);
                    log.info("\u5df2\u529e\u5220\u9664\u5f85\u529e\u53d1\u9001\u6d88\u606f\u5185\u5bb9 umcTodoPushExtBo:{}", (Object)JSON.toJSONString((Object)umcTodoPushExtBo));
                    this.proxyMessageProducer.send(new ProxyMessage(this.todoSyncTopic, this.todoSyncTag, JSON.toJSONString((Object)umcTodoPushExtBo)));
                }
            }
        }
    }

    private UmcTodoPushExtBo assembleDelTodo(UmcSendHaveDoneReqBo reqBO, Date now, Map<Long, UmcUserInfoQryBo> userMap, List<UmcTodoDone> doneList) {
        UmcTodoPushExtBo umcTodoPushExtBo = new UmcTodoPushExtBo();
        umcTodoPushExtBo.setEventType("01");
        umcTodoPushExtBo.setDataStatus("03");
        ArrayList<UmcTodoExtBo> umcTodoExtBos = new ArrayList<UmcTodoExtBo>();
        for (UmcTodoDone todoDone : doneList) {
            UmcUserInfoQryBo dealUserInfo = userMap.get(todoDone.getDealUserId());
            UmcTodoExtBo umcTodoExtBo = new UmcTodoExtBo();
            umcTodoExtBo.setTaskId(todoDone.getTodoId().toString());
            umcTodoExtBo.setCurDealerTellerNo(dealUserInfo.getWorkNo());
            umcTodoExtBo.setCurDealerTellerName(dealUserInfo.getCustName());
            umcTodoExtBos.add(umcTodoExtBo);
        }
        umcTodoPushExtBo.setTodoInfoList(umcTodoExtBos);
        return umcTodoPushExtBo;
    }

    private static UmcTodoPushExtBo assembleDone(UmcSendHaveDoneReqBo reqBO, Date now, Map<Long, UmcUserInfoQryBo> userMap, List<UmcTodoDone> doneList, ConcurrentMap<Long, UmcTodoDo> delTodoMap) {
        UmcTodoPushExtBo umcTodoPushExtBo = new UmcTodoPushExtBo();
        umcTodoPushExtBo.setEventType("02");
        umcTodoPushExtBo.setDataStatus("01");
        ArrayList<UmcTodoExtBo> umcTodoExtBos = new ArrayList<UmcTodoExtBo>();
        for (UmcTodoDone todoDone : doneList) {
            UmcUserInfoQryBo sendUserInfo = userMap.get(todoDone.getCreateUserId());
            if (StringUtils.isBlank((CharSequence)sendUserInfo.getWorkNo())) continue;
            UmcUserInfoQryBo dealUserInfo = userMap.get(todoDone.getDealUserId());
            UmcTodoDo umcTodoDo = (UmcTodoDo)delTodoMap.get(todoDone.getTodoId());
            UmcTodoExtBo umcTodoExtBo = new UmcTodoExtBo();
            umcTodoExtBo.setTaskId(todoDone.getTodoId().toString());
            umcTodoExtBo.setTaskTitle(todoDone.getTodoTitle());
            umcTodoExtBo.setWorkFlowName(todoDone.getBusiItemName());
            umcTodoExtBo.setStartTellerNo(sendUserInfo.getWorkNo());
            umcTodoExtBo.setStartTellerName(sendUserInfo.getCustName());
            umcTodoExtBo.setCurDealerTellerNo(dealUserInfo.getWorkNo());
            umcTodoExtBo.setCurDealerTellerName(dealUserInfo.getCustName());
            umcTodoExtBo.setPcTargetUrl(todoDone.getDoneUrl());
            umcTodoExtBo.setFlowId(todoDone.getObjId().toString());
            umcTodoExtBo.setFlowName(todoDone.getTodoTitle());
            if (null != reqBO.getAuditOrderCreateTime()) {
                umcTodoExtBo.setFlowStartTime(Convert.toStr((Object)reqBO.getAuditOrderCreateTime().getTime()));
            }
            if (null != reqBO.getAuditFinishFlag() && reqBO.getAuditFinishFlag().booleanValue()) {
                if (PASS.equals(reqBO.getAuditResult())) {
                    umcTodoExtBo.setFlowStatus("01");
                } else {
                    umcTodoExtBo.setFlowStatus("02");
                }
                umcTodoExtBo.setFlowEndTime(Convert.toStr((Object)now.getTime()));
            }
            if (null != umcTodoDo) {
                umcTodoExtBo.setTaskStartTime(Convert.toStr((Object)umcTodoDo.getCreateTime().getTime()));
            }
            umcTodoExtBo.setTaskActualEndTime(Convert.toStr((Object)now.getTime()));
            umcTodoExtBos.add(umcTodoExtBo);
        }
        umcTodoPushExtBo.setTodoInfoList(umcTodoExtBos);
        return umcTodoPushExtBo;
    }
}

