/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.todo;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.model.todo.IUmcTodoModel;
import com.tydic.dyc.umc.model.todo.UmcTodoDo;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoDone;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoDoneList;
import com.tydic.dyc.umc.model.user.IUmcUserInfoModel;
import com.tydic.dyc.umc.model.user.qrybo.UmcUserInfoQryBo;
import com.tydic.dyc.umc.repository.UmcUserInfoRepository;
import com.tydic.dyc.umc.service.todo.UmcSendRevokeTodoService;
import com.tydic.dyc.umc.service.todo.bo.UmcRevokeTodoBO;
import com.tydic.dyc.umc.service.todo.bo.UmcSendRevokeTodoReqBo;
import com.tydic.dyc.umc.service.todo.bo.UmcSendRevokeTodoRspBo;
import com.tydic.dyc.umc.service.todo.bo.UmcTodoExtBo;
import com.tydic.dyc.umc.service.todo.bo.UmcTodoPushExtBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.todo.UmcSendRevokeTodoService"})
public class UmcSendRevokeTodoServiceImpl
implements UmcSendRevokeTodoService {
    private static final Logger log = LoggerFactory.getLogger(UmcSendRevokeTodoServiceImpl.class);
    @Autowired
    private IUmcTodoModel iUmcTodoModel;
    @Resource(name="umcTodoSyncProvider")
    private ProxyMessageProducer proxyMessageProducer;
    @Value(value="${umc.todo.sync.topic:UMC_TODO_SYNC_TOPIC}")
    private String todoSyncTopic;
    @Value(value="${umc.todo.sync.tag:*}")
    private String todoSyncTag;
    @Autowired
    private UmcUserInfoRepository umcUserInfoRepository;
    @Value(value="${umc.revoke.todo.sync.enable:true}")
    private boolean revokeTodoSyncEnable;
    private static final Integer PUSH = 1;
    @Autowired
    private IUmcUserInfoModel iUmcUserInfoModel;

    @PostMapping(value={"revokeTodo"})
    public UmcSendRevokeTodoRspBo revokeTodo(@RequestBody UmcSendRevokeTodoReqBo reqBO) {
        Date now = new Date();
        ArrayList<UmcTodoDone> todoDoneList = new ArrayList<UmcTodoDone>();
        ArrayList<Long> deleteTodoIdList = new ArrayList<Long>();
        for (UmcRevokeTodoBO bo : reqBO.getUmcRevokeTodoBOList()) {
            UmcTodoDo qryDo = new UmcTodoDo();
            BeanUtils.copyProperties((Object)bo, (Object)qryDo);
            List<UmcTodoDo> results = this.iUmcTodoModel.getTodoList(qryDo);
            if (CollectionUtils.isEmpty(results)) {
                throw new BaseBusinessException("200100", "\u67e5\u8be2\u5f85\u529e\u5217\u8868\u4e3a\u7a7a");
            }
            for (UmcTodoDo bo2 : results) {
                UmcTodoDone umcTodoDone = new UmcTodoDone();
                BeanUtils.copyProperties((Object)bo2, (Object)umcTodoDone);
                umcTodoDone.setTodoStatus(UmcCommConstant.TODO_STATUS.REVOKE);
                umcTodoDone.setTodoCreateTime(bo2.getCreateTime());
                umcTodoDone.setCreateTime(now);
                todoDoneList.add(umcTodoDone);
                deleteTodoIdList.add(umcTodoDone.getTodoId());
            }
        }
        UmcTodoDoneList umcTodoDoneList = new UmcTodoDoneList();
        umcTodoDoneList.setUmcTodoDoneList(todoDoneList);
        int isInsert = this.iUmcTodoModel.createDone(umcTodoDoneList);
        UmcTodoDo deleteUmcTodoDo = new UmcTodoDo();
        deleteUmcTodoDo.setTodoIdList(deleteTodoIdList);
        int isDelete = this.iUmcTodoModel.deleteTodo(deleteUmcTodoDo).getCheck();
        if (this.revokeTodoSyncEnable) {
            this.sendMq(todoDoneList);
        }
        return UmcRu.success(UmcSendRevokeTodoRspBo.class);
    }

    private void sendMq(List<UmcTodoDone> todoDoneList) {
        List umcTodoDones;
        if (!CollectionUtils.isEmpty(todoDoneList) && !CollectionUtils.isEmpty(umcTodoDones = todoDoneList.stream().filter(a -> PUSH.equals(a.getPushFlag())).collect(Collectors.toList()))) {
            List<Long> userIds = umcTodoDones.stream().map(UmcTodoDone::getDealUserId).distinct().collect(Collectors.toList());
            UmcUserInfoQryBo qryBO = new UmcUserInfoQryBo();
            qryBO.setUserIdList(userIds);
            List umcUserInfoQryBoList = this.iUmcUserInfoModel.getTodoUserInfoList(qryBO).getRows();
            if (!CollectionUtils.isEmpty((Collection)umcUserInfoQryBoList)) {
                Map userMap = umcUserInfoQryBoList.stream().collect(Collectors.toConcurrentMap(UmcUserInfoQryBo::getUserId, o -> o, (o1, o2) -> o1));
                UmcTodoPushExtBo umcTodoPushExtBo = new UmcTodoPushExtBo();
                umcTodoPushExtBo.setEventType("01");
                umcTodoPushExtBo.setDataStatus("03");
                ArrayList<UmcTodoExtBo> umcTodoExtBos = new ArrayList<UmcTodoExtBo>();
                for (UmcTodoDone todoDone : umcTodoDones) {
                    UmcUserInfoQryBo dealUserInfo = (UmcUserInfoQryBo)((Object)userMap.get(todoDone.getDealUserId()));
                    UmcTodoExtBo umcTodoExtBo = new UmcTodoExtBo();
                    umcTodoExtBo.setTaskId(todoDone.getTodoId().toString());
                    umcTodoExtBo.setCurDealerTellerNo(dealUserInfo.getWorkNo());
                    umcTodoExtBo.setCurDealerTellerName(dealUserInfo.getCustName());
                    umcTodoExtBos.add(umcTodoExtBo);
                }
                umcTodoPushExtBo.setTodoInfoList(umcTodoExtBos);
                log.info("\u64a4\u9500\u5f85\u529e\u53d1\u9001\u6d88\u606f\u5185\u5bb9 umcTodoPushExtBo:{}", (Object)JSON.toJSONString((Object)umcTodoPushExtBo));
                this.proxyMessageProducer.send(new ProxyMessage(this.todoSyncTopic, this.todoSyncTag, JSON.toJSONString((Object)umcTodoPushExtBo)));
            }
        }
    }
}

