/*
 * Decompiled with CFR 0.152.
 */
package com.youzan.cloud.open.security.exception;

import com.youzan.cloud.open.security.exception.ErrorMessage;
import org.apache.commons.lang3.StringUtils;

public class DataSecurityException
extends Exception {
    private Integer code;
    private String message;

    public DataSecurityException(Throwable cause) {
        super(cause);
    }

    public DataSecurityException(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    public DataSecurityException(Exception e, ErrorMessage errorMessage) {
        super(e);
        this.code = errorMessage.getCode();
        this.message = errorMessage.getMessage();
    }

    public DataSecurityException(Exception e, ErrorMessage errorMessage, String message) throws DataSecurityException {
        this.code = errorMessage.getCode();
        if (StringUtils.isNotBlank((CharSequence)message)) {
            errorMessage.setMessage(message);
        }
        throw new DataSecurityException(e, errorMessage);
    }

    public void appendMessage(String message) {
        this.message = this.message + message;
    }

    @Override
    public String getMessage() {
        return String.format("code:%s,message:%s", this.code, this.message);
    }

    public Integer getCode() {
        return this.code;
    }
}

