/*
 * Decompiled with CFR 0.152.
 */
package com.youzan.cloud.open.security.response;

import com.youzan.cloud.open.security.response.CommonResultCode;
import com.youzan.cloud.open.security.response.IErrorCode;
import java.io.Serializable;
import java.util.Map;

public class BaseResult
implements Serializable {
    private static final long serialVersionUID = 1949910043360896391L;
    private boolean success;
    private int code;
    private String message;
    private String requestId;
    private Map<String, Object> errorData;

    public BaseResult() {
        this.code = CommonResultCode.SUCCESS.code;
        this.success = true;
        this.message = CommonResultCode.SUCCESS.message;
    }

    public <R extends BaseResult> R setErrorMessage(int code, String message) {
        this.code = code;
        this.success = false;
        this.message = message;
        return (R)this;
    }

    public <R extends BaseResult> R setErrorMessage(IErrorCode code, Object ... args) {
        this.code = code.getCode();
        this.success = false;
        this.message = String.format(code.getMessage(), args);
        return (R)this;
    }

    public <R extends BaseResult> R setError(CommonResultCode rc, Object ... args) {
        this.code = rc.code;
        this.success = false;
        this.message = args == null || args.length == 0 ? rc.message : String.format(rc.message, args);
        return (R)this;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public Map<String, Object> getErrorData() {
        return this.errorData;
    }

    public void setErrorData(Map<String, Object> errorData) {
        this.errorData = errorData;
    }

    public String toString() {
        return "BaseResult(success=" + this.isSuccess() + ", code=" + this.getCode() + ", message=" + this.getMessage() + ", requestId=" + this.getRequestId() + ", errorData=" + this.getErrorData() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseResult)) {
            return false;
        }
        BaseResult other = (BaseResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        Map<String, Object> this$errorData = this.getErrorData();
        Map<String, Object> other$errorData = other.getErrorData();
        return !(this$errorData == null ? other$errorData != null : !((Object)this$errorData).equals(other$errorData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        result = result * 59 + this.getCode();
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        Map<String, Object> $errorData = this.getErrorData();
        result = result * 59 + ($errorData == null ? 43 : ((Object)$errorData).hashCode());
        return result;
    }
}

