/*
 * Decompiled with CFR 0.152.
 */
package com.youzan.cloud.open.security.secret;

import com.youzan.cloud.open.security.secret.SecretCache;
import com.youzan.cloud.open.security.secret.Separator;
import com.youzan.cloud.open.security.utils.Base64_;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

public class SecretServer {
    protected SecretCache secretCache;

    public SecretServer(SecretCache secretCache) {
        this.secretCache = secretCache;
    }

    public SecretCache getSecretCache() {
        return this.secretCache;
    }

    public boolean isEncrypt(String data) {
        if (StringUtils.isBlank((CharSequence)data) || data.length() < 4) {
            return false;
        }
        char separatorChar = Separator.DEFAULT.getCode();
        if (data.charAt(0) != separatorChar || data.charAt(data.length() - 1) != separatorChar) {
            return false;
        }
        String[] dataArray = StringUtils.split((String)data, (char)separatorChar);
        if (dataArray.length != 2) {
            return false;
        }
        return SecretServer.checkEncryptData(dataArray);
    }

    public boolean isEncrypt(Collection<String> datas) {
        if (null == datas) {
            return false;
        }
        for (String data : datas) {
            if (this.isEncrypt(data)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkEncryptData(String[] dataArray) {
        String version = dataArray[dataArray.length - 1];
        return StringUtils.isNumeric((CharSequence)version) && Base64_.isBase64Value(dataArray[0]);
    }

    protected static String getOriginEncryptData(String encryptContext, char separatorChar) {
        String[] data = StringUtils.split((String)encryptContext, (char)separatorChar);
        if (null == data) {
            return null;
        }
        return data[0];
    }

    protected static Integer getEncryptVersion(String encryptContext, char separatorChar) {
        String[] data = StringUtils.split((String)encryptContext, (char)separatorChar);
        if (null == data || 2 != data.length) {
            return null;
        }
        return Integer.parseInt(data[1]);
    }
}

