/*
 * Decompiled with CFR 0.152.
 */
package com.youzan.cloud.open.security.utils;

import com.youzan.cloud.open.security.utils.CryptException;
import com.youzan.cloud.open.security.utils.Encodes;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class Cryptos {
    public static final byte[] IV_BYTES = "0807060504030201".getBytes();
    private static final String AES = "AES";
    private static final String AES_CBC = "AES/CBC/PKCS5Padding";
    private static final String HMACSHA1 = "HmacSHA1";
    private static final int DEFAULT_HMACSHA1_KEYSIZE = 160;
    private static final int DEFAULT_AES_KEYSIZE = 128;
    private static final int DEFAULT_IVSIZE = 16;
    private static SecureRandom random = new SecureRandom();

    public static byte[] hmacSha1(byte[] input, byte[] key) {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, HMACSHA1);
            Mac mac = Mac.getInstance(HMACSHA1);
            mac.init(secretKey);
            return mac.doFinal(input);
        }
        catch (GeneralSecurityException e) {
            throw new CryptException("\u4f7f\u7528HMAC-SHA1\u8fdb\u884c\u6d88\u606f\u7b7e\u540d\u51fa\u9519\uff1a", e);
        }
    }

    public static boolean isMacValid(byte[] expected, byte[] input, byte[] key) {
        byte[] actual = Cryptos.hmacSha1(input, key);
        return Arrays.equals(expected, actual);
    }

    public static byte[] generateHmacSha1Key() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(HMACSHA1);
            keyGenerator.init(160);
            SecretKey secretKey = keyGenerator.generateKey();
            return secretKey.getEncoded();
        }
        catch (GeneralSecurityException e) {
            throw new CryptException("\u751f\u6210HMAC-SHA1\u5bc6\u94a5\u51fa\u9519\uff1a", e);
        }
    }

    public byte[] aesEncrypt(byte[] key, byte[] input) {
        if (key.length != 16) {
            throw new CryptException("Key\u957f\u5ea6\u4e0d\u662f16\u4f4d");
        }
        return Cryptos.aes(input, key, 1);
    }

    public String aesEncrypt(byte[] key, String input) {
        try {
            byte[] encryptResult = this.aesEncrypt(input.getBytes(), key);
            return Encodes.encodeHex(encryptResult);
        }
        catch (Exception e) {
            throw new CryptException("\u751f\u6210HMAC-SHA1\u5bc6\u94a5\u51fa\u9519\uff1a", e);
        }
    }

    public static byte[] aesEncrypt(byte[] input, byte[] key, byte[] iv) {
        return Cryptos.aes(input, key, iv, 1);
    }

    public String aesDecrypt(byte[] key, byte[] input) throws UnsupportedEncodingException {
        if (key.length != 16) {
            throw new CryptException("Key\u957f\u5ea6\u4e0d\u662f16\u4f4d");
        }
        byte[] decryptResult = Cryptos.aes(input, key, 2);
        return new String(decryptResult, "utf-8");
    }

    public String aesDecrypt(byte[] key, String input) {
        try {
            return this.aesDecrypt(key, Encodes.decodeHex(input));
        }
        catch (Exception e) {
            throw new CryptException("\u89e3\u5bc6\u51fa\u9519\uff1a", e);
        }
    }

    public static String aesDecrypt(byte[] input, byte[] key, byte[] iv) throws UnsupportedEncodingException {
        byte[] decryptResult = Cryptos.aes(input, key, iv, 2);
        return new String(decryptResult, "utf-8");
    }

    private static byte[] aes(byte[] input, byte[] key, int mode) {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, AES);
            Cipher cipher = Cipher.getInstance(AES);
            cipher.init(mode, secretKey);
            return cipher.doFinal(input);
        }
        catch (GeneralSecurityException e) {
            throw new CryptException("\u4f7f\u7528AES\u52a0\u5bc6\u6216\u89e3\u5bc6\u65e0\u7f16\u7801\u7684\u539f\u59cb\u5b57\u8282\u6570\u7ec4\u51fa\u9519\uff1a", e);
        }
    }

    private static byte[] aes(byte[] input, byte[] key, byte[] iv, int mode) {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, AES);
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            Cipher cipher = Cipher.getInstance(AES_CBC);
            cipher.init(mode, (Key)secretKey, ivSpec);
            return cipher.doFinal(input);
        }
        catch (BadPaddingException bpe) {
            throw new CryptException("\u4f7f\u7528\u4e86\u9519\u8bef\u7684\u5bc6\u94a5\u8fdb\u884c\u52a0\u89e3\u5bc6\u64cd\u4f5c", bpe);
        }
        catch (GeneralSecurityException e) {
            throw new CryptException("\u4f7f\u7528AES\u52a0\u5bc6\u6216\u89e3\u5bc6\u65e0\u7f16\u7801\u7684\u539f\u59cb\u5b57\u8282\u6570\u7ec4\uff1a", e);
        }
    }

    public static byte[] generateIV() {
        byte[] bytes = new byte[16];
        random.nextBytes(bytes);
        return bytes;
    }
}

