/*
 * Decompiled with CFR 0.152.
 */
package com.youzan.cloud.open.security.utils;

import com.youzan.cloud.open.security.utils.CryptException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public class Encodes {
    public static final String DEFAULT_URL_ENCODING = "UTF-8";
    private static final char[] BASE62 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();

    public static String encodeHex(byte[] input) {
        return Hex.encodeHexString((byte[])input);
    }

    public static byte[] decodeHex(String input) {
        try {
            return Hex.decodeHex((char[])input.toCharArray());
        }
        catch (DecoderException e) {
            throw new CryptException("Hex\u89e3\u7801\u51fa\u9519\uff1a", e);
        }
    }

    public static String encodeBase64(byte[] input) {
        return Base64.encodeBase64String((byte[])input);
    }

    public static String encodeUrlSafeBase64(byte[] input) {
        return Base64.encodeBase64URLSafeString((byte[])input);
    }

    public static byte[] decodeBase64(String input) {
        return Base64.decodeBase64((String)input);
    }

    public static String encodeBase62(byte[] input) {
        char[] chars = new char[input.length];
        for (int i = 0; i < input.length; ++i) {
            chars[i] = BASE62[(input[i] & 0xFF) % BASE62.length];
        }
        return new String(chars);
    }

    public static String urlEncode(String part) {
        try {
            return URLEncoder.encode(part, DEFAULT_URL_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new CryptException("URL \u7f16\u7801\u51fa\u9519\uff1a", e);
        }
    }

    public static String urlDecode(String part) {
        try {
            return URLDecoder.decode(part, DEFAULT_URL_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new CryptException("URL \u89e3\u7801\u51fa\u9519\uff1a", e);
        }
    }
}

