/*
 * Decompiled with CFR 0.152.
 */
package com.youzan.cloud.open.security.utils;

import com.youzan.cloud.open.security.exception.DataSecurityException;
import com.youzan.cloud.open.security.exception.ErrorMessage;
import com.youzan.cloud.open.security.utils.Base64_;
import com.youzan.cloud.open.security.utils.CryptException;
import com.youzan.cloud.open.security.utils.Cryptos;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;

public class SecretUtils {
    private static final String MAC_HMAC_MD5 = "HmacMD5";
    private static final String AES = "aes";
    private static final byte[] IVPS_BYTES = "0102030405060708".getBytes();

    public static String hmacMD5Encrypt(String encryptContent, byte[] encryptKey, int compressLength) throws DataSecurityException {
        try {
            return SecretUtils.base64Encode(SecretUtils.compress(SecretUtils.hmacMD5Encrypt(encryptContent, encryptKey), compressLength));
        }
        catch (Exception e) {
            throw new DataSecurityException(ErrorMessage.SDK_ERROR.getCode(), "hmacMd5\u52a0\u5bc6\u51fa\u73b0\u5f02\u5e38");
        }
    }

    public static byte[] hmacMD5Encrypt(String encryptContent, byte[] encryptKey) throws DataSecurityException {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(encryptKey, MAC_HMAC_MD5);
            Mac mac = Mac.getInstance(MAC_HMAC_MD5);
            mac.init(secretKey);
            byte[] text = encryptContent.getBytes(Charset.forName("UTF-8"));
            return mac.doFinal(text);
        }
        catch (Exception e) {
            throw new DataSecurityException(e);
        }
    }

    public static String aesEncrypt(String content, byte[] encryptKey) throws DataSecurityException {
        try {
            if (StringUtils.isBlank((CharSequence)content)) {
                return content;
            }
            if (null == encryptKey || encryptKey.length < 1) {
                return content;
            }
            byte[] contentBytes = content.getBytes(StandardCharsets.UTF_8);
            byte[] result = Cryptos.aesEncrypt(contentBytes, encryptKey, Cryptos.IV_BYTES);
            return SecretUtils.base64Encode(result);
        }
        catch (CryptException ce) {
            throw new DataSecurityException(ce, ErrorMessage.BUILD_CERTIFICATE_ERROR, ce.getMessage());
        }
        catch (Exception e) {
            throw new DataSecurityException(ErrorMessage.SDK_ERROR.getCode(), "aesEncrypt\u52a0\u5bc6\u51fa\u73b0\u5f02\u5e38");
        }
    }

    private static String aesEncrypt_256(byte[] content, byte[] encryptKey) throws DataSecurityException {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance(AES);
            kgen.init(new SecureRandom(encryptKey));
            IvParameterSpec iv = new IvParameterSpec(IVPS_BYTES);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, (Key)new SecretKeySpec(encryptKey, AES), iv);
            return SecretUtils.base64Encode(cipher.doFinal(content));
        }
        catch (Exception e) {
            throw new DataSecurityException(ErrorMessage.SDK_ERROR.getCode(), "aesEncrypt_256\u52a0\u5bc6\u51fa\u73b0\u5f02\u5e38");
        }
    }

    public static String spliceEncryptContext(String separator, String encryptContext, String version) {
        return separator + encryptContext + separator + version + separator;
    }

    public static String aesDecrypt(String encryptContext, byte[] decryptKey) throws DataSecurityException {
        try {
            if (StringUtils.isBlank((CharSequence)encryptContext)) {
                return encryptContext;
            }
            if (null == decryptKey || decryptKey.length < 1) {
                return encryptContext;
            }
            return new String(SecretUtils.aesDecrypt(Base64_.decode(encryptContext), decryptKey), "UTF-8");
        }
        catch (CryptException ce) {
            throw new DataSecurityException(ce, ErrorMessage.BUILD_CERTIFICATE_ERROR, ce.getMessage());
        }
        catch (DataSecurityException de) {
            throw de;
        }
        catch (Exception e) {
            throw new DataSecurityException(e, ErrorMessage.SDK_ERROR, "aesDecrypt\u89e3\u5bc6\u51fa\u73b0\u5f02\u5e38");
        }
    }

    private static byte[] aesDecrypt(byte[] encryptBytes, byte[] decryptKey) throws DataSecurityException {
        try {
            String result = Cryptos.aesDecrypt(encryptBytes, decryptKey, Cryptos.IV_BYTES);
            return result.getBytes(StandardCharsets.UTF_8);
        }
        catch (CryptException ce) {
            throw new DataSecurityException(ce, ErrorMessage.BUILD_CERTIFICATE_ERROR, ce.getMessage());
        }
        catch (Exception e) {
            throw new DataSecurityException(e);
        }
    }

    private static byte[] aesDecrypt_256(byte[] encryptBytes, byte[] decryptKey) throws DataSecurityException {
        IvParameterSpec iv = new IvParameterSpec(IVPS_BYTES);
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)new SecretKeySpec(decryptKey, AES), iv);
            return cipher.doFinal(Base64_.decode(encryptBytes));
        }
        catch (Exception e) {
            throw new DataSecurityException(e);
        }
    }

    public static String base64Encode(byte[] source) throws UnsupportedEncodingException {
        return SecretUtils.base64Encode(source, "UTF-8");
    }

    public static String base64Encode(byte[] source, String charsetName) throws UnsupportedEncodingException {
        byte[] encoded = Base64_.encodeToByte(source, false);
        return encoded != null ? new String(encoded, charsetName) : null;
    }

    private static byte[] compress(byte[] input, int toLength) {
        int i;
        if (toLength < 0) {
            return null;
        }
        byte[] output = new byte[toLength];
        for (i = 0; i < output.length; ++i) {
            output[i] = 0;
        }
        for (i = 0; i < input.length; ++i) {
            int index_output;
            int n = index_output = i % toLength;
            output[n] = (byte)(output[n] ^ input[i]);
        }
        return output;
    }
}

