/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.base.core.apollo;

import com.tydic.dyc.pro.base.core.apollo.AesGcmCrypto;
import com.tydic.dyc.pro.base.core.apollo.DecryptingCache;
import com.tydic.dyc.pro.base.core.apollo.SecretKeyProvider;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;

class DecryptingPropertySource
extends PropertySource<Object> {
    private static final String PREFIX = "ENC(";
    private static final String SUFFIX = ")";
    private final PropertySource<?> delegate;
    private final boolean enumerable;

    DecryptingPropertySource(PropertySource<?> delegate) {
        super(delegate.getName(), delegate.getSource());
        this.delegate = delegate;
        this.enumerable = delegate instanceof EnumerablePropertySource;
    }

    public Object getProperty(String name) {
        Object v = this.delegate.getProperty(name);
        if (!(v instanceof String)) {
            return v;
        }
        String s = ((String)v).trim();
        if (!s.startsWith(PREFIX) || !s.endsWith(SUFFIX)) {
            return v;
        }
        System.out.println("[ENC-DEC] hit ENC for key='" + name + "' in PS='" + this.delegate.getName() + "'");
        String cached = DecryptingCache.get(name, s);
        if (cached != null) {
            System.out.println("[ENC-DEC] cache hit for key='" + name + "'");
            return cached;
        }
        String payload = s.substring(PREFIX.length(), s.length() - SUFFIX.length());
        try {
            byte[] key = SecretKeyProvider.loadKey();
            String plain = AesGcmCrypto.decryptBase64Url(payload, key);
            DecryptingCache.put(name, s, plain);
            System.out.println("[ENC-DEC] decrypt ok for key='" + name + "'");
            return plain;
        }
        catch (Exception e) {
            System.out.println("[ENC-DEC] decrypt fail for key='" + name + "' err=" + e.getMessage());
            return v;
        }
    }

    public boolean containsProperty(String name) {
        return this.delegate.containsProperty(name);
    }

    public String getName() {
        return this.delegate.getName();
    }

    public Object getSource() {
        return this.delegate.getSource();
    }

    String[] getPropertyNames() {
        if (this.enumerable) {
            return ((EnumerablePropertySource)this.delegate).getPropertyNames();
        }
        return new String[0];
    }

    static PropertySource<?> wrap(PropertySource<?> src) {
        if (src instanceof DecryptingPropertySource) {
            return src;
        }
        if (src instanceof EnumerablePropertySource) {
            return new EnumerableWrapper((EnumerablePropertySource)src);
        }
        return new DecryptingPropertySource(src);
    }

    static class EnumerableWrapper
    extends EnumerablePropertySource<Object> {
        private final EnumerablePropertySource<?> delegate;

        EnumerableWrapper(EnumerablePropertySource<?> delegate) {
            super(delegate.getName(), delegate.getSource());
            this.delegate = delegate;
        }

        public String[] getPropertyNames() {
            return this.delegate.getPropertyNames();
        }

        public Object getProperty(String name) {
            Object v = this.delegate.getProperty(name);
            if (!(v instanceof String)) {
                return v;
            }
            String s = ((String)v).trim();
            if (!s.startsWith(DecryptingPropertySource.PREFIX) || !s.endsWith(DecryptingPropertySource.SUFFIX)) {
                return v;
            }
            System.out.println("[ENC-DEC] hit ENC for key='" + name + "' in PS='" + this.delegate.getName() + "'");
            String cached = DecryptingCache.get(name, s);
            if (cached != null) {
                System.out.println("[ENC-DEC] cache hit for key='" + name + "'");
                return cached;
            }
            String payload = s.substring(DecryptingPropertySource.PREFIX.length(), s.length() - DecryptingPropertySource.SUFFIX.length());
            try {
                byte[] key = SecretKeyProvider.loadKey();
                String plain = AesGcmCrypto.decryptBase64Url(payload, key);
                DecryptingCache.put(name, s, plain);
                System.out.println("[ENC-DEC] decrypt ok for key='" + name + "'");
                return plain;
            }
            catch (Exception e) {
                System.out.println("[ENC-DEC] decrypt fail for key='" + name + "' err=" + e.getMessage());
                return v;
            }
        }
    }
}

