/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.base.core.apollo;

import com.tydic.dyc.pro.base.core.apollo.AesGcmCrypto;
import com.tydic.dyc.pro.base.core.apollo.DecryptingCache;
import com.tydic.dyc.pro.base.core.apollo.DecryptingPropertySource;
import com.tydic.dyc.pro.base.core.apollo.SecretKeyProvider;
import java.util.Iterator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class EncryptedPropertyEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        String topName;
        MutablePropertySources sources = environment.getPropertySources();
        if (sources.get(topName = "encDecTop") == null) {
            sources.addFirst((PropertySource)new TopDecryptingPropertySource(topName, sources));
            System.out.println("[ENC-DEC] addFirst: " + topName + " -> TopDecryptingPropertySource");
        }
        System.out.println("[ENC-DEC] init wrapping property sources ...");
        int wrappedCount = 0;
        int skippedCount = 0;
        for (PropertySource ps : sources) {
            if ("org.springframework.boot.context.properties.source.ConfigurationPropertySourcesPropertySource".equals(ps.getClass().getName())) {
                System.out.println("[ENC-DEC] skip: " + ps.getName() + " {" + ps.getClass().getName() + "}");
                ++skippedCount;
                continue;
            }
            if (topName.equals(ps.getName())) {
                ++skippedCount;
                continue;
            }
            PropertySource<?> wrapped = DecryptingPropertySource.wrap(ps);
            if (wrapped != ps) {
                sources.replace(ps.getName(), wrapped);
                System.out.println("[ENC-DEC] wrap: " + ps.getName() + " -> " + wrapped.getClass().getSimpleName());
                ++wrappedCount;
                continue;
            }
            System.out.println("[ENC-DEC] passthrough: " + ps.getName() + " {" + ps.getClass().getSimpleName() + "}");
            ++skippedCount;
        }
        System.out.println("[ENC-DEC] done. wrapped=" + wrappedCount + ", skipped=" + skippedCount);
    }

    static class TopDecryptingPropertySource
    extends PropertySource<MutablePropertySources> {
        private static final String PREFIX = "ENC(";
        private static final String SUFFIX = ")";
        private static final ThreadLocal<Boolean> IN_RESOLUTION = ThreadLocal.withInitial(() -> Boolean.FALSE);

        TopDecryptingPropertySource(String name, MutablePropertySources sources) {
            super(name, (Object)sources);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public Object getProperty(String name) {
            if (Boolean.TRUE.equals(IN_RESOLUTION.get())) {
                return null;
            }
            IN_RESOLUTION.set(Boolean.TRUE);
            try {
                for (PropertySource ps : (MutablePropertySources)this.source) {
                    Object v;
                    String cn;
                    if (ps == this || (cn = ps.getClass().getName()) != null && cn.startsWith("org.springframework.boot.context.properties.source") || (v = ps.getProperty(name)) == null) continue;
                    if (!(v instanceof String)) {
                        Object object = v;
                        return object;
                    }
                    String s = ((String)v).trim();
                    if (!s.startsWith(PREFIX) || !s.endsWith(SUFFIX)) {
                        Object object = v;
                        return object;
                    }
                    System.out.println("[ENC-DEC] hit ENC for key='" + name + "' in PS='" + ps.getName() + "'");
                    String cached = DecryptingCache.get(name, s);
                    if (cached != null) {
                        System.out.println("[ENC-DEC] cache hit for key='" + name + "'");
                        String string = cached;
                        return string;
                    }
                    String payload = s.substring(PREFIX.length(), s.length() - SUFFIX.length());
                    try {
                        byte[] key = SecretKeyProvider.loadKey();
                        String plain = AesGcmCrypto.decryptBase64Url(payload, key);
                        DecryptingCache.put(name, s, plain);
                        System.out.println("[ENC-DEC] decrypt ok for key='" + name + "'");
                        String string = plain;
                        return string;
                    }
                    catch (Exception e) {
                        System.out.println("[ENC-DEC] decrypt fail for key='" + name + "' err=" + e.getMessage());
                        Object object = v;
                        IN_RESOLUTION.set(Boolean.FALSE);
                        return object;
                    }
                }
                Iterator iterator = null;
                return iterator;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IN_RESOLUTION.set(Boolean.FALSE);
            }
        }
    }
}

