/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.base.core.apollo;

import com.tydic.dyc.pro.base.core.apollo.DecryptingPropertySource;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class LateDecryptingPropertySourcesListener
implements ApplicationListener<ApplicationPreparedEvent> {
    private static final String BOOT_BINDER_PS_PREFIX = "org.springframework.boot.context.properties.source";
    private static final String TOP_NAME = "encDecTop";

    public void onApplicationEvent(ApplicationPreparedEvent event) {
        ConfigurableEnvironment env = event.getApplicationContext().getEnvironment();
        MutablePropertySources sources = env.getPropertySources();
        int wrapped = 0;
        int skipped = 0;
        System.out.println("[ENC-DEC-LATE] scanning property sources for wrapping ...");
        for (PropertySource ps : sources) {
            String cn = ps.getClass().getName();
            if (cn != null && cn.startsWith(BOOT_BINDER_PS_PREFIX)) {
                System.out.println("[ENC-DEC-LATE] skip binder: " + ps.getName() + " {" + cn + "}");
                ++skipped;
                continue;
            }
            if (TOP_NAME.equals(ps.getName())) {
                ++skipped;
                continue;
            }
            if (ps instanceof DecryptingPropertySource || ps instanceof DecryptingPropertySource.EnumerableWrapper) {
                ++skipped;
                continue;
            }
            PropertySource<?> wrappedPs = DecryptingPropertySource.wrap(ps);
            if (wrappedPs != ps) {
                sources.replace(ps.getName(), wrappedPs);
                System.out.println("[ENC-DEC-LATE] wrap: " + ps.getName() + " -> " + wrappedPs.getClass().getSimpleName());
                ++wrapped;
                continue;
            }
            System.out.println("[ENC-DEC-LATE] passthrough: " + ps.getName() + " {" + ps.getClass().getSimpleName() + "}");
            ++skipped;
        }
        System.out.println("[ENC-DEC-LATE] done. wrapped=" + wrapped + ", skipped=" + skipped);
    }
}

