/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.cfc.ability.impl;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.cfc.ability.api.CfcDictionaryAbilityService;
import com.tydic.cfc.ability.bo.CfcDicDictionaryBO;
import com.tydic.cfc.ability.bo.CfcDicDictionaryReqBO;
import com.tydic.cfc.ability.bo.CfcDictionaryAbilityRspBO;
import com.tydic.cfc.ability.bo.CfcQueryDictionaryAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcRspListBO;
import com.tydic.cfc.ability.bo.CfcRspPageBO;
import com.tydic.cfc.busi.api.CfcDictionaryBusiService;
import com.tydic.cfc.busi.bo.CfcDictionaryBusiReqBO;
import com.tydic.cfc.exceptions.CfcBusinessException;
import com.tydic.dyc.base.core.dictionary.bo.DictDataBo;
import com.tydic.dyc.base.core.dictionary.utils.DictFrameworkUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CFC_GROUP_DEV/2.1.0/com.tydic.cfc.ability.api.CfcDictionaryAbilityService"})
public class CfcDictionaryAbilityServiceImpl
implements CfcDictionaryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(CfcDictionaryAbilityServiceImpl.class);
    @Autowired
    private CfcDictionaryBusiService dictionaryBusiService;
    @Autowired
    private CacheClient cacheClient;

    @PostMapping(value={"queryBypCodeBackPo"})
    public CfcRspListBO<CfcDicDictionaryBO> queryBypCodeBackPo(@RequestBody CfcQueryDictionaryAbilityReqBO abilityReqBO) {
        CfcRspListBO result = new CfcRspListBO();
        DictDataBo dictData = DictFrameworkUtils.getDictDataByValue((String)"UMC_PLUS", (String)abilityReqBO.getPcode(), (String)abilityReqBO.getTitle());
        ArrayList<CfcDicDictionaryBO> busiList = new ArrayList<CfcDicDictionaryBO>();
        if (dictData != null) {
            CfcDicDictionaryBO bo = new CfcDicDictionaryBO();
            bo.setSysCode(dictData.getBusiCenter());
            bo.setPCode(dictData.getPCode());
            bo.setTitle(dictData.getValue());
            bo.setCode(dictData.getCode());
            bo.setDescrip(dictData.getRemark());
            bo.setOrderId(dictData.getSort());
            bo.setDelflag(Integer.valueOf(0));
            busiList.add(bo);
        }
        result.setRows(busiList);
        result.setRespCode("0000");
        result.setRespDesc("\u67e5\u8be2\u6210\u529f");
        return result;
    }

    @PostMapping(value={"queryBypCodeBackPoPage"})
    public CfcRspPageBO<CfcDicDictionaryBO> queryBypCodeBackPoPage(@RequestBody CfcQueryDictionaryAbilityReqBO abilityReqBO) {
        CfcRspPageBO result = new CfcRspPageBO();
        CfcDictionaryBusiReqBO dictionaryBusiReqBO = new CfcDictionaryBusiReqBO();
        BeanUtils.copyProperties((Object)abilityReqBO, (Object)((Object)dictionaryBusiReqBO));
        CfcRspPageBO<CfcDicDictionaryBO> busiList = this.dictionaryBusiService.queryBypCodeBackPoPage(dictionaryBusiReqBO);
        BeanUtils.copyProperties(busiList, (Object)result);
        return result;
    }

    @PostMapping(value={"updateDicDictionary"})
    public CfcDictionaryAbilityRspBO updateDicDictionary(@RequestBody CfcDicDictionaryReqBO umcDicDictionaryBO) {
        this.validationParamsInvoice(umcDicDictionaryBO);
        CfcDictionaryAbilityRspBO dictionaryAbilityRspBO = new CfcDictionaryAbilityRspBO();
        dictionaryAbilityRspBO.setRespCode("0000");
        dictionaryAbilityRspBO.setRespDesc("\u6210\u529f");
        int checkResult = this.dictionaryBusiService.checkDicBy(umcDicDictionaryBO.getCode(), umcDicDictionaryBO.getPCode());
        if (checkResult < 1) {
            dictionaryAbilityRspBO.setRespCode("163033");
            dictionaryAbilityRspBO.setRespDesc("\u8be5\u5b57\u5178\u8bb0\u5f55\u4e0d\u5b58\u5728");
            return dictionaryAbilityRspBO;
        }
        umcDicDictionaryBO.setSysCode("UMC");
        umcDicDictionaryBO.setDelflag(Integer.valueOf(1));
        int result = this.dictionaryBusiService.updateDicDictionary(umcDicDictionaryBO);
        if (result < 1) {
            dictionaryAbilityRspBO.setRespCode("163033");
            dictionaryAbilityRspBO.setRespDesc("\u4fee\u6539\u5931\u8d25");
        }
        return dictionaryAbilityRspBO;
    }

    @PostMapping(value={"deleteDicDictionary"})
    public CfcDictionaryAbilityRspBO deleteDicDictionary(@RequestBody CfcDicDictionaryReqBO umcDicDictionaryBO) {
        this.validationParamsInvoice(umcDicDictionaryBO);
        CfcDictionaryAbilityRspBO dictionaryAbilityRspBO = new CfcDictionaryAbilityRspBO();
        dictionaryAbilityRspBO.setRespCode("0000");
        dictionaryAbilityRspBO.setRespDesc("\u6210\u529f");
        int checkResult = this.dictionaryBusiService.checkDicBy(umcDicDictionaryBO.getCode(), umcDicDictionaryBO.getPCode());
        if (checkResult < 1) {
            dictionaryAbilityRspBO.setRespCode("163033");
            dictionaryAbilityRspBO.setRespDesc("\u8be5\u5b57\u5178\u8bb0\u5f55\u4e0d\u5b58\u5728");
            return dictionaryAbilityRspBO;
        }
        int result = this.dictionaryBusiService.deleteDicDictionary(umcDicDictionaryBO);
        if (result < 1) {
            dictionaryAbilityRspBO.setRespCode("163033");
            dictionaryAbilityRspBO.setRespDesc("\u5220\u9664\u5931\u8d25");
        }
        return dictionaryAbilityRspBO;
    }

    @PostMapping(value={"addDicDictionary"})
    public CfcDictionaryAbilityRspBO addDicDictionary(@RequestBody CfcDicDictionaryReqBO umcDicDictionaryBO) {
        this.validationParamsInvoice(umcDicDictionaryBO);
        CfcDictionaryAbilityRspBO dictionaryAbilityRspBO = new CfcDictionaryAbilityRspBO();
        dictionaryAbilityRspBO.setRespCode("0000");
        dictionaryAbilityRspBO.setRespDesc("\u6210\u529f");
        int checkResult = this.dictionaryBusiService.checkDicBy(umcDicDictionaryBO.getCode(), umcDicDictionaryBO.getPCode());
        if (checkResult > 0) {
            dictionaryAbilityRspBO.setRespCode("163033");
            dictionaryAbilityRspBO.setRespDesc("\u8be5\u5b57\u5178\u5df2\u5b58\u5728");
            return dictionaryAbilityRspBO;
        }
        umcDicDictionaryBO.setDelflag(Integer.valueOf(1));
        umcDicDictionaryBO.setSysCode("UMC");
        int result = this.dictionaryBusiService.addDicDictionary(umcDicDictionaryBO);
        if (result < 1) {
            dictionaryAbilityRspBO.setRespCode("163033");
            dictionaryAbilityRspBO.setRespDesc("\u65b0\u589e\u5931\u8d25");
        }
        return dictionaryAbilityRspBO;
    }

    @RequestMapping(value={"queryBypCodeBackPoByPcode"})
    @PostMapping(value={"queryBypCodeBackPo"})
    public Map<String, String> queryBypCodeBackPo(@RequestBody String pCode) {
        List dictList = DictFrameworkUtils.getListByCenterAndPCode((String)"UMC_PLUS", (String)pCode);
        Map<String, String> map = null;
        if (!CollectionUtils.isEmpty((Collection)dictList)) {
            map = dictList.stream().collect(Collectors.toMap(DictDataBo::getCode, DictDataBo::getValue));
        }
        return map;
    }

    @PostMapping(value={"queryBypCodeBackMap"})
    public Map<String, String> queryBypCodeBackMap(@RequestBody CfcQueryDictionaryAbilityReqBO reqBO) {
        List dictList = DictFrameworkUtils.getListByCenterAndPCode((String)"UMC_PLUS", (String)reqBO.getPcode());
        Map<String, String> map = null;
        if (!CollectionUtils.isEmpty((Collection)dictList)) {
            map = dictList.stream().collect(Collectors.toMap(DictDataBo::getCode, DictDataBo::getValue));
        }
        return map;
    }

    @PostMapping(value={"queryDicByCache"})
    public List<CfcDicDictionaryBO> queryDicByCache(@RequestBody String pCode) {
        if (StringUtils.isBlank((CharSequence)pCode)) {
            return new ArrayList<CfcDicDictionaryBO>();
        }
        Object obj = this.cacheClient.get("PES_UMC_DIC_CACHE_REDIS_" + pCode);
        List<CfcDicDictionaryBO> busiList = (List<CfcDicDictionaryBO>)obj;
        if (CollectionUtils.isEmpty((Collection)busiList)) {
            busiList = this.dictionaryBusiService.queryBypCodeBackPo("UMC", pCode, "");
            if (CollectionUtils.isEmpty(busiList)) {
                busiList = new ArrayList<CfcDicDictionaryBO>();
            }
            this.cacheClient.set("PES_UMC_DIC_CACHE_REDIS_" + pCode, busiList);
        }
        return busiList;
    }

    @PostMapping(value={"delCacheDic"})
    public CfcDictionaryAbilityRspBO delCacheDic(@RequestBody CfcDicDictionaryReqBO umcDicDictionaryBO) {
        umcDicDictionaryBO.getPcodeList().forEach(pcode -> this.cacheClient.delete(pcode));
        CfcDictionaryAbilityRspBO dictionaryAbilityRspBO = new CfcDictionaryAbilityRspBO();
        dictionaryAbilityRspBO.setRespCode("0000");
        dictionaryAbilityRspBO.setRespDesc("\u6210\u529f");
        return dictionaryAbilityRspBO;
    }

    private void validationParamsInvoice(CfcDicDictionaryReqBO reqBO) {
        if (StringUtils.isEmpty((CharSequence)reqBO.getPCode())) {
            throw new CfcBusinessException("162001", "\u5b57\u5178\u670d\u52a1\u5165\u53c2[pcode]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getCode())) {
            throw new CfcBusinessException("162001", "\u5b57\u5178\u670d\u52a1\u5165\u53c2[code]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

