/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.cfc.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.cfc.busi.api.CfcCloudProxyService;
import com.tydic.cfc.busi.bo.CfcCloudProxyServiceReqBO;
import com.tydic.cfc.busi.bo.CfcCloudProxyServiceRspBO;
import com.tydic.cfc.busi.bo.CfcTransServiceDataBO;
import com.tydic.cfc.dao.CfcRelServiceBackMapper;
import com.tydic.cfc.dao.CfcTransRollbackRecordMapper;
import com.tydic.cfc.exceptions.CfcBusinessException;
import com.tydic.cfc.po.CfcRelServiceBackPO;
import com.tydic.cfc.po.CfcTransRollbackRecordPO;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service(value="cfcCloudProxyService")
public class CfcCloudProxyServiceImpl
implements CfcCloudProxyService {
    private static final Logger log = LoggerFactory.getLogger(CfcCloudProxyServiceImpl.class);
    private static final String HTTP_PRE = "https://";
    private static final String SLASH = "/";
    private static final String RSP_CODE = "respCode";
    private static final String SUCCESS_CODE = "0000";
    private static final int BACK_STATUS_SUCCESS = 1;
    private static final int BACK_STATUS_FAIL = 0;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private CfcTransRollbackRecordMapper cfcTransRollbackRecordMapper;
    @Autowired
    private CfcRelServiceBackMapper cfcRelServiceBackMapper;

    @Override
    public CfcCloudProxyServiceRspBO executeCallChain(CfcCloudProxyServiceReqBO reqBO) {
        CfcCloudProxyServiceRspBO rspBO = new CfcCloudProxyServiceRspBO();
        List<CfcTransServiceDataBO> list = reqBO.getList();
        if (CollectionUtils.isEmpty(list)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u56de\u6eda\u4e8b\u52a1\u8c03\u7528\u94fe\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        for (CfcTransServiceDataBO bo : list) {
            CfcRelServiceBackPO relServiceBackPo = new CfcRelServiceBackPO();
            relServiceBackPo.setServiceCode(bo.getServiceCode());
            relServiceBackPo.setMethodCode(bo.getMethodCode());
            CfcRelServiceBackPO resultPo = this.cfcRelServiceBackMapper.getModelBy(relServiceBackPo);
            JSONObject reqJsonObj = JSON.parseObject((String)bo.getReqInfo());
            Map rspMap = (Map)JSON.parseObject((String)bo.getRspInfo(), Map.class);
            reqJsonObj.putAll(rspMap);
            String reqJson = reqJsonObj.toJSONString();
            CfcTransRollbackRecordPO recordPo = new CfcTransRollbackRecordPO();
            BeanUtils.copyProperties((Object)bo, (Object)recordPo);
            recordPo.setBackReqInfo(reqJson);
            recordPo.setBackServiceCode(recordPo.getBackServiceCode());
            recordPo.setBackMethodCode(recordPo.getBackMethodCode());
            recordPo.setCreateTime(new Date());
            this.cfcTransRollbackRecordMapper.insert(recordPo);
            String url = HTTP_PRE + resultPo.getBackGroup() + SLASH + resultPo.getBackVersion() + SLASH + resultPo.getBackServiceCode() + SLASH + resultPo.getBackMethodCode();
            String rspBody = this.doPost(url, reqJson);
            CfcTransRollbackRecordPO afterCall = new CfcTransRollbackRecordPO();
            afterCall.setTransId(bo.getTransId());
            JSONObject rspJson = JSON.parseObject((String)rspBody);
            if (rspJson.getString(RSP_CODE).equals(SUCCESS_CODE)) {
                afterCall.setBackStatus(1);
            }
            afterCall.setBackStatus(0);
            afterCall.setUpdateTime(new Date());
            this.cfcTransRollbackRecordMapper.updateBy(recordPo, afterCall);
        }
        rspBO.setRespCode(SUCCESS_CODE);
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private String doPost(String url, String body) {
        HttpHeaders httpHeaders = new HttpHeaders();
        HttpEntity httpEntity = new HttpEntity((Object)body, (MultiValueMap)httpHeaders);
        ResponseEntity response = null;
        try {
            response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, String.class, new Object[0]);
        }
        catch (Exception e) {
            log.error("\u5f02\u5e38", (Throwable)e);
            throw new CfcBusinessException("8888", "\u6389\u7528\u56de\u6eda\u670d\u52a1\u5f02\u5e38\uff0c\u670d\u52a1\u5730\u5740\uff1a" + url);
        }
        return (String)response.getBody();
    }
}

