/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.cfc.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.cfc.ability.bo.CfcDicDictionaryBO;
import com.tydic.cfc.ability.bo.CfcDicDictionaryReqBO;
import com.tydic.cfc.ability.bo.CfcRspPageBO;
import com.tydic.cfc.busi.api.CfcDictionaryBusiService;
import com.tydic.cfc.busi.bo.CfcDictionaryBusiReqBO;
import com.tydic.cfc.dao.CfcDicDictionaryMapper;
import com.tydic.cfc.po.CfcDicDictionaryPO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class CfcDictionaryBusiServiceImpl
implements CfcDictionaryBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CfcDictionaryBusiServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private static final String SYS_CODE_DEFAULT = "UMC";
    private static final Integer DIC_ORDER_ID = 1;
    @Autowired
    private CfcDicDictionaryMapper dicDictionaryMapper;

    @Override
    public List<CfcDicDictionaryBO> queryBypCodeBackPo(String pCode) {
        return this.queryBypCodeBackPo(null, pCode);
    }

    @Override
    public List<CfcDicDictionaryBO> queryBypCodeBackPo(String sysCode, String pCode) {
        ArrayList<CfcDicDictionaryBO> dicDictionaryBOS = new ArrayList<CfcDicDictionaryBO>();
        List<CfcDicDictionaryPO> dicDictionaryPOS = this.dicDictionaryMapper.getListByCondition(this.getCfcDicDictionaryPO(sysCode, pCode));
        if (dicDictionaryPOS != null) {
            for (CfcDicDictionaryPO dicDictionaryPO : dicDictionaryPOS) {
                CfcDicDictionaryBO dicDictionaryBO = new CfcDicDictionaryBO();
                BeanUtils.copyProperties((Object)dicDictionaryPO, (Object)dicDictionaryBO);
                dicDictionaryBOS.add(dicDictionaryBO);
            }
        }
        return dicDictionaryBOS;
    }

    @Override
    public CfcRspPageBO<CfcDicDictionaryBO> queryBypCodeBackPoPage(CfcDictionaryBusiReqBO dictionaryBusiReqBO) {
        CfcDicDictionaryPO dicDictionary = new CfcDicDictionaryPO();
        ArrayList<CfcDicDictionaryBO> rows = new ArrayList<CfcDicDictionaryBO>();
        dicDictionary.setSysCode(dictionaryBusiReqBO.getSysCode());
        dicDictionary.setPCode(dictionaryBusiReqBO.getPcode());
        dicDictionary.setTitle(dictionaryBusiReqBO.getTitle());
        Page page = new Page(dictionaryBusiReqBO.getPageNo().intValue(), dictionaryBusiReqBO.getPageSize().intValue());
        CfcRspPageBO dicDictionaryBOS = new CfcRspPageBO();
        List<CfcDicDictionaryPO> dicDictionaryPOS = this.dicDictionaryMapper.getListPageByCondition(dicDictionary, page);
        if (dicDictionaryPOS != null) {
            for (CfcDicDictionaryPO dicDictionaryPO : dicDictionaryPOS) {
                CfcDicDictionaryBO dicDictionaryBO = new CfcDicDictionaryBO();
                BeanUtils.copyProperties((Object)dicDictionaryPO, (Object)dicDictionaryBO);
                rows.add(dicDictionaryBO);
            }
        }
        dicDictionaryBOS.setRespCode("0000");
        dicDictionaryBOS.setRespDesc("\u67e5\u8be2\u6210\u529f");
        dicDictionaryBOS.setRows(rows);
        dicDictionaryBOS.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        dicDictionaryBOS.setTotal(Integer.valueOf(page.getTotalPages()));
        dicDictionaryBOS.setPageNo(Integer.valueOf(page.getPageNo()));
        return dicDictionaryBOS;
    }

    @Override
    public List<CfcDicDictionaryBO> queryBypCodeBackPo(String sysCode, String pCode, String title) {
        CfcDicDictionaryPO dicDictionary = new CfcDicDictionaryPO();
        dicDictionary.setSysCode(sysCode);
        dicDictionary.setPCode(pCode);
        dicDictionary.setTitle(title);
        if (StringUtils.isEmpty((Object)dicDictionary.getOrderBy())) {
            dicDictionary.setOrderBy("ORDER_ID");
        }
        ArrayList<CfcDicDictionaryBO> dicDictionaryBOS = new ArrayList<CfcDicDictionaryBO>();
        List<CfcDicDictionaryPO> dicDictionaryPOS = this.dicDictionaryMapper.getListByCondition(dicDictionary);
        if (dicDictionaryPOS != null) {
            for (CfcDicDictionaryPO dicDictionaryPO : dicDictionaryPOS) {
                CfcDicDictionaryBO dicDictionaryBO = new CfcDicDictionaryBO();
                BeanUtils.copyProperties((Object)dicDictionaryPO, (Object)dicDictionaryBO);
                dicDictionaryBOS.add(dicDictionaryBO);
            }
        }
        return dicDictionaryBOS;
    }

    @Override
    public Map<String, String> queryBypCodeBackMap(String pCode) {
        return this.queryBypCodeBackMap(null, pCode);
    }

    @Override
    public Map<String, String> queryBypCodeBackMap(String sysCode, String pCode) {
        List<CfcDicDictionaryPO> listPo = this.dicDictionaryMapper.getListByCondition(this.getCfcDicDictionaryPO(sysCode, pCode));
        if (listPo == null || listPo.size() == 0) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (CfcDicDictionaryPO po : listPo) {
            map.put(po.getCode(), po.getTitle());
        }
        return map;
    }

    @Override
    public CfcDicDictionaryBO getDictionaryByBO(CfcDicDictionaryBO dicDictionaryBO) {
        CfcDicDictionaryBO dictionaryBO = new CfcDicDictionaryBO();
        CfcDicDictionaryPO dicDictionaryModel = new CfcDicDictionaryPO();
        BeanUtils.copyProperties((Object)dicDictionaryBO, (Object)dicDictionaryModel);
        CfcDicDictionaryPO dicDictionaryPO = this.dicDictionaryMapper.getModelByCondition(dicDictionaryModel);
        if (null != dicDictionaryPO) {
            BeanUtils.copyProperties((Object)dicDictionaryPO, (Object)dictionaryBO);
        }
        return dictionaryBO;
    }

    public CfcDicDictionaryPO getCfcDicDictionaryPO(String sysCode, String pCode) {
        CfcDicDictionaryPO queryDictionaryPO = new CfcDicDictionaryPO();
        queryDictionaryPO.setPCode(pCode);
        if (StringUtils.isEmpty((Object)sysCode)) {
            sysCode = SYS_CODE_DEFAULT;
        }
        queryDictionaryPO.setSysCode(sysCode);
        return queryDictionaryPO;
    }

    @Override
    public int updateDicDictionary(CfcDicDictionaryReqBO dicDictionaryBO) {
        CfcDicDictionaryPO dicDictionaryModel = new CfcDicDictionaryPO();
        dicDictionaryModel.setTitle(dicDictionaryBO.getTitle());
        dicDictionaryModel.setOrderId(dicDictionaryBO.getOrderId());
        dicDictionaryModel.setDescrip(dicDictionaryBO.getDescrip());
        dicDictionaryModel.setDelFlag(dicDictionaryBO.getDelflag());
        dicDictionaryModel.setSysCode(dicDictionaryBO.getSysCode());
        dicDictionaryModel.setCode(dicDictionaryBO.getCode());
        dicDictionaryModel.setPCode(dicDictionaryBO.getPCode());
        return this.dicDictionaryMapper.updateByCondition(dicDictionaryModel);
    }

    @Override
    public int addDicDictionary(CfcDicDictionaryReqBO dicDictionaryBO) {
        CfcDicDictionaryPO dicDictionaryModel = new CfcDicDictionaryPO();
        dicDictionaryModel.setTitle(dicDictionaryBO.getTitle());
        dicDictionaryModel.setOrderId(DIC_ORDER_ID);
        dicDictionaryModel.setDescrip(dicDictionaryBO.getDescrip());
        dicDictionaryModel.setDelFlag(dicDictionaryBO.getDelflag());
        dicDictionaryModel.setSysCode(dicDictionaryBO.getSysCode());
        dicDictionaryModel.setCode(dicDictionaryBO.getCode());
        dicDictionaryModel.setPCode(dicDictionaryBO.getPCode());
        return this.dicDictionaryMapper.insert(dicDictionaryModel);
    }

    @Override
    public int deleteDicDictionary(CfcDicDictionaryReqBO dicDictionaryBO) {
        CfcDicDictionaryPO dicDictionaryModel = new CfcDicDictionaryPO();
        dicDictionaryModel.setCode(dicDictionaryBO.getCode());
        dicDictionaryModel.setPCode(dicDictionaryBO.getPCode());
        return this.dicDictionaryMapper.deleteByCondition(dicDictionaryModel);
    }

    @Override
    public int checkDicBy(String code, String pCode) {
        CfcDicDictionaryPO dicDictionaryModel = new CfcDicDictionaryPO();
        dicDictionaryModel.setPCode(pCode);
        dicDictionaryModel.setCode(code);
        return this.dicDictionaryMapper.getCheckBy(dicDictionaryModel);
    }
}

